/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.client.dimension.renderer;

import argent_matter.gcyr.GCYRClient;
import argent_matter.gcyr.client.dimension.renderer.StarInformation;
import argent_matter.gcyr.mixin.LevelRendererAccessor;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class SkyUtil {
    private static VertexBuffer customSkyBuffer;

    private static BufferBuilder.RenderedBuffer buildSkyDisc(BufferBuilder builder) {
        float radius = 128.0f;
        RenderSystem.setShader(GameRenderer::m_172808_);
        builder.m_166779_(GCYRClient.MODE_QUAD_STRIP, DefaultVertexFormat.f_85814_);
        int stacks = 6;
        int slices = 12;
        for (int i = 0; i <= stacks; ++i) {
            float lat0 = (float)Math.PI * (-0.5f + (float)(i - 1) / (float)stacks);
            float z0 = Mth.m_14031_((float)lat0);
            float zr0 = Mth.m_14089_((float)lat0);
            float lat1 = (float)Math.PI * (-0.5f + (float)i / (float)stacks);
            float z1 = Mth.m_14031_((float)lat1);
            float zr1 = Mth.m_14089_((float)lat1);
            for (int j = 0; j <= slices; ++j) {
                float lng = (float)Math.PI * 2 * (float)(j - 1) / (float)slices;
                float x = Mth.m_14089_((float)lng);
                float y = Mth.m_14031_((float)lng);
                builder.m_5483_((double)(radius * x * zr0), (double)(radius * y * zr0), (double)(radius * z0)).m_5752_();
                builder.m_5483_((double)(radius * x * zr1), (double)(radius * y * zr1), (double)(radius * z1)).m_5752_();
            }
        }
        return builder.m_231175_();
    }

    public static float getScale() {
        Minecraft minecraft = Minecraft.m_91087_();
        float distance = (float)(-3000.0 + minecraft.f_91074_.m_20186_() * 4.5);
        float scale = 100.0f * (0.2f - distance / 10000.0f);
        return Math.max(scale, 0.5f);
    }

    public static void preRender(ClientLevel level, LevelRenderer levelRenderer, Camera camera, Matrix4f projectionMatrix, BufferBuilder bufferBuilder, int sunsetAngle, PoseStack poseStack, float tickDelta, boolean doFullSky) {
        Vec3 vec3d = level.m_171660_(camera.m_90583_(), tickDelta);
        float r = (float)vec3d.m_7096_();
        float g = (float)vec3d.m_7098_();
        float b = (float)vec3d.m_7094_();
        FogRenderer.m_109036_();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        VertexBuffer skyBuffer = doFullSky ? customSkyBuffer : ((LevelRendererAccessor)levelRenderer).getSkyBuffer();
        skyBuffer.m_85921_();
        skyBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, RenderSystem.getShader());
        VertexBuffer.m_85931_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        SkyUtil.renderColouring(bufferBuilder, poseStack, level, tickDelta, level.m_46942_(tickDelta), sunsetAngle);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void postRender(GameRenderer renderer, ClientLevel level, float tickDelta) {
        Vec3 vec3d = level.m_171660_(renderer.m_109153_().m_90583_(), tickDelta);
        float f = (float)vec3d.m_7096_();
        float g = (float)vec3d.m_7098_();
        float h = (float)vec3d.m_7094_();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (level.m_104583_().m_108882_()) {
            RenderSystem.setShaderColor((float)(f * 0.2f + 0.04f), (float)(g * 0.2f + 0.04f), (float)(h * 0.6f + 0.1f), (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)f, (float)g, (float)h, (float)1.0f);
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static boolean isSubmerged(Camera camera) {
        FogType cameraSubmersionType = camera.m_167685_();
        if (cameraSubmersionType.equals((Object)FogType.POWDER_SNOW) || cameraSubmersionType.equals((Object)FogType.LAVA)) {
            return true;
        }
        Entity entity = camera.m_90592_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity.m_21023_(MobEffects.f_19610_) || livingEntity.m_21023_(MobEffects.f_216964_);
        }
        return false;
    }

    public static void startRendering(PoseStack poseStack, Vector3f rotation) {
        poseStack.m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation.y()));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(rotation.z()));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(rotation.x()));
    }

    private static void endRendering(PoseStack poseStack) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    public static void render(PoseStack poseStack, BufferBuilder bufferBuilder, ResourceLocation texture, int colour, Vector3f rotation, float scale, boolean blending) {
        SkyUtil.startRendering(poseStack, rotation);
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderColor((float)((float)(colour >> 16 & 0xFF) / 255.0f), (float)((float)(colour >> 8 & 0xFF) / 255.0f), (float)((float)(colour & 0xFF) / 255.0f), (float)1.0f);
        if (blending) {
            RenderSystem.enableBlend();
        } else {
            RenderSystem.disableBlend();
        }
        Matrix4f positionMatrix = poseStack.m_85850_().m_252922_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferBuilder.m_252986_(positionMatrix, -scale, 100.0f, -scale).m_7421_(1.0f, 0.0f).m_6122_(colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF, 255).m_5752_();
        bufferBuilder.m_252986_(positionMatrix, scale, 100.0f, -scale).m_7421_(0.0f, 0.0f).m_6122_(colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF, 255).m_5752_();
        bufferBuilder.m_252986_(positionMatrix, scale, 100.0f, scale).m_7421_(0.0f, 1.0f).m_6122_(colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF, 255).m_5752_();
        bufferBuilder.m_252986_(positionMatrix, -scale, 100.0f, scale).m_7421_(1.0f, 1.0f).m_6122_(colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF, 255).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        SkyUtil.endRendering(poseStack);
    }

    public static BufferBuilder.RenderedBuffer renderStars(BufferBuilder buffer, int stars, boolean colouredStars) {
        RenderSystem.setShader(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        StarInformation info = StarInformation.STAR_CACHE.apply(0L, stars);
        for (int i = 0; i < stars; ++i) {
            Vector3f vec3f = info.getParam1(i);
            float d = vec3f.x();
            float e = vec3f.y();
            float f = vec3f.z();
            float g = info.getMultiplier(i);
            float h = d * d + e * e + f * f;
            if (h >= 1.0f || h <= 0.01f) continue;
            h = 1.0f / Mth.m_14116_((float)h);
            float j = (d *= h) * 100.0f;
            float k = (e *= h) * 100.0f;
            float l = (f *= h) * 100.0f;
            float m = (float)Math.atan2(d, f);
            float n = Mth.m_14031_((float)m);
            float o = Mth.m_14089_((float)m);
            float p = (float)Math.atan2(Mth.m_14116_((float)(d * d + f * f)), e);
            float q = Mth.m_14031_((float)p);
            float r = Mth.m_14089_((float)p);
            float s = info.getRandomPi(i);
            float t = Mth.m_14031_((float)s);
            float u = Mth.m_14089_((float)s);
            for (int v = 0; v < 4; ++v) {
                float x = (float)((v & 2) - 1) * g;
                float y = (float)((v + 1 & 2) - 1) * g;
                float aa = x * u - y * t;
                float ac = y * u + x * t;
                float ae = aa * -r;
                int colour = info.getColour(i, v, colouredStars);
                buffer.m_5483_((double)(j + ae * n - ac * o), (double)(k + aa * q), (double)(l + ac * n + ae * o)).m_6122_(colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF, colour >> 24 & 0xFF).m_5752_();
            }
        }
        return buffer.m_231175_();
    }

    public static float[] getMarsColour(float skyAngle) {
        float[] colours = new float[4];
        float cosine = Mth.m_14089_((float)(skyAngle * ((float)Math.PI * 2))) - 0.0f;
        if (cosine >= -0.4f && cosine <= 0.4f) {
            float c = (cosine + 0.0f) / 0.4f * 0.5f + 0.5f;
            float sine = 1.0f - (1.0f - Mth.m_14031_((float)(c * (float)Math.PI))) * 0.99f;
            sine *= sine;
            colours[0] = c * 0.3f;
            colours[1] = c * c * 0.6f + 0.55f;
            colours[2] = c * c * 0.0f + 0.8f;
            colours[3] = sine;
            return colours;
        }
        return null;
    }

    public static void renderColouring(BufferBuilder bufferBuilder, PoseStack poseStack, ClientLevel level, float tickDelta, float timeOfDay, int sunsetAngle) {
        float[] fogColours = level.m_104583_().m_7518_(timeOfDay, tickDelta);
        if (fogColours == null) {
            return;
        }
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        float sine = Mth.m_14031_((float)level.m_46490_(tickDelta)) < 0.0f ? 180.0f : 0.0f;
        poseStack.m_252781_(Axis.f_252403_.m_252977_(sine));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_252986_(matrix4f, 0.0f, 100.0f, 0.0f).m_85950_(fogColours[0], fogColours[1], fogColours[2], fogColours[3]).m_5752_();
        for (int i = 0; i <= 16; ++i) {
            float o = (float)i * ((float)Math.PI * 2) / 16.0f;
            float cosine = Mth.m_14089_((float)o);
            bufferBuilder.m_252986_(matrix4f, Mth.m_14031_((float)o) * 120.0f, cosine * 120.0f, -cosine * 40.0f * fogColours[3]).m_85950_(fogColours[0], fogColours[1], fogColours[2], 0.0f).m_5752_();
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        poseStack.m_85849_();
    }

    static {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        if (customSkyBuffer != null) {
            customSkyBuffer.close();
        }
        customSkyBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        BufferBuilder.RenderedBuffer buffer = SkyUtil.buildSkyDisc(bufferbuilder);
        customSkyBuffer.m_85921_();
        customSkyBuffer.m_231221_(buffer);
        VertexBuffer.m_85931_();
    }
}

