/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.common.data;

import argent_matter.gcyr.GCYR;
import argent_matter.gcyr.api.registries.GCYRRegistries;
import argent_matter.gcyr.common.data.GCYRBlocks;
import argent_matter.gcyr.common.data.GCYRRecipeTypes;
import argent_matter.gcyr.common.machine.electric.OxygenSpreaderMachine;
import argent_matter.gcyr.common.machine.multiblock.RocketScannerMachine;
import argent_matter.gcyr.common.machine.multiblock.SpaceStationPackagerMachine;
import argent_matter.gcyr.common.machine.multiblock.electric.DroneHangarMachine;
import argent_matter.gcyr.common.machine.multiblock.electric.DysonSystemControllerMachine;
import argent_matter.gcyr.data.recipe.GCYRTags;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.SimpleTieredMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.pattern.FactoryBlockPattern;
import com.gregtechceu.gtceu.api.pattern.MultiblockShapeInfo;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.OverclockingLogic;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.gregtechceu.gtceu.api.registry.registrate.MachineBuilder;
import com.gregtechceu.gtceu.client.renderer.machine.TieredHullMachineRenderer;
import com.gregtechceu.gtceu.common.data.GCYMBlocks;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeModifiers;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.tterrag.registrate.util.entry.BlockEntry;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class GCYRMachines {
    public static final int[] ELECTRIC_TIERS = GTValues.tiersBetween((int)1, (int)(GTCEuAPI.isHighTier() ? 13 : 8));
    public static final int[] LOW_TIERS = GTValues.tiersBetween((int)1, (int)4);
    public static final int[] HIGH_TIERS = GTValues.tiersBetween((int)5, (int)(GTCEuAPI.isHighTier() ? 13 : 9));
    public static final Int2IntFunction defaultTankSizeFunction = tier -> (tier <= 1 ? 8 : (tier == 2 ? 12 : (tier == 3 ? 16 : (tier == 4 ? 32 : 64)))) * 1000;
    public static final MachineDefinition[] OXYGEN_SPREADER = GCYRMachines.registerTieredMachines("oxygen_spreader", (x$0, x$1) -> new OxygenSpreaderMachine((IMachineBlockEntity)x$0, (int)x$1, new Object[0]), (tier, builder) -> builder.langValue("%s Oxygen Spreader".formatted(GTValues.VNF[tier])).rotationState(RotationState.NON_Y_AXIS).renderer(() -> new TieredHullMachineRenderer(tier.intValue(), GCYR.id("block/machine/oxygen_spreader"))).recipeType(GCYRRecipeTypes.OXYGEN_SPREADER_RECIPES).tooltips(GCYRMachines.workableTiered(tier, GTValues.V[tier], GTValues.V[tier] * 64L, GCYRRecipeTypes.OXYGEN_SPREADER_RECIPES, OxygenSpreaderMachine.tankScalingFunction(tier), true)).blockBuilder(block -> block.tag(new TagKey[]{GCYRTags.PASSES_FLOOD_FILL})).register(), HIGH_TIERS);
    public static final MachineDefinition ROCKET_SCANNER = GCYRRegistries.REGISTRATE.multiblock("rocket_scanner", RocketScannerMachine::new).langValue("Rocket Scanner").rotationState(RotationState.NON_Y_AXIS).allowFlip(false).allowExtendedFacing(false).tier(4).pattern(definition -> FactoryBlockPattern.start().aisle(new String[]{"     ", "  K  ", "  K  ", "  K  ", "  K  ", "  K  "}).aisle(new String[]{" BBB ", "     ", "     ", "     ", "     ", "     "}).aisle(new String[]{" BBB ", "     ", "     ", "     ", "     ", "     "}).aisle(new String[]{" BBB ", "     ", "     ", "     ", "     ", "     "}).aisle(new String[]{"     ", "  S  ", "     ", "     ", "     ", "     "}).where('S', Predicates.controller((TraceabilityPredicate)Predicates.blocks((Block[])new Block[]{definition.getBlock()}))).where('B', Predicates.blocks((Block[])new Block[]{(Block)GCYRBlocks.LAUNCH_PAD.get()})).where('K', Predicates.blocks((Block[])new Block[]{(Block)((BlockEntry)GTBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, (Object)GTMaterials.StainlessSteel)).get()})).where(' ', Predicates.any()).build()).shapeInfos(definition -> {
        ArrayList<MultiblockShapeInfo> shapeInfo = new ArrayList<MultiblockShapeInfo>();
        MultiblockShapeInfo.ShapeInfoBuilder builder = ((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)MultiblockShapeInfo.builder().aisle(new String[]{"     ", "  S  ", "     ", "     ", "     ", "     "})).aisle(new String[]{" BBB ", "  E  ", "     ", "     ", "     ", "     "})).aisle(new String[]{" BBB ", " EEE ", " TTT ", "  C  ", "     ", "     "})).aisle(new String[]{" BBB ", "  E  ", "     ", "     ", "     ", "     "})).aisle(new String[]{"     ", "  K  ", "  K  ", "  K  ", "  K  ", "  K  "})).where('S', (Supplier)definition, Direction.NORTH).where(' ', Blocks.f_50016_).where('K', (Block)((BlockEntry)GTBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, (Object)GTMaterials.StainlessSteel)).get()).where('B', GCYRBlocks.LAUNCH_PAD);
        shapeInfo.add(builder.where('E', Blocks.f_50016_).where('T', Blocks.f_50016_).where('C', Blocks.f_50016_).build());
        shapeInfo.add(builder.where('E', GCYRBlocks.BASIC_ROCKET_MOTOR).where('T', GCYRBlocks.BASIC_FUEL_TANK).where('C', GCYRBlocks.SEAT).build());
        return shapeInfo;
    }).workableCasingRenderer(GTCEu.id((String)"block/casings/voltage/ev/side"), GTCEu.id((String)"block/multiblock/assembly_line"), false).register();
    public static final MachineDefinition SPACE_STATION_PACKAGER = GCYRRegistries.REGISTRATE.multiblock("space_station_packager", SpaceStationPackagerMachine::new).langValue("Space Station Packager").rotationState(RotationState.NON_Y_AXIS).allowFlip(false).allowExtendedFacing(false).tier(6).pattern(definition -> FactoryBlockPattern.start().aisle(new String[]{"       ", "   K   ", "   K   ", "   K   ", "   K   ", "   K   "}).aisle(new String[]{"BBBBBBB", "       ", "       ", "       ", "       ", "       "}).aisle(new String[]{"BBBBBBB", "       ", "       ", "       ", "       ", "       "}).aisle(new String[]{"BBBBBBB", "       ", "       ", "       ", "       ", "       "}).aisle(new String[]{"BBBBBBB", "       ", "       ", "       ", "       ", "       "}).aisle(new String[]{"BBBBBBB", "       ", "       ", "       ", "       ", "       "}).aisle(new String[]{"       ", "   S   ", "       ", "       ", "       ", "       "}).where('S', Predicates.controller((TraceabilityPredicate)Predicates.blocks((Block[])new Block[]{definition.getBlock()}))).where('B', Predicates.blocks((Block[])new Block[]{(Block)GCYRBlocks.LAUNCH_PAD.get()})).where('K', Predicates.blocks((Block[])new Block[]{(Block)((BlockEntry)GTBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, (Object)GTMaterials.StainlessSteel)).get()})).where(' ', Predicates.any()).build()).shapeInfos(definition -> {
        ArrayList<MultiblockShapeInfo> shapeInfo = new ArrayList<MultiblockShapeInfo>();
        MultiblockShapeInfo.ShapeInfoBuilder builder = ((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)MultiblockShapeInfo.builder().aisle(new String[]{"       ", "   S   ", "       ", "       ", "       ", "       "})).aisle(new String[]{"BBBBBBB", "       ", "       ", "       ", "       ", "       "})).aisle(new String[]{"BBBBBBB", " CCCCC ", " CCDCC ", " CGHGC ", " CCCCC ", " CCCCC "})).aisle(new String[]{"BBBBBBB", " CCCCC ", " C   C ", " G   G ", " C   C ", " CCCCC "})).aisle(new String[]{"BBBBBBB", " CCCCC ", " C   C ", " G   G ", " C   C ", " CCCCC "})).aisle(new String[]{"BBBBBBB", " CCCCC ", " C   C ", " G   G ", " C   C ", " CCCCC "})).aisle(new String[]{"BBBBBBB", " CCCCC ", " CCDCC ", " CGGGC ", " CCDCC ", " CCCCC "})).aisle(new String[]{"BBBBBBB", "       ", "       ", "       ", "       ", "       "})).aisle(new String[]{"       ", "   K   ", "   K   ", "   K   ", "   K   ", "   K   "})).where('S', (Supplier)definition, Direction.NORTH).where(' ', Blocks.f_50016_).where('K', (Block)((BlockEntry)GTBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, (Object)GTMaterials.StainlessSteel)).get()).where('B', GCYRBlocks.LAUNCH_PAD);
        shapeInfo.add(builder.where('D', Blocks.f_50016_).where('H', Blocks.f_50016_).where('G', Blocks.f_50016_).where('C', Blocks.f_50016_).build());
        shapeInfo.add(builder.where('D', (BlockState)GCYRBlocks.AIRLOCK_DOOR.getDefaultState().m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER)).where('H', (BlockState)GCYRBlocks.AIRLOCK_DOOR.getDefaultState().m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.UPPER)).where('G', (Supplier)GTBlocks.CASING_TEMPERED_GLASS).where('C', Blocks.f_50542_).build());
        return shapeInfo;
    }).workableCasingRenderer(GTCEu.id((String)"block/casings/voltage/luv/side"), GTCEu.id((String)"block/multiblock/assembly_line"), false).register();
    public static final MultiblockMachineDefinition DYSON_SYSTEM_CONTROLLER = GCYRRegistries.REGISTRATE.multiblock("dyson_system_controller", x$0 -> new DysonSystemControllerMachine((IMachineBlockEntity)x$0, new Object[0])).rotationState(RotationState.NON_Y_AXIS).appearanceBlock(() -> (Block)GCYMBlocks.CASING_ATOMIC.get()).recipeType(GCYRRecipeTypes.DYSON_ENERGY_RECIPES).tier(8).pattern(definition -> FactoryBlockPattern.start().aisle(new String[]{"CCCCCCC", "CCCCCCC", "  F    ", "       ", "       ", "       ", "       ", "       ", "       ", "       ", "       ", "       "}).aisle(new String[]{"CCCCCCC", "CCCCCCC", "  F    ", "  F    ", "  F    ", "  F    ", "  F    ", "  F    ", "       ", "  H    ", " HHH   ", "  H    "}).aisle(new String[]{"CCCCCCC", "CCGCCCC", "FFGFF  ", " FGF   ", " FGF   ", " FGF   ", " FGF   ", " FGF   ", "  G    ", " HGH   ", " HGH   ", " HHH   "}).aisle(new String[]{"CCCCCCC", "CCCCCCC", "  F    ", "  F    ", "  F  EE", "  F E  ", "  F E  ", "  F    ", "       ", "  H    ", " HHH   ", "  H    "}).aisle(new String[]{"CCCCCCC", "CCCCCCC", "  F  X ", "     X ", "    XEE", "    ET ", "    E  ", "       ", "       ", "       ", "       ", "       "}).aisle(new String[]{"CCCCCCC", "CCCCCCC", "       ", "       ", "     X ", "     EE", "     EE", "       ", "       ", "       ", "       ", "       "}).aisle(new String[]{"CCCCCCC", "CCCSCCC", "       ", "       ", "       ", "       ", "       ", "       ", "       ", "       ", "       ", "       "}).where('S', Predicates.controller((TraceabilityPredicate)Predicates.blocks((Block[])new Block[]{definition.getBlock()}))).where('C', Predicates.blocks((Block[])new Block[]{(Block)GCYMBlocks.CASING_ATOMIC.get()}).setMinGlobalLimited(90).or(Predicates.autoAbilities((GTRecipeType[])definition.getRecipeTypes()))).where('G', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.wireGtHex, (Material)GTMaterials.RutheniumTriniumAmericiumNeutronate)})).where('F', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.HastelloyC276)})).where('H', Predicates.blocks((Block[])new Block[]{(Block)GCYRBlocks.CASING_BEAM_RECEIVER.get()})).where('X', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.TungstenSteel)})).where('E', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.block, (Material)GTMaterials.HSSS)})).where('T', Predicates.blocks((Block[])new Block[]{GTMachines.POWER_TRANSFORMER[8].getBlock()})).where(' ', Predicates.any()).build()).workableCasingRenderer(GTCEu.id((String)"block/casings/gcym/atomic_casing"), GTCEu.id((String)"block/multiblock/assembly_line"), false).register();
    public static final MultiblockMachineDefinition SPACE_ELEVATOR = GCYRRegistries.REGISTRATE.multiblock("space_elevator", x$0 -> new WorkableElectricMultiblockMachine(x$0, new Object[0])).rotationState(RotationState.NON_Y_AXIS).appearanceBlock(() -> (Block)GTBlocks.CASING_TUNGSTENSTEEL_ROBUST.get()).recipeType(GCYRRecipeTypes.SPACE_ELEVATOR_RECIPES).pattern(definition -> FactoryBlockPattern.start().aisle(new String[]{"         KKKKKKK         ", "          BXXXB          ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         "}).aisle(new String[]{"       KKKKKKKKKKK       ", "        BBBBBBBBB        ", "           XXX           ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         "}).aisle(new String[]{"     KKKKKKKKKKKKKKK     ", "       B         B       ", "          B   B          ", "           XXX           ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         "}).aisle(new String[]{"    KKKKKKKKKKKKKKKKK    ", "                         ", "                         ", "          B   B          ", "           XXX           ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         "}).aisle(new String[]{"   KKKKKKKKKKKKKKKKKKK   ", "                         ", "                         ", "                         ", "          B   B          ", "          BXXXB          ", "        FFFXXXFFF        ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         "}).aisle(new String[]{"  KKKKKKKKKKKKKKKKKKKKK  ", "     X             X     ", "     X             X     ", "     X             X     ", "     X             X     ", "     X             X     ", "     XFF  B   B  FFX     ", "          BXXXB          ", "          BXXXB          ", "           XXX           ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         "}).aisle(new String[]{"  KKKKKKKKKKKKKKKKKKKKK  ", "                         ", "                         ", "                         ", "                         ", "                         ", "     F             F     ", "      X           X      ", "      X           X      ", "      X   B   B   X      ", "          BXXXB          ", "          BXXXB          ", "           XXX           ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         "}).aisle(new String[]{" KKKKKKKKKKKKKKKKKKKKKKK ", "  B                   B  ", "                         ", "                         ", "                         ", "                         ", "     F             F     ", "                         ", "                         ", "       X         X       ", "       X         X       ", "       X         X       ", "       X  B   B  X       ", "          BXXXB          ", "          BXXXB          ", "          BXXXB          ", "           XXX           ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         "}).aisle(new String[]{" KKKKKKKKKKKKKKKKKKKKKKK ", " B                     B ", "                         ", "                         ", "                         ", "                         ", "    F               F    ", "                         ", "                         ", "                         ", "                         ", "        X       X        ", "        X       X        ", "        XFF   FFX        ", "        X       X        ", "        X       X        ", "        X B   B X        ", "          BXXXB          ", "          BXXXB          ", "          BXXXB          ", "           XXX           ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         "}).aisle(new String[]{"KKKKKKKKKKKKKKKKKKKKKKKKK", " B                     B ", "                         ", "                         ", "                         ", "                         ", "    F               F    ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "        F       F        ", "                         ", "         X     X         ", "         X     X         ", "         X     X         ", "         X     X         ", "         X     X         ", "         XB   BX         ", "          BXXXB          ", "          BXXXB          ", "           XXX           ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         "}).aisle(new String[]{"KKKKKKKKKKKKKKKKKKKKKKKKK", "BB         BBB         BB", "  B        BWB        B  ", "   B       BWB       B   ", "    B      BWB      B    ", "    B      BWB      B    ", "    FB     BWB     BF    ", "     B     BWB     B     ", "     B     BWB     B     ", "      B    BWB    B      ", "      B    BWB    B      ", "      B    BWB    B      ", "       B   BWB   B       ", "       BF  BWB  FB       ", "       B   BWB   B       ", "       B   BWB   B       ", "        B  BWB  B        ", "        B  BWB  B        ", "        B  BWB  B        ", "        B X   X B        ", "         BX   XB         ", "         BX   XB         ", "         BX   XB         ", "          B   B          ", "           XXX           ", "           XXX           ", "           XXX           ", "           XXX           ", "                         ", "                         ", "                         "}).aisle(new String[]{"KKKKKKKKKKKKKKKKKKKKKKKKK", "XB        B   B        BX", " X        B   B        X ", "  X       B   B       X  ", "   X      B   B      X   ", "    X     B   B     X    ", "    X     B   B     X    ", "     X    B   B    X     ", "     X    B   B    X     ", "     X    B   B    X     ", "      X   B   B   X      ", "      X   B   B   X      ", "      X   B   B   X      ", "       X  B   B  X       ", "       X  B   B  X       ", "       X  B   B  X       ", "       X  B   B  X       ", "        X B   B X        ", "        X B   B X        ", "        X  BWB  X        ", "        X  BWB  X        ", "         X BWB X         ", "         X BWB X         ", "         X BWB X         ", "          XBWBX          ", "          XBWBX          ", "          XBWBX          ", "          XBWBX          ", "            B            ", "            B            ", "            B            "}).aisle(new String[]{"KKKKKKKKKKKKKKKKKKKKKKKKK", "XB        B G B        BX", " X        W G W        X ", "  X       W G W       X  ", "   X      W G W      X   ", "    X     W G W     X    ", "    X     W G W     X    ", "     X    W G W    X     ", "     X    W G W    X     ", "     X    W G W    X     ", "      X   W G W   X      ", "      X   W G W   X      ", "      X   W G W   X      ", "       X  W G W  X       ", "       X  W G W  X       ", "       X  W G W  X       ", "       X  W G W  X       ", "        X W G W X        ", "        X W G W X        ", "        X  WGW  X        ", "        X  WGW  X        ", "         X WGW X         ", "         X WGW X         ", "         X WGW X         ", "          XWGWX          ", "          XWGWX          ", "          XWGWX          ", "          XWGWX          ", "           BGB           ", "           BGB           ", "           BGB           "}).aisle(new String[]{"KKKKKKKKKKKKKKKKKKKKKKKKK", "XB        B   B        BX", " X        B   B        X ", "  X       B   B       X  ", "   X      B   B      X   ", "    X     B   B     X    ", "    X     B   B     X    ", "     X    B   B    X     ", "     X    B   B    X     ", "     X    B   B    X     ", "      X   B   B   X      ", "      X   B   B   X      ", "      X   B   B   X      ", "       X  B   B  X       ", "       X  B   B  X       ", "       X  B   B  X       ", "       X  B   B  X       ", "        X B   B X        ", "        X B   B X        ", "        X  BWB  X        ", "        X  BWB  X        ", "         X BWB X         ", "         X BWB X         ", "         X BWB X         ", "          XBWBX          ", "          XBWBX          ", "          XBWBX          ", "          XBWBX          ", "            B            ", "            B            ", "            B            "}).aisle(new String[]{"KKKKKKKKKKKKKKKKKKKKKKKKK", "BB         BBB         BB", "  B        BWB        B  ", "   B       BWB       B   ", "    B      BWB      B    ", "    B      BWB      B    ", "    FB     BWB     BF    ", "     B     BWB     B     ", "     B     BWB     B     ", "      B    BWB    B      ", "      B    BWB    B      ", "      B    BWB    B      ", "       B   BWB   B       ", "       BF  BWB  FB       ", "       B   BWB   B       ", "       B   BWB   B       ", "        B  BWB  B        ", "        B  BWB  B        ", "        B  BWB  B        ", "        B X   X B        ", "         BX   XB         ", "         BX   XB         ", "         BX   XB         ", "          B   B          ", "           XXX           ", "           XXX           ", "           XXX           ", "           XXX           ", "                         ", "                         ", "                         "}).aisle(new String[]{"KKKKKKKKKKKKKKKKKKKKKKKKK", " B                     B ", "                         ", "                         ", "                         ", "                         ", "    F               F    ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "        F       F        ", "                         ", "         X     X         ", "         X     X         ", "         X     X         ", "         X     X         ", "         X     X         ", "         XB   BX         ", "          BXXXB          ", "          BXXXB          ", "           XXX           ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         "}).aisle(new String[]{" KKKKKKKKKKKKKKKKKKKKKKK ", " B                     B ", "                         ", "                         ", "                         ", "                         ", "    F               F    ", "                         ", "                         ", "                         ", "                         ", "        X       X        ", "        X       X        ", "        XFF   FFX        ", "        X       X        ", "        X       X        ", "        X B   B X        ", "          BXXXB          ", "          BXXXB          ", "          BXXXB          ", "           XXX           ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         "}).aisle(new String[]{" KKKKKKKKKKKKKKKKKKKKKKK ", "  B                   B  ", "                         ", "                         ", "                         ", "                         ", "     F             F     ", "                         ", "                         ", "       X         X       ", "       X         X       ", "       X         X       ", "       X  B   B  X       ", "          BXXXB          ", "          BXXXB          ", "          BXXXB          ", "           XXX           ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         "}).aisle(new String[]{"  KKKKKKKKKKKKKKKKKKKKK  ", "                         ", "                         ", "                         ", "                         ", "                         ", "     F             F     ", "      X           X      ", "      X           X      ", "      X   B   B   X      ", "          BXXXB          ", "          BXXXB          ", "           XXX           ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         "}).aisle(new String[]{"  KKKKKKKKKKKKKKKKKKKKK  ", "     X             X     ", "     X             X     ", "     X             X     ", "     X             X     ", "     X             X     ", "     XFF  B   B  FFX     ", "          BXXXB          ", "          BXXXB          ", "           XXX           ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         "}).aisle(new String[]{"   KKKKKKKKKKKKKKKKKKK   ", "                         ", "                         ", "                         ", "          B   B          ", "          BXXXB          ", "        FFFXXXFFF        ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         "}).aisle(new String[]{"    KKKKKKKKKKKKKKKKK    ", "                         ", "                         ", "          B   B          ", "           XXX           ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         "}).aisle(new String[]{"     KKKKKKKKKKKKKKK     ", "       B         B       ", "          B   B          ", "           XXX           ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         "}).aisle(new String[]{"       KKKKKKKKKKK       ", "        BBBBBBBBB        ", "           XXX           ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         "}).aisle(new String[]{"         KKKKKKK         ", "          BXCXB          ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         ", "                         "}).where('C', Predicates.controller((TraceabilityPredicate)Predicates.blocks((Block[])new Block[]{definition.getBlock()}))).where('K', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_TUNGSTENSTEEL_ROBUST.get()}).or(Predicates.autoAbilities((GTRecipeType[])definition.getRecipeTypes())).or(Predicates.autoAbilities((boolean)true, (boolean)false, (boolean)true))).where('X', Predicates.blocks((Block[])new Block[]{(Block)GCYRBlocks.CASING_SUPPORT.get()})).where('F', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.NaquadahAlloy)})).where('G', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.wireGtHex, (Material)GTMaterials.EnrichedNaquadahTriniumEuropiumDuranide)})).where('B', Predicates.blocks((Block[])new Block[]{(Block)GCYRBlocks.CASING_BEAM_RECEIVER.get()})).where('W', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.FUSION_GLASS.get()})).build()).workableCasingRenderer(GTCEu.id((String)"block/casings/solid/machine_casing_robust_tungstensteel"), GTCEu.id((String)"block/multiblock/assembly_line"), false).register();
    public static final MultiblockMachineDefinition DRONE_HANGAR = GCYRRegistries.REGISTRATE.multiblock("drone_hangar", x$0 -> new DroneHangarMachine((IMachineBlockEntity)x$0, new Object[0])).rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.VACUUM_RECIPES).appearanceBlock(() -> (Block)GTBlocks.CASING_ALUMINIUM_FROSTPROOF.get()).pattern(definition -> FactoryBlockPattern.start().aisle(new String[]{"XXX", "XXX", "XXX"}).aisle(new String[]{"XXX", "X#X", "XXX"}).aisle(new String[]{"XXX", "XSX", "XXX"}).where('S', Predicates.controller((TraceabilityPredicate)Predicates.blocks((Block[])new Block[]{definition.getBlock()}))).where('X', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_ALUMINIUM_FROSTPROOF.get()}).setMinGlobalLimited(14).or(Predicates.autoAbilities((GTRecipeType[])definition.getRecipeTypes()))).where('#', Predicates.air()).build()).workableCasingRenderer(GTCEu.id((String)"block/casings/solid/machine_casing_frost_proof"), GTCEu.id((String)"block/multiblock/vacuum_freezer"), false).register();

    public static MachineDefinition[] registerSimpleMachines(String name, GTRecipeType recipeType, Int2IntFunction tankScalingFunction, int ... tiers) {
        return GCYRMachines.registerTieredMachines(name, (holder, tier) -> new SimpleTieredMachine(holder, tier.intValue(), tankScalingFunction, new Object[0]), (tier, builder) -> builder.langValue("%s %s %s".formatted(GTValues.VLVH[tier], FormattingUtil.toEnglishName((Object)name), GTValues.VLVT[tier])).editableUI((EditableMachineUI)SimpleTieredMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id((String)name), recipeType)).rotationState(RotationState.NON_Y_AXIS).recipeType(recipeType).recipeModifier((RecipeModifier)GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK)).workableTieredHullRenderer(GTCEu.id((String)("block/machines/" + name))).tooltips(GCYRMachines.workableTiered(tier, GTValues.V[tier], GTValues.V[tier] * 64L, recipeType, ((Integer)tankScalingFunction.apply(tier)).intValue(), true)).compassNode(name).register(), tiers);
    }

    public static MachineDefinition[] registerSimpleMachines(String name, GTRecipeType recipeType, Int2IntFunction tankScalingFunction) {
        return GCYRMachines.registerSimpleMachines(name, recipeType, tankScalingFunction, ELECTRIC_TIERS);
    }

    public static MachineDefinition[] registerSimpleMachines(String name, GTRecipeType recipeType) {
        return GCYRMachines.registerSimpleMachines(name, recipeType, defaultTankSizeFunction);
    }

    public static MachineDefinition[] registerTieredMachines(String name, BiFunction<IMachineBlockEntity, Integer, MetaMachine> factory, BiFunction<Integer, MachineBuilder<MachineDefinition>, MachineDefinition> builder, int ... tiers) {
        MachineDefinition[] definitions = new MachineDefinition[tiers.length];
        for (int i = 0; i < tiers.length; ++i) {
            int tier = tiers[i];
            MachineBuilder register = GCYRRegistries.REGISTRATE.machine(GTValues.VN[tier].toLowerCase() + "_" + name, holder -> (MetaMachine)factory.apply((IMachineBlockEntity)holder, tier)).tier(tier);
            definitions[i] = builder.apply(tier, (MachineBuilder<MachineDefinition>)register);
        }
        return definitions;
    }

    public static Component explosion() {
        if (ConfigHolder.INSTANCE.machines.doTerrainExplosion) {
            return Component.m_237115_((String)"gtceu.universal.tooltip.terrain_resist");
        }
        return null;
    }

    public static Component[] workableTiered(int tier, long voltage, long energyCapacity, GTRecipeType recipeType, long tankCapacity, boolean input) {
        ArrayList<MutableComponent> tooltipComponents = new ArrayList<MutableComponent>();
        tooltipComponents.add(input ? Component.m_237110_((String)"gtceu.universal.tooltip.voltage_in", (Object[])new Object[]{voltage, GTValues.VNF[tier]}) : Component.m_237110_((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{voltage, GTValues.VNF[tier]}));
        tooltipComponents.add(Component.m_237110_((String)"gtceu.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{energyCapacity}));
        if (recipeType.getMaxInputs((RecipeCapability)FluidRecipeCapability.CAP) > 0 || recipeType.getMaxOutputs((RecipeCapability)FluidRecipeCapability.CAP) > 0) {
            tooltipComponents.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{tankCapacity}));
        }
        return (Component[])tooltipComponents.toArray(Component[]::new);
    }

    public static void init() {
    }
}

