/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.common.item.armor;

import argent_matter.gcyr.common.item.armor.GCYRArmorMaterials;
import argent_matter.gcyr.data.recipe.GCYRTags;
import com.google.common.primitives.Ints;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.jetbrains.annotations.Nullable;

public class SpaceSuitArmorItem
extends ArmorItem {
    public static final long CAPACITY = 16000L;

    public SpaceSuitArmorItem(ArmorItem.Type type, Item.Properties properties) {
        super((ArmorMaterial)GCYRArmorMaterials.SPACE, type, properties);
    }

    public static <T> LazyOptional<T> getCapability(@Nonnull ItemStack itemStack, @Nonnull Capability<T> cap) {
        if (cap == ForgeCapabilities.FLUID_HANDLER_ITEM) {
            return ForgeCapabilities.FLUID_HANDLER_ITEM.orEmpty(cap, LazyOptional.of(() -> new FluidHandlerItemStack(itemStack, Ints.saturatedCast((long)16000L)){

                public boolean canFillFluidType(FluidStack fluid) {
                    return fluid.getFluid().m_205069_().m_203656_(GCYRTags.OXYGEN);
                }
            }));
        }
        return LazyOptional.empty();
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f - (float)SpaceSuitArmorItem.oxygenAmount(stack) * 13.0f / (float)SpaceSuitArmorItem.oxygenMax(stack));
    }

    public int m_142159_(ItemStack stack) {
        return -8066059;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gcyr.spacesuit"));
        if (stack.m_204117_(Tags.Items.ARMORS_CHESTPLATES)) {
            FluidUtil.getFluidHandler((ItemStack)stack).ifPresent(h -> tooltip.add((Component)Component.m_237110_((String)"tooltip.gcyr.spacesuit.stored", (Object[])new Object[]{h.getFluidInTank(0).getAmount(), h.getTankCapacity(0)})));
        }
    }

    public static boolean hasFullSet(LivingEntity entity) {
        int slotCount = 0;
        int armorCount = 0;
        for (ItemStack stack : entity.m_6168_()) {
            ++slotCount;
            if (!(stack.m_41720_() instanceof SpaceSuitArmorItem) && (!stack.m_41782_() || !stack.m_41783_().m_128471_("gcyr:spacesuit"))) continue;
            ++armorCount;
        }
        return slotCount > 0 && armorCount == slotCount;
    }

    public static boolean hasOxygenatedSpaceSuit(LivingEntity entity) {
        return SpaceSuitArmorItem.oxygenAmount(entity) > 0L;
    }

    public static long oxygenAmount(LivingEntity entity) {
        ItemStack chest = entity.m_6844_(EquipmentSlot.CHEST);
        return SpaceSuitArmorItem.oxygenAmount(chest);
    }

    public static long oxygenAmount(ItemStack stack) {
        if (stack.m_41720_() instanceof SpaceSuitArmorItem || stack.m_41782_() && stack.m_41783_().m_128471_("gcyr:spacesuit")) {
            return FluidUtil.getFluidHandler((ItemStack)stack).map(h -> h.getFluidInTank(0).getAmount()).orElse(0).intValue();
        }
        return 0L;
    }

    public static long oxygenMax(LivingEntity entity) {
        ItemStack chest = entity.m_6844_(EquipmentSlot.CHEST);
        return SpaceSuitArmorItem.oxygenMax(chest);
    }

    public static long oxygenMax(ItemStack stack) {
        if (stack.m_41720_() instanceof SpaceSuitArmorItem || stack.m_41782_() && stack.m_41783_().m_128471_("gcyr:spacesuit")) {
            return FluidUtil.getFluidHandler((ItemStack)stack).map(h -> h.getTankCapacity(0)).orElse(0).intValue();
        }
        return 0L;
    }

    public static void consumeSpaceSuitOxygen(LivingEntity entity, int amount) {
        ItemStack chest = entity.m_6844_(EquipmentSlot.CHEST);
        if (chest.m_41720_() instanceof SpaceSuitArmorItem || chest.m_41782_() && chest.m_41783_().m_128471_("gcyr:spacesuit")) {
            ItemStackTransfer storage = new ItemStackTransfer(chest);
            FluidUtil.getFluidHandler((ItemStack)storage.getStackInSlot(0)).ifPresent(h -> h.drain(amount, IFluidHandler.FluidAction.EXECUTE));
        }
    }

    public static UniformInt getTemperatureThreshold() {
        return UniformInt.m_146622_((int)60, (int)363);
    }
}

