/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.common.machine.multiblock;

import argent_matter.gcyr.common.data.GCYRBlocks;
import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IDisplayUIMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.FactoryBlockPattern;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class PlatformMultiblockMachine
extends MultiblockControllerMachine
implements IDisplayUIMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(PlatformMultiblockMachine.class, MultiblockControllerMachine.MANAGED_FIELD_HOLDER);
    public static final int MAX_RADIUS = 8;
    public static final int MIN_RADIUS = 1;
    public static final int MIN_TOWER_HEIGHT = 2;
    public static final int MAX_TOWER_HEIGHT = 15;
    @Persisted
    protected int lDist = 0;
    @Persisted
    protected int rDist = 0;
    @Persisted
    protected int bDist = 0;
    @Persisted
    protected int hDist = 0;

    public PlatformMultiblockMachine(IMachineBlockEntity holder) {
        super(holder);
    }

    public void updateStructureDimensions() {
        int i;
        Level world = this.getLevel();
        Direction front = this.getFrontFacing();
        Direction back = front.m_122424_();
        Direction left = front.m_122428_();
        Direction right = left.m_122424_();
        BlockPos.MutableBlockPos pos = this.getPos().m_122032_().m_122175_(back, 1).m_122175_(Direction.DOWN, 1);
        BlockPos.MutableBlockPos lPos = pos.m_122032_();
        BlockPos.MutableBlockPos rPos = pos.m_122032_();
        BlockPos.MutableBlockPos bPos = pos.m_122032_();
        BlockPos.MutableBlockPos hPos = pos.m_122032_();
        int lDist = 0;
        int rDist = 0;
        int bDist = 0;
        int hDist = 0;
        for (i = 1; i < 8; ++i) {
            if (lDist == 0 && this.isBlockEdge(world, lPos, left)) {
                lDist = i;
            }
            if (rDist == 0 && this.isBlockEdge(world, rPos, right)) {
                rDist = i;
            }
            if (bDist == 0 && this.isBlockEdge(world, bPos, back)) {
                bDist = i + 1;
            }
            if (lDist != 0 && rDist != 0 && bDist != 0) break;
        }
        hPos.m_122175_(back, bDist);
        for (i = 1; i < 15; ++i) {
            if (this.isBlockTowerEnd(world, hPos, Direction.UP)) {
                hDist = i;
            }
            if (hDist != 0) break;
        }
        if (lDist < 1 || rDist < 1 || bDist < 1 || hDist < 2) {
            this.isFormed = false;
            return;
        }
        this.lDist = lDist;
        this.rDist = rDist;
        this.bDist = bDist;
        this.hDist = hDist;
    }

    public boolean isBlockEdge(@Nonnull Level world, @Nonnull BlockPos.MutableBlockPos pos, @Nonnull Direction direction) {
        return world.m_8055_((BlockPos)pos.m_122173_(direction)).m_60713_((Block)GCYRBlocks.LAUNCH_PAD.get()) && !world.m_8055_(pos.m_5484_(direction, 1)).m_60713_((Block)GCYRBlocks.LAUNCH_PAD.get());
    }

    public boolean isBlockTowerEnd(@Nonnull Level world, @Nonnull BlockPos.MutableBlockPos pos, @Nonnull Direction direction) {
        return world.m_8055_((BlockPos)pos.m_122175_(Direction.UP, 1)).m_60713_((Block)((BlockEntry)GTBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, (Object)GTMaterials.StainlessSteel)).get()) && !world.m_8055_(pos.m_5484_(Direction.UP, 1)).m_60713_((Block)((BlockEntry)GTBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, (Object)GTMaterials.StainlessSteel)).get());
    }

    public BlockPattern getPattern() {
        int i;
        if (this.getLevel() != null) {
            this.updateStructureDimensions();
        }
        if (this.lDist < 1) {
            this.lDist = 1;
        }
        if (this.rDist < 1) {
            this.rDist = 1;
        }
        if (this.bDist < 1) {
            this.bDist = 1;
        }
        if (this.hDist < 2) {
            this.hDist = 2;
        }
        if (this.getFrontFacing() == Direction.EAST || this.getFrontFacing() == Direction.WEST) {
            int tmp = this.lDist;
            this.lDist = this.rDist;
            this.rDist = tmp;
        }
        StringBuilder backBuilder = new StringBuilder();
        StringBuilder controllerBuilder = new StringBuilder();
        StringBuilder emptyBuilder = new StringBuilder();
        StringBuilder fullBuilder = new StringBuilder();
        for (i = 0; i < this.lDist; ++i) {
            backBuilder.append(" ");
            controllerBuilder.append(" ");
            emptyBuilder.append(" ");
            fullBuilder.append("B");
        }
        backBuilder.append("K");
        controllerBuilder.append("S");
        emptyBuilder.append(" ");
        fullBuilder.append("B");
        for (i = 0; i < this.rDist; ++i) {
            backBuilder.append(" ");
            controllerBuilder.append(" ");
            emptyBuilder.append(" ");
            fullBuilder.append("B");
        }
        Object[] back = new String[this.hDist];
        Arrays.fill(back, backBuilder.toString());
        back[0] = emptyBuilder.toString();
        Object[] center = new String[this.hDist];
        Arrays.fill(center, emptyBuilder.toString());
        center[0] = fullBuilder.toString();
        String[] front = (String[])Arrays.copyOf(center, center.length);
        front[0] = emptyBuilder.toString();
        front[1] = controllerBuilder.toString();
        TraceabilityPredicate towerPredicate = Predicates.blocks((Block[])new Block[]{(Block)((BlockEntry)GTBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, (Object)GTMaterials.StainlessSteel)).get()});
        TraceabilityPredicate basePredicate = Predicates.autoAbilities((boolean)true, (boolean)false, (boolean)false).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.INPUT_ENERGY}).setMinGlobalLimited(1).setMaxGlobalLimited(3));
        return FactoryBlockPattern.start().aisle((String[])back).aisle((String[])center).setRepeatable(this.bDist).aisle(front).where('S', Predicates.controller((TraceabilityPredicate)Predicates.blocks((IMachineBlock[])new IMachineBlock[]{this.getDefinition().get()}))).where('B', Predicates.blocks((Block[])new Block[]{(Block)GCYRBlocks.LAUNCH_PAD.get()})).where('K', towerPredicate).where(' ', Predicates.any()).build();
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }
}

