/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.common.satellite;

import argent_matter.gcyr.api.space.satellite.Satellite;
import argent_matter.gcyr.api.space.satellite.SatelliteType;
import argent_matter.gcyr.api.space.satellite.data.SatelliteData;
import argent_matter.gcyr.config.GCYRConfig;
import com.gregtechceu.gtceu.common.data.GTDamageTypes;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;

public class LaserSatellite
extends Satellite {
    public static final Codec<LaserSatellite> CODEC = RecordCodecBuilder.create(instance -> Satellite.baseCodec(instance).apply((Applicative)instance, LaserSatellite::new));
    private int currentMinedY;
    private boolean isMining = false;

    public LaserSatellite(SatelliteType<?> type, SatelliteData data, ResourceKey<Level> level) {
        super(type, data, level);
    }

    @Override
    public void tickSatellite(Level level) {
        if (this.isNonWorking()) {
            return;
        }
        if (this.isMining && level.m_46467_() % (long)GCYRConfig.INSTANCE.satellites.laserSatelliteMiningTickStep == 0L) {
            int x = this.data.locationInWorld().x();
            int z = this.data.locationInWorld().y();
            int i = x - 1;
            while (i < x + 1) {
                int j = z - 1;
                while (j < z + 1) {
                    level.m_7731_(new BlockPos(i, this.currentMinedY, j), Blocks.f_50016_.m_49966_(), 3);
                    ++z;
                }
                ++x;
            }
            List entities = level.m_142425_(EntityTypeTest.m_156916_(LivingEntity.class), new AABB((double)(x - 1), (double)(this.currentMinedY - 1), (double)(z - 1), (double)(x + 1), (double)(this.currentMinedY + 1), (double)(z + 1)), EntitySelector.f_20406_);
            entities.forEach(entity -> entity.m_6469_(GTDamageTypes.RADIATION.source((LevelAccessor)level), GCYRConfig.INSTANCE.satellites.laserSatelliteDamagePerTickStep));
        }
    }

    @Override
    public boolean runSatelliteFunction(Level level) {
        this.currentMinedY = level.m_6924_(Heightmap.Types.WORLD_SURFACE, Mth.m_14143_((float)this.data.locationInWorld().x()), Mth.m_14143_((float)this.data.locationInWorld().y()));
        this.isMining = true;
        return true;
    }

    public CompoundTag serializeExtraData() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("currentY", this.currentMinedY);
        tag.m_128379_("mining", this.isMining);
        return tag;
    }

    @Override
    public void deserializeExtraData(Tag tag, Level level) {
        CompoundTag compound = (CompoundTag)tag;
        this.isMining = compound.m_128471_("mining");
        this.currentMinedY = compound.m_128451_("currentY");
    }
}

