/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.data.loader;

import argent_matter.gcyr.GCYR;
import argent_matter.gcyr.GCYRClient;
import argent_matter.gcyr.api.space.planet.Galaxy;
import argent_matter.gcyr.api.space.planet.PlanetRing;
import argent_matter.gcyr.api.space.planet.PlanetSkyRenderer;
import argent_matter.gcyr.api.space.planet.SolarSystem;
import argent_matter.gcyr.client.dimension.ClientModSkies;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="gcyr", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class PlanetResources
implements ResourceManagerReloadListener {
    public static final PlanetResources INSTANCE = new PlanetResources();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setLenient().create();

    public void m_6213_(ResourceManager manager) {
        JsonObject jsonObject;
        InputStreamReader reader;
        ArrayList<PlanetSkyRenderer> skyRenderers = new ArrayList<PlanetSkyRenderer>();
        HashMap<ResourceLocation, ShaderInstance> skyShaders = new HashMap<ResourceLocation, ShaderInstance>();
        ArrayList<SolarSystem> solarSystems = new ArrayList<SolarSystem>();
        ArrayList<PlanetRing> planetRings = new ArrayList<PlanetRing>();
        ArrayList<Galaxy> galaxies = new ArrayList<Galaxy>();
        for (ResourceLocation id : manager.m_214159_("gcyr/planet_assets/sky_renderers", path -> path.m_135815_().endsWith(".json")).keySet()) {
            try {
                for (Resource resource : manager.m_213829_(id)) {
                    reader = new InputStreamReader(resource.m_215507_());
                    jsonObject = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                    if (jsonObject == null) continue;
                    PlanetSkyRenderer renderer = (PlanetSkyRenderer)PlanetSkyRenderer.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow(false, arg_0 -> ((Logger)GCYR.LOGGER).error(arg_0));
                    if (renderer.skyShaderLocation().isPresent()) {
                        skyShaders.put(renderer.skyShaderLocation().get(), null);
                    }
                    skyRenderers.add(renderer);
                }
            }
            catch (Exception e) {
                GCYR.LOGGER.error("Failed to load Gregicality Rocketry sky rendering assets from: \"{}\"", (Object)id.toString(), (Object)e);
            }
        }
        for (ResourceLocation id : manager.m_214159_("gcyr/planet_assets/solar_systems", path -> path.m_135815_().endsWith(".json")).keySet()) {
            try {
                for (Resource resource : manager.m_213829_(id)) {
                    reader = new InputStreamReader(resource.m_215507_());
                    jsonObject = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                    if (jsonObject == null) continue;
                    solarSystems.add((SolarSystem)SolarSystem.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow(false, arg_0 -> ((Logger)GCYR.LOGGER).error(arg_0)));
                }
            }
            catch (Exception e) {
                GCYR.LOGGER.error("Failed to load Gregicality Rocketry solar system assets from: \"{}\"", (Object)id.toString(), (Object)e);
            }
        }
        for (ResourceLocation id : manager.m_214159_("gcyr/planet_assets/planet_rings", path -> path.m_135815_().endsWith(".json")).keySet()) {
            try {
                for (Resource resource : manager.m_213829_(id)) {
                    reader = new InputStreamReader(resource.m_215507_());
                    jsonObject = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                    if (jsonObject == null) continue;
                    planetRings.add((PlanetRing)PlanetRing.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow(false, arg_0 -> ((Logger)GCYR.LOGGER).error(arg_0)));
                }
            }
            catch (Exception e) {
                GCYR.LOGGER.error("Failed to load Gregicality Rocketry planet ring assets from: \"{}\"", (Object)id.toString(), (Object)e);
            }
        }
        for (ResourceLocation id : manager.m_214159_("gcyr/planet_assets/galaxies", path -> path.m_135815_().endsWith(".json")).keySet()) {
            try {
                for (Resource resource : manager.m_213829_(id)) {
                    reader = new InputStreamReader(resource.m_215507_());
                    jsonObject = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                    if (jsonObject == null) continue;
                    galaxies.add((Galaxy)Galaxy.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow(false, arg_0 -> ((Logger)GCYR.LOGGER).error(arg_0)));
                }
            }
            catch (Exception e) {
                GCYR.LOGGER.error("Failed to load Gregicality Rocketry galaxy assets from: \"{}\"", (Object)id.toString(), (Object)e);
            }
        }
        solarSystems.sort(Comparator.comparing(SolarSystem::solarSystem));
        galaxies.sort(Comparator.comparing(Galaxy::galaxy));
        GCYRClient.skyRenderers = skyRenderers;
        GCYRClient.skyShaders = skyShaders;
        GCYRClient.solarSystems = solarSystems;
        GCYRClient.planetRings = planetRings;
        GCYRClient.galaxies = galaxies;
        ClientModSkies.register();
    }

    @SubscribeEvent
    public static void shaderRegistry(RegisterShadersEvent event) {
        for (Map.Entry<ResourceLocation, ShaderInstance> entry : GCYRClient.skyShaders.entrySet()) {
            try {
                ShaderInstance shader = new ShaderInstance(event.getResourceProvider(), entry.getKey(), DefaultVertexFormat.f_85814_);
                event.registerShader(shader, entry::setValue);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to register shader with id " + entry.getKey(), e);
            }
        }
    }
}

