/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.forge;

import argent_matter.gcyr.GCYR;
import argent_matter.gcyr.api.capability.GCYRCapabilityHelper;
import argent_matter.gcyr.api.capability.IDysonSystem;
import argent_matter.gcyr.api.capability.ISatelliteHolder;
import argent_matter.gcyr.common.data.GCYRNetworking;
import argent_matter.gcyr.common.item.armor.SpaceSuitArmorItem;
import argent_matter.gcyr.common.networking.s2c.PacketSyncDysonSphereStatus;
import argent_matter.gcyr.data.loader.PlanetData;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.networking.IPacket;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="gcyr", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeCommonEventListener {
    private static final ThreadLocal<Set<IDysonSystem>> TICKED_SYSTEMS = ThreadLocal.withInitial(HashSet::new);

    @SubscribeEvent
    public static void registerItemStackCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        final ItemStack itemStack = (ItemStack)event.getObject();
        if (itemStack.m_204117_(Tags.Items.ARMORS_CHESTPLATES) && (itemStack.m_41720_() instanceof SpaceSuitArmorItem || itemStack.m_41782_() && itemStack.m_41783_().m_128471_("gcyr:spacesuit"))) {
            event.addCapability(GCYR.id("spacesuit"), new ICapabilityProvider(){

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
                    return SpaceSuitArmorItem.getCapability(itemStack, capability);
                }
            });
        }
    }

    @SubscribeEvent
    public static void registerServerReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new PlanetData());
    }

    @SubscribeEvent
    public static void playerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            IDysonSystem system = GCYRCapabilityHelper.getDysonSystem(player2.m_284548_());
            if (system != null && system.isDysonSphereActive() && !system.activeDysonSphere().isCollapsed()) {
                GCYRNetworking.NETWORK.sendToPlayer((IPacket)new PacketSyncDysonSphereStatus(true), player2);
            } else {
                GCYRNetworking.NETWORK.sendToPlayer((IPacket)new PacketSyncDysonSphereStatus(false), player2);
            }
        }
    }

    @SubscribeEvent
    public static void entityJoined(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            IDysonSystem system = GCYRCapabilityHelper.getDysonSystem(player.m_284548_());
            if (system != null && system.isDysonSphereActive() && !system.activeDysonSphere().isCollapsed()) {
                GCYRNetworking.NETWORK.sendToPlayer((IPacket)new PacketSyncDysonSphereStatus(true), player);
            } else {
                GCYRNetworking.NETWORK.sendToPlayer((IPacket)new PacketSyncDysonSphereStatus(false), player);
            }
        }
    }

    @SubscribeEvent
    public static void levelTick(TickEvent.LevelTickEvent event) {
        Level level = event.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (event.phase == TickEvent.Phase.START) {
            IDysonSystem system;
            ISatelliteHolder sat;
            if (!level2.m_6042_().f_63856_() && (sat = GCYRCapabilityHelper.getSatellites(level2)) != null) {
                sat.tickSatellites();
            }
            if ((system = GCYRCapabilityHelper.getDysonSystem(level2)) == null || TICKED_SYSTEMS.get().contains(system)) {
                return;
            }
            system.tick();
        } else {
            TICKED_SYSTEMS.get().clear();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onAddTooltips(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_41782_() && stack.m_41783_().m_128471_("gcyr:spacesuit")) {
            IFluidTransfer transfer;
            if (stack.m_204117_(Tags.Items.ARMORS_CHESTPLATES) && (transfer = FluidTransferHelper.getFluidTransfer((IItemTransfer)new ItemStackTransfer(stack), (int)0)) != null) {
                event.getToolTip().add(1, Component.m_237110_((String)"tooltip.gcyr.spacesuit.stored", (Object[])new Object[]{transfer.getFluidInTank(0).getAmount(), transfer.getTankCapacity(0)}));
            }
            event.getToolTip().add(1, Component.m_237115_((String)"tooltip.gcyr.spacesuit"));
        }
    }
}

