/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.mixin;

import argent_matter.gcyr.api.capability.IGpsTracked;
import argent_matter.gcyr.common.entity.data.EntityOxygenSystem;
import argent_matter.gcyr.common.entity.data.EntityTemperatureSystem;
import argent_matter.gcyr.data.loader.PlanetData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements IGpsTracked {
    @Unique
    private boolean gcyr$gpsTracked;

    private LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void gcyr$addAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        tag.m_128379_("gcyr:gps_tracked", this.gcyr$gpsTracked);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void gcyr$readAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        if (tag.m_128441_("gcyr:gps_tracked")) {
            this.gcyr$gpsTracked = tag.m_128471_("gcyr:gps_tracked");
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void gcyr$tick(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        Level level = entity.m_9236_();
        if (!level.f_46443_ && level.m_46467_() % 10L == 0L) {
            Player player;
            if (entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_())) {
                return;
            }
            if (entity instanceof ArmorStand) {
                return;
            }
            EntityOxygenSystem.oxygenTick(entity, (ServerLevel)level);
            if (!PlanetData.isSpaceLevel(level)) {
                return;
            }
            EntityTemperatureSystem.temperatureTick(entity, (ServerLevel)level);
        }
    }

    @Override
    public boolean isGpsTracked() {
        return this.gcyr$gpsTracked;
    }

    @Override
    public void setGpsTracked(boolean tracked) {
        this.gcyr$gpsTracked = tracked;
    }
}

