#version 330

#moj_import <fog.glsl>

in vec3 Position;

uniform mat4 ProjMat;
uniform mat4 ModelViewMat;
uniform int FogShape;

out vec3 ViewPos;
out float vertexDistance;

void main() {
    gl_Position = ProjMat * ModelViewMat * vec4(Position, 1.0);
    ViewPos = Position;

    vertexDistance = fog_distance(ModelViewMat, Position, FogShape);
}
