/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.capability;

import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;

public interface IThermalFluidHandlerItemStack {
    default public boolean canFillFluidType(FluidStack stack) {
        if (stack == null || stack.getFluid() == null) {
            return false;
        }
        FluidType fluidType = stack.getFluid().getFluidType();
        int temp = fluidType.getTemperature();
        if (temp > this.getMaxFluidTemperature()) {
            return false;
        }
        if (temp < 120 && !this.isCryoProof()) {
            return false;
        }
        return !fluidType.isLighterThanAir() || this.isGasProof();
    }

    public int getMaxFluidTemperature();

    public boolean isGasProof();

    public boolean isAcidProof();

    public boolean isCryoProof();

    public boolean isPlasmaProof();
}

