/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.ItemMaterialInfo;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKey;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.data.recipe.misc.WoodMachineRecipes;
import com.gregtechceu.gtceu.data.tags.TagsHandler;
import com.gregtechceu.gtceu.utils.SupplierMemoizer;
import com.mojang.datafixers.util.Pair;
import com.tterrag.registrate.util.entry.BlockEntry;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChemicalHelper {
    public static final Map<ItemLike, ItemMaterialInfo> ITEM_MATERIAL_INFO = new ConcurrentHashMap<ItemLike, ItemMaterialInfo>();
    public static final Set<Map.Entry<Supplier<? extends ItemLike>, UnificationEntry>> ITEM_UNIFICATION_ENTRY = ConcurrentHashMap.newKeySet();
    public static final Map<ItemLike, UnificationEntry> ITEM_UNIFICATION_ENTRY_COLLECTED = new ConcurrentHashMap<ItemLike, UnificationEntry>();
    public static final Map<TagKey<Item>, UnificationEntry> TAG_UNIFICATION_ENTRY = new Object2ObjectLinkedOpenHashMap();
    public static final Map<Fluid, Material> FLUID_MATERIAL = new ConcurrentHashMap<Fluid, Material>();
    public static final Map<UnificationEntry, ArrayList<Supplier<? extends ItemLike>>> UNIFICATION_ENTRY_ITEM = new ConcurrentHashMap<UnificationEntry, ArrayList<Supplier<? extends ItemLike>>>();
    public static final Map<UnificationEntry, ArrayList<Supplier<? extends Block>>> UNIFICATION_ENTRY_BLOCK = new ConcurrentHashMap<UnificationEntry, ArrayList<Supplier<? extends Block>>>();
    public static final Map<Supplier<BlockState>, TagPrefix> ORES_INVERSE = new ConcurrentHashMap<Supplier<BlockState>, TagPrefix>();

    public static void registerMaterialInfo(ItemLike item, ItemMaterialInfo materialInfo) {
        ITEM_MATERIAL_INFO.put(item, materialInfo);
    }

    public static ItemMaterialInfo getMaterialInfo(ItemLike item) {
        return ITEM_MATERIAL_INFO.get(item);
    }

    @SafeVarargs
    public static void registerUnificationItems(UnificationEntry unificationEntry, Supplier<? extends ItemLike> ... items) {
        UNIFICATION_ENTRY_ITEM.computeIfAbsent(unificationEntry, entry -> new ArrayList()).addAll(Arrays.asList(items));
        for (Supplier<? extends ItemLike> supplier : items) {
            ITEM_UNIFICATION_ENTRY.add(Map.entry(supplier, unificationEntry));
            if (supplier instanceof Block) {
                Block block = (Block)supplier;
                UNIFICATION_ENTRY_BLOCK.computeIfAbsent(unificationEntry, entry -> new ArrayList()).add(() -> block);
                continue;
            }
            if (supplier instanceof BlockEntry) {
                BlockEntry blockEntry = (BlockEntry)supplier;
                UNIFICATION_ENTRY_BLOCK.computeIfAbsent(unificationEntry, entry -> new ArrayList()).add(blockEntry);
                continue;
            }
            if (supplier instanceof RegistryObject) {
                RegistryObject registryObject = (RegistryObject)supplier;
                if (!registryObject.getKey().m_135783_(Registries.f_256747_)) continue;
                UNIFICATION_ENTRY_BLOCK.computeIfAbsent(unificationEntry, entry -> new ArrayList()).add(registryObject);
                continue;
            }
            if (!(supplier instanceof SupplierMemoizer.MemoizedBlockSupplier)) continue;
            SupplierMemoizer.MemoizedBlockSupplier supplier2 = (SupplierMemoizer.MemoizedBlockSupplier)supplier;
            UNIFICATION_ENTRY_BLOCK.computeIfAbsent(unificationEntry, entry -> new ArrayList()).add(supplier2);
        }
        if (TagPrefix.ORES.containsKey(unificationEntry.tagPrefix) && !ORES_INVERSE.containsValue(unificationEntry.tagPrefix)) {
            ORES_INVERSE.put(TagPrefix.ORES.get(unificationEntry.tagPrefix).stoneType(), unificationEntry.tagPrefix);
        }
        for (Supplier<? extends ItemLike> supplier : unificationEntry.tagPrefix.getAllItemTags(unificationEntry.material)) {
            TAG_UNIFICATION_ENTRY.putIfAbsent((TagKey<Item>)supplier, unificationEntry);
        }
    }

    @SafeVarargs
    public static void registerUnificationItems(TagPrefix tagPrefix, @Nullable Material material, Supplier<? extends ItemLike> ... items) {
        ChemicalHelper.registerUnificationItems(new UnificationEntry(tagPrefix, material), items);
    }

    public static void registerUnificationItems(TagPrefix tagPrefix, @Nullable Material material, ItemLike ... items) {
        ChemicalHelper.registerUnificationItems(new UnificationEntry(tagPrefix, material), (Supplier[])Arrays.stream(items).map(item -> () -> item).toArray(Supplier[]::new));
        for (ItemLike item2 : items) {
            ITEM_UNIFICATION_ENTRY_COLLECTED.put(item2, new UnificationEntry(tagPrefix, material));
        }
    }

    @Nullable
    public static MaterialStack getMaterial(Object object) {
        if (object instanceof MaterialStack) {
            MaterialStack materialStack = (MaterialStack)object;
            return materialStack;
        }
        if (object instanceof UnificationEntry) {
            UnificationEntry entry = (UnificationEntry)object;
            return ChemicalHelper.getMaterial(entry);
        }
        if (object instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)object;
            return ChemicalHelper.getMaterial(itemStack);
        }
        if (object instanceof ItemLike) {
            ItemLike item = (ItemLike)object;
            return ChemicalHelper.getMaterial(item);
        }
        return null;
    }

    @Nullable
    public static MaterialStack getMaterial(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return null;
        }
        return ChemicalHelper.getMaterial((ItemLike)itemStack.m_41720_());
    }

    @Nullable
    public static MaterialStack getMaterial(UnificationEntry entry) {
        Material entryMaterial;
        if (entry != null && (entryMaterial = entry.material) != null) {
            return new MaterialStack(entryMaterial, entry.tagPrefix.getMaterialAmount(entryMaterial));
        }
        return null;
    }

    @Nullable
    public static MaterialStack getMaterial(ItemLike itemLike) {
        Material entryMaterial;
        UnificationEntry entry = ChemicalHelper.getUnificationEntry(itemLike);
        if (entry != null && (entryMaterial = entry.material) != null) {
            return new MaterialStack(entryMaterial, entry.tagPrefix.getMaterialAmount(entryMaterial));
        }
        ItemMaterialInfo info = ITEM_MATERIAL_INFO.get(itemLike);
        return info == null ? null : info.getMaterial().copy();
    }

    @Nullable
    public static Material getMaterial(Fluid fluid) {
        if (FLUID_MATERIAL.isEmpty()) {
            Set allFluidTags = BuiltInRegistries.f_257020_.m_203613_().collect(Collectors.toSet());
            for (Material material : GTCEuAPI.materialManager.getRegisteredMaterials()) {
                if (!material.hasProperty(PropertyKey.FLUID)) continue;
                FluidProperty property = material.getProperty(PropertyKey.FLUID);
                FluidStorageKey.allKeys().stream().map(key -> property.get((FluidStorageKey)key)).filter(Objects::nonNull).map(f -> Pair.of((Object)f, TagUtil.createFluidTag(BuiltInRegistries.f_257020_.m_7981_(f).m_135815_()))).filter(pair -> allFluidTags.contains(pair.getSecond())).forEach(pair -> {
                    allFluidTags.remove(pair.getSecond());
                    FLUID_MATERIAL.put((Fluid)pair.getFirst(), material);
                });
            }
        }
        return FLUID_MATERIAL.get(fluid);
    }

    @Nullable
    public static TagPrefix getPrefix(ItemLike itemLike) {
        if (itemLike == null) {
            return null;
        }
        UnificationEntry entry = ChemicalHelper.getUnificationEntry(itemLike);
        if (entry != null) {
            return entry.tagPrefix;
        }
        return null;
    }

    public static ItemStack getDust(Material material, long materialAmount) {
        if (!material.hasProperty(PropertyKey.DUST) || materialAmount <= 0L) {
            return ItemStack.f_41583_;
        }
        if (materialAmount % 3628800L == 0L || materialAmount >= 58060800L) {
            return ChemicalHelper.get(TagPrefix.dust, material, (int)(materialAmount / 3628800L));
        }
        if (materialAmount * 4L % 3628800L == 0L || materialAmount >= 29030400L) {
            return ChemicalHelper.get(TagPrefix.dustSmall, material, (int)(materialAmount * 4L / 3628800L));
        }
        if (materialAmount * 9L >= 3628800L) {
            return ChemicalHelper.get(TagPrefix.dustTiny, material, (int)(materialAmount * 9L / 3628800L));
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getDust(MaterialStack materialStack) {
        return ChemicalHelper.getDust(materialStack.material(), materialStack.amount());
    }

    public static ItemStack getIngot(Material material, long materialAmount) {
        if (!material.hasProperty(PropertyKey.INGOT) || materialAmount <= 0L) {
            return ItemStack.f_41583_;
        }
        if (materialAmount % 32659200L == 0L) {
            return ChemicalHelper.get(TagPrefix.block, material, (int)(materialAmount / 32659200L));
        }
        if (materialAmount % 3628800L == 0L || materialAmount >= 58060800L) {
            return ChemicalHelper.get(TagPrefix.ingot, material, (int)(materialAmount / 3628800L));
        }
        if (materialAmount * 9L >= 3628800L) {
            return ChemicalHelper.get(TagPrefix.nugget, material, (int)(materialAmount * 9L / 3628800L));
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getIngotOrDust(Material material, long materialAmount) {
        ItemStack ingotStack = ChemicalHelper.getIngot(material, materialAmount);
        if (ingotStack != ItemStack.f_41583_) {
            return ingotStack;
        }
        return ChemicalHelper.getDust(material, materialAmount);
    }

    public static ItemStack getIngotOrDust(MaterialStack materialStack) {
        return ChemicalHelper.getIngotOrDust(materialStack.material(), materialStack.amount());
    }

    public static ItemStack getGem(MaterialStack materialStack) {
        if (materialStack.material().hasProperty(PropertyKey.GEM) && !TagPrefix.gem.isIgnored(materialStack.material()) && materialStack.amount() == TagPrefix.gem.getMaterialAmount(materialStack.material())) {
            return ChemicalHelper.get(TagPrefix.gem, materialStack.material(), (int)(materialStack.amount() / 3628800L));
        }
        return ChemicalHelper.getDust(materialStack);
    }

    @Nullable
    public static UnificationEntry getUnificationEntry(ItemLike itemLike) {
        Item itemKey = itemLike.m_5456_();
        UnificationEntry unifyingEntry = ITEM_UNIFICATION_ENTRY_COLLECTED.get(itemKey);
        if (unifyingEntry == null) {
            ITEM_UNIFICATION_ENTRY.removeIf(entry -> {
                ITEM_UNIFICATION_ENTRY_COLLECTED.put((ItemLike)((ItemLike)((Supplier)entry.getKey()).get()).m_5456_(), (UnificationEntry)entry.getValue());
                return true;
            });
            unifyingEntry = ITEM_UNIFICATION_ENTRY_COLLECTED.computeIfAbsent((ItemLike)itemKey, item -> {
                for (TagKey itemTag : item.m_5456_().m_204114_().m_203616_().toList()) {
                    UnificationEntry unificationEntry = ChemicalHelper.getUnificationEntry((TagKey<Item>)itemTag);
                    if (unificationEntry == null) continue;
                    if (!Arrays.stream(unificationEntry.tagPrefix.getItemParentTags()).noneMatch(arg_0 -> ((TagKey)itemTag).equals(arg_0))) continue;
                    return unificationEntry;
                }
                return UnificationEntry.EmptyMapMarkerEntry;
            });
        }
        return unifyingEntry != UnificationEntry.EmptyMapMarkerEntry ? unifyingEntry : null;
    }

    public static UnificationEntry getUnificationEntry(TagKey<Item> tag) {
        if (TAG_UNIFICATION_ENTRY.isEmpty()) {
            Set allItemTags = BuiltInRegistries.f_257033_.m_203613_().collect(Collectors.toSet());
            for (TagPrefix prefix : TagPrefix.values()) {
                for (Material material : GTCEuAPI.materialManager.getRegisteredMaterials()) {
                    Arrays.stream(prefix.getItemTags(material)).filter(allItemTags::contains).forEach(tagKey -> {
                        allItemTags.remove(tagKey);
                        TAG_UNIFICATION_ENTRY.put((TagKey<Item>)tagKey, new UnificationEntry(prefix, material));
                    });
                }
            }
        }
        return TAG_UNIFICATION_ENTRY.get(tag);
    }

    public static List<ItemLike> getItems(UnificationEntry unificationEntry) {
        return UNIFICATION_ENTRY_ITEM.computeIfAbsent(unificationEntry, entry -> {
            ArrayList<Supplier<ItemLike>> items = new ArrayList<Supplier<ItemLike>>();
            for (TagKey<Item> tag : ChemicalHelper.getTags(entry.tagPrefix, entry.material)) {
                for (Holder itemHolder : BuiltInRegistries.f_257033_.m_206058_(tag)) {
                    items.add(() -> ((Holder)itemHolder).m_203334_());
                }
            }
            TagPrefix prefix = entry.tagPrefix;
            if (items.isEmpty() && prefix.hasItemTable() && prefix.doGenerateItem(entry.material)) {
                return new ArrayList<Supplier<ItemLike>>(List.of(prefix.getItemFromTable(entry.material)));
            }
            return items;
        }).stream().map(Supplier::get).collect(Collectors.toList());
    }

    public static ItemStack get(UnificationEntry unificationEntry, int size) {
        List<ItemLike> list = ChemicalHelper.getItems(unificationEntry);
        if (list.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = list.get(0).m_5456_().m_7968_();
        stack.m_41764_(size);
        return stack;
    }

    public static ItemStack get(TagPrefix orePrefix, Material material, int stackSize) {
        return ChemicalHelper.get(new UnificationEntry(orePrefix, material), stackSize);
    }

    public static ItemStack get(TagPrefix orePrefix, Material material) {
        return ChemicalHelper.get(orePrefix, material, 1);
    }

    public static List<Block> getBlocks(UnificationEntry unificationEntry) {
        return UNIFICATION_ENTRY_BLOCK.computeIfAbsent(unificationEntry, entry -> {
            ArrayList<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
            for (TagKey tag : Arrays.stream(ChemicalHelper.getTags(unificationEntry.tagPrefix, unificationEntry.material)).map(itemTagKey -> TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)itemTagKey.f_203868_())).toList()) {
                for (Holder itemHolder : BuiltInRegistries.f_256975_.m_206058_(tag)) {
                    blocks.add(() -> ((Holder)itemHolder).m_203334_());
                }
            }
            return blocks;
        }).stream().map(Supplier::get).collect(Collectors.toList());
    }

    public static Block getBlock(UnificationEntry unificationEntry) {
        List<Block> list = ChemicalHelper.getBlocks(unificationEntry);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public static Block getBlock(TagPrefix orePrefix, Material material) {
        return ChemicalHelper.getBlock(new UnificationEntry(orePrefix, material));
    }

    @Nullable
    public static TagKey<Block> getBlockTag(TagPrefix orePrefix, @NotNull Material material) {
        TagKey<Block>[] tags = orePrefix.getBlockTags(material);
        if (tags.length > 0) {
            return tags[0];
        }
        return null;
    }

    @Nullable
    public static TagKey<Item> getTag(TagPrefix orePrefix, @NotNull Material material) {
        TagKey<Item>[] tags = orePrefix.getItemTags(material);
        if (tags.length > 0) {
            return tags[0];
        }
        return null;
    }

    public static TagKey<Item>[] getTags(TagPrefix orePrefix, @NotNull Material material) {
        return orePrefix.getItemTags(material);
    }

    public static List<Map.Entry<ItemStack, ItemMaterialInfo>> getAllItemInfos() {
        return ITEM_MATERIAL_INFO.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<ItemStack, ItemMaterialInfo>(new ItemStack((ItemLike)((ItemLike)entry.getKey()).m_5456_()), (ItemMaterialInfo)entry.getValue())).collect(Collectors.toList());
    }

    public static Optional<TagPrefix> getOrePrefix(BlockState state) {
        return ORES_INVERSE.entrySet().stream().filter(entry -> ((BlockState)((Supplier)entry.getKey()).get()).equals(state)).map(Map.Entry::getValue).findFirst();
    }

    public static void reinitializeUnification() {
        UNIFICATION_ENTRY_ITEM.clear();
        UNIFICATION_ENTRY_BLOCK.clear();
        ITEM_UNIFICATION_ENTRY.clear();
        FLUID_MATERIAL.clear();
        TagsHandler.initExtraUnificationEntries();
        for (TagPrefix prefix : TagPrefix.values()) {
            prefix.getIgnored().forEach((mat, items) -> {
                if (((Supplier[])items).length > 0) {
                    ChemicalHelper.registerUnificationItems(prefix, mat, items);
                }
            });
        }
        GTItems.toUnify.forEach((x$0, xva$1) -> ChemicalHelper.registerUnificationItems(x$0, xva$1));
        WoodMachineRecipes.registerUnificationInfo();
    }
}

