/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical.material.properties;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IMaterialProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.MaterialProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import java.util.Objects;

public class WireProperties
implements IMaterialProperty<WireProperties> {
    private long voltage;
    private int amperage;
    private int lossPerBlock;
    private int superconductorCriticalTemperature;
    private boolean isSuperconductor;

    public WireProperties(long voltage, int baseAmperage, int lossPerBlock) {
        this(voltage, baseAmperage, lossPerBlock, false);
    }

    public WireProperties(long voltage, int baseAmperage, int lossPerBlock, boolean isSuperCon) {
        this(voltage, baseAmperage, lossPerBlock, isSuperCon, 0);
    }

    public WireProperties(long voltage, int baseAmperage, int lossPerBlock, boolean isSuperCon, int criticalTemperature) {
        this.voltage = voltage;
        this.amperage = baseAmperage;
        this.lossPerBlock = isSuperCon ? 0 : lossPerBlock;
        this.superconductorCriticalTemperature = isSuperCon ? criticalTemperature : 0;
        this.isSuperconductor = isSuperCon;
    }

    public WireProperties copy() {
        return new WireProperties(this.voltage, this.amperage, this.lossPerBlock, this.isSuperconductor, this.superconductorCriticalTemperature);
    }

    public WireProperties() {
        this(8L, 1, 1, false);
    }

    public long getVoltage() {
        return this.voltage;
    }

    public void setVoltage(long voltage) {
        this.voltage = voltage;
    }

    public int getAmperage() {
        return this.amperage;
    }

    public void setAmperage(int amperage) {
        this.amperage = amperage;
    }

    public int getLossPerBlock() {
        return this.lossPerBlock;
    }

    public void setLossPerBlock(int lossPerBlock) {
        this.lossPerBlock = lossPerBlock;
    }

    public boolean isSuperconductor() {
        return this.isSuperconductor;
    }

    public void setSuperconductor(boolean isSuperconductor) {
        this.isSuperconductor = isSuperconductor;
    }

    public int getSuperconductorCriticalTemperature() {
        return this.superconductorCriticalTemperature;
    }

    public void setSuperconductorCriticalTemperature(int criticalTemperature) {
        this.superconductorCriticalTemperature = this.isSuperconductor ? criticalTemperature : 0;
    }

    @Override
    public void verifyProperty(MaterialProperties properties) {
        properties.ensureSet(PropertyKey.DUST, true);
        if (properties.hasProperty(PropertyKey.INGOT)) {
            Material thisMaterial = properties.getMaterial();
            if (!this.isSuperconductor && this.voltage >= GTValues.V[5] && !thisMaterial.hasFlag(MaterialFlags.GENERATE_FOIL)) {
                thisMaterial.addFlags(MaterialFlags.GENERATE_FOIL);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WireProperties)) {
            return false;
        }
        WireProperties that = (WireProperties)o;
        return this.voltage == that.voltage && this.amperage == that.amperage && this.lossPerBlock == that.lossPerBlock && this.superconductorCriticalTemperature == that.superconductorCriticalTemperature && this.isSuperconductor == that.isSuperconductor;
    }

    public int hashCode() {
        return Objects.hash(this.voltage, this.amperage, this.lossPerBlock);
    }
}

