/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.generator.indicators;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.gregtechceu.gtceu.api.data.worldgen.generator.IndicatorGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVeinMetadata;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreIndicatorPlacer;
import com.gregtechceu.gtceu.common.block.SurfaceRockBlock;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SurfaceIndicatorGenerator
extends IndicatorGenerator {
    public static final Codec<SurfaceIndicatorGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either((Codec)BlockState.f_61039_, GTCEuAPI.materialManager.codec()).fieldOf("block").forGetter(ext -> ext.block), (App)IntProvider.m_146545_((int)1, (int)32).fieldOf("radius").forGetter(ext -> ext.radius), (App)FloatProvider.m_146505_((float)0.0f, (float)2.0f).fieldOf("density").forGetter(ext -> ext.density), (App)IndicatorPlacement.CODEC.fieldOf("placement").forGetter(ext -> ext.placement)).apply((Applicative)instance, SurfaceIndicatorGenerator::new));
    private Either<BlockState, Material> block = Either.left((Object)Blocks.f_50016_.m_49966_());
    private IntProvider radius = ConstantInt.m_146483_((int)5);
    private FloatProvider density = ConstantFloat.m_146458_((float)0.2f);
    private IndicatorPlacement placement = IndicatorPlacement.SURFACE;

    public SurfaceIndicatorGenerator(GTOreDefinition entry) {
        super(entry);
    }

    public SurfaceIndicatorGenerator(Either<BlockState, Material> block, IntProvider radius, FloatProvider density, IndicatorPlacement placement) {
        this.block = block;
        this.radius = radius;
        this.density = density;
        this.placement = placement;
        block.ifRight(SurfaceIndicatorGenerator::validateSurfaceRockMaterial);
    }

    public SurfaceIndicatorGenerator surfaceRock(Material material) {
        SurfaceIndicatorGenerator.validateSurfaceRockMaterial(material);
        this.block = Either.right((Object)material);
        return this;
    }

    public SurfaceIndicatorGenerator block(Block block) {
        return this.state(block.m_49966_());
    }

    public SurfaceIndicatorGenerator state(BlockState state) {
        this.block = Either.left((Object)state);
        return this;
    }

    public SurfaceIndicatorGenerator radius(int radius) {
        return this.radius((IntProvider)ConstantInt.m_146483_((int)radius));
    }

    public SurfaceIndicatorGenerator radius(IntProvider provider) {
        this.radius = provider;
        return this;
    }

    public SurfaceIndicatorGenerator density(float density) {
        return this.density((FloatProvider)ConstantFloat.m_146458_((float)density));
    }

    public SurfaceIndicatorGenerator density(FloatProvider provider) {
        this.density = provider;
        return this;
    }

    public SurfaceIndicatorGenerator placement(IndicatorPlacement placement) {
        this.placement = placement;
        return this;
    }

    private static void validateSurfaceRockMaterial(Material material) {
        if (GTBlocks.SURFACE_ROCK_BLOCKS.get(material) == null) {
            throw new IllegalArgumentException("No surface rock registered for material " + material.getName());
        }
    }

    @Override
    public Map<ChunkPos, OreIndicatorPlacer> generate(WorldGenLevel level, RandomSource random, GeneratedVeinMetadata metadata) {
        BlockState blockState = this.placement.stateTransformer.apply(this.block);
        int radius = this.radius.m_214085_(random);
        float density = this.density.m_214084_(random);
        BlockPos center = metadata.center();
        Stream<BlockPos> positionStream = BlockPos.m_121886_((int)(center.m_123341_() - radius), (int)center.m_123342_(), (int)(center.m_123343_() - radius), (int)(center.m_123341_() + radius), (int)center.m_123342_(), (int)(center.m_123343_() + radius)).map(BlockPos::m_7949_);
        List<BlockPos> positions = positionStream.filter(pos -> pos.equals((Object)center) || random.m_188501_() <= density).filter(pos -> Math.sqrt(pos.m_123331_((Vec3i)center)) <= (double)radius).toList();
        return WorldGeneratorUtils.groupByChunks(positions).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.createPlacer(level, (List)entry.getValue(), blockState)));
    }

    private OreIndicatorPlacer createPlacer(WorldGenLevel level, List<BlockPos> positionsWithoutY, BlockState blockState) {
        return access -> {
            List<BlockPos> positions = positionsWithoutY.stream().map(pos -> (BlockPos)this.placement.resolver.apply((Object)level, (Object)access, pos)).filter(pos -> !level.m_151570_(pos)).toList();
            for (BlockPos pos2 : positions) {
                int sectionZ;
                int sectionY;
                int sectionX;
                LevelChunkSection section = Objects.requireNonNull(access.m_156104_(pos2));
                if (!section.m_62982_(sectionX = SectionPos.m_123207_((int)pos2.m_123341_()), sectionY = SectionPos.m_123207_((int)pos2.m_123342_()), sectionZ = SectionPos.m_123207_((int)pos2.m_123343_())).m_60795_()) {
                    return;
                }
                if (!blockState.m_60710_((LevelReader)level, pos2)) {
                    return;
                }
                section.m_62991_(sectionX, sectionY, sectionZ, blockState, false);
            }
        };
    }

    @Override
    @Nullable
    public Either<BlockState, Material> block() {
        return this.block;
    }

    @Override
    public int getSearchRadiusModifier(int veinRadius) {
        return Math.max(0, this.radius.m_142737_() - veinRadius);
    }

    @Override
    public Codec<? extends IndicatorGenerator> codec() {
        return CODEC;
    }

    public static enum IndicatorPlacement implements StringRepresentable
    {
        SURFACE((TriFunction<WorldGenLevel, BulkSectionAccess, BlockPos, BlockPos>)((TriFunction)(level, access, pos) -> pos.m_175288_(Math.max(level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, pos.m_123341_(), pos.m_123343_()), pos.m_123342_()))), block -> IndicatorPlacement.getBlockState((Either<BlockState, Material>)block, Direction.DOWN)),
        ABOVE((TriFunction<WorldGenLevel, BulkSectionAccess, BlockPos, BlockPos>)((TriFunction)(level, access, initialPos) -> WorldGeneratorUtils.findBlockPos(initialPos, pos -> access.m_156110_(pos).m_60795_() && access.m_156110_(pos.m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP), pos -> pos.m_122175_(Direction.UP, 1), level.m_151558_() - initialPos.m_123342_()).orElse((BlockPos)initialPos)), block -> IndicatorPlacement.getBlockState((Either<BlockState, Material>)block, Direction.DOWN)),
        BELOW((TriFunction<WorldGenLevel, BulkSectionAccess, BlockPos, BlockPos>)((TriFunction)(level, access, initialPos) -> WorldGeneratorUtils.findBlockPos(initialPos, pos -> access.m_156110_(pos).m_60795_() && access.m_156110_(pos.m_7494_()).m_60783_((BlockGetter)level, pos.m_7494_(), Direction.DOWN), pos -> pos.m_122175_(Direction.DOWN, 1), initialPos.m_123342_() - level.m_141937_()).orElse((BlockPos)initialPos)), block -> IndicatorPlacement.getBlockState((Either<BlockState, Material>)block, Direction.UP));

        public static final Codec<IndicatorPlacement> CODEC;
        public final TriFunction<WorldGenLevel, BulkSectionAccess, BlockPos, BlockPos> resolver;
        public final Function<Either<BlockState, Material>, BlockState> stateTransformer;

        private static BlockState getBlockState(Either<BlockState, Material> block, Direction direction) {
            return (BlockState)block.map(state -> state, material -> ((SurfaceRockBlock)((Object)((Object)GTBlocks.SURFACE_ROCK_BLOCKS.get(material).get()))).getStateForDirection(direction));
        }

        public String m_7912_() {
            return this.name().toLowerCase();
        }

        @Nullable
        public static IndicatorPlacement getByName(String name) {
            return IndicatorPlacement.valueOf(name.toUpperCase());
        }

        private IndicatorPlacement(TriFunction<WorldGenLevel, BulkSectionAccess, BlockPos, BlockPos> resolver, Function<Either<BlockState, Material>, BlockState> stateTransformer) {
            this.resolver = resolver;
            this.stateTransformer = stateTransformer;
        }

        static {
            CODEC = StringRepresentable.m_216439_(IndicatorPlacement::values);
        }
    }
}

