/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.modifier;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.mojang.serialization.Codec;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FrequencyModifier
extends PlacementModifier {
    public static final PlacementModifierType<FrequencyModifier> FREQUENCY_MODIFIER = GTRegistries.register(BuiltInRegistries.f_256986_, GTCEu.id("frequency"), () -> CODEC);
    public static final Codec<FrequencyModifier> CODEC = ExtraCodecs.f_184349_.fieldOf("chance").xmap(FrequencyModifier::new, modifier -> Float.valueOf(modifier.frequency)).codec();
    private final float frequency;

    public FrequencyModifier(float frequency) {
        this.frequency = frequency;
    }

    public Stream<BlockPos> m_213676_(PlacementContext context, RandomSource random, BlockPos pos) {
        int count = this.getCount(this.frequency, random);
        if (count == 0) {
            return Stream.empty();
        }
        return Stream.of(pos);
    }

    public int getCount(float frequency, RandomSource random) {
        int floored = Mth.m_14143_((float)frequency);
        return floored + (random.m_188501_() < frequency - (float)floored ? 1 : 0);
    }

    public PlacementModifierType<?> m_183327_() {
        return FREQUENCY_MODIFIER;
    }
}

