/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.compass;

import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.pattern.MultiblockShapeInfo;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.Action;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.AnimationFrame;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.BlockAnima;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.CompassScene;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.XmlUtils;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public class MultiblockAction
extends Action {
    private final BlockAnima animation;
    @Nullable
    private final MultiblockMachineDefinition machineDefinition;
    private final int shapeIndex;
    private final boolean isFormed;
    private final Direction facing;

    public MultiblockAction(Element element) {
        MachineDefinition definition;
        String machineName = XmlUtils.getAsString((Element)element, (String)"machine", (String)"");
        BlockPos blockPos = XmlUtils.getAsBlockPos((Element)element, (String)"pos", (BlockPos)BlockPos.f_121853_);
        this.shapeIndex = XmlUtils.getAsInt((Element)element, (String)"shape-index", (int)0);
        this.facing = (Direction)XmlUtils.getAsEnum((Element)element, (String)"facing", Direction.class, (Enum)Direction.NORTH);
        this.isFormed = XmlUtils.getAsBoolean((Element)element, (String)"formed", (boolean)true);
        this.animation = new BlockAnima(blockPos, XmlUtils.getAsVec3((Element)element, (String)"offset", (Vec3)new Vec3(0.0, 0.7, 0.0)), XmlUtils.getAsInt((Element)element, (String)"duration", (int)15));
        if (ResourceLocation.m_135830_((String)machineName) && (definition = (MachineDefinition)GTRegistries.MACHINES.get(new ResourceLocation(machineName))) instanceof MultiblockMachineDefinition) {
            MultiblockMachineDefinition multiblockDefinition;
            this.machineDefinition = multiblockDefinition = (MultiblockMachineDefinition)definition;
            return;
        }
        this.machineDefinition = null;
    }

    public int getDuration() {
        return this.machineDefinition == null ? 5 : this.animation.duration() + 5;
    }

    public void performAction(AnimationFrame frame, CompassScene scene, boolean anima) {
        List<MultiblockShapeInfo> shapes;
        if (this.machineDefinition != null && !(shapes = this.machineDefinition.getMatchingShapes()).isEmpty()) {
            MultiblockShapeInfo shape = shapes.get(0);
            if (this.shapeIndex < shapes.size()) {
                shape = shapes.get(this.shapeIndex);
            }
            BlockInfo[][][] blocks = shape.getBlocks();
            HashMap<BlockPos, BlockInfo> blockMap = new HashMap<BlockPos, BlockInfo>();
            BlockPos offset = BlockPos.f_121853_;
            for (int x = 0; x < blocks.length; ++x) {
                BlockInfo[][] aisle = blocks[x];
                for (int y = 0; y < aisle.length; ++y) {
                    BlockInfo[] column = aisle[y];
                    for (int z = 0; z < column.length; ++z) {
                        IMachineBlockEntity holder;
                        BlockState blockState = column[z].getBlockState();
                        BlockPos pos2 = this.animation.pos().m_7918_(x, y, z);
                        BlockEntity blockEntity = column[z].getBlockEntity(pos2);
                        if (blockEntity instanceof IMachineBlockEntity && (holder = (IMachineBlockEntity)blockEntity).getMetaMachine() instanceof IMultiController) {
                            offset = pos2;
                        }
                        blockMap.put(pos2, BlockInfo.fromBlockState((BlockState)blockState));
                    }
                }
            }
            BlockPos finalOffset = offset;
            blockMap.forEach((pos, blockInfo) -> scene.addBlock(pos.m_121996_((Vec3i)finalOffset).m_121955_((Vec3i)this.animation.pos()), blockInfo, anima ? this.animation : null));
        }
    }
}

