/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.widget;

import com.gregtechceu.gtceu.api.transfer.item.CycleItemStackHandler;
import com.gregtechceu.gtceu.api.transfer.item.TagOrCycleItemStackHandler;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.runtime.ConfiguratorParser;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.jei.JEIPlugin;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

@LDLRegister(name="item_slot", group="widget.container", priority=50)
public class SlotWidget
extends com.lowdragmc.lowdraglib.gui.widget.SlotWidget {
    public SlotWidget() {
    }

    public SlotWidget(Container inventory, int slotIndex, int xPosition, int yPosition, boolean canTakeItems, boolean canPutItems) {
        super(inventory, slotIndex, xPosition, yPosition, canTakeItems, canPutItems);
    }

    public SlotWidget(IItemHandlerModifiable itemHandler, int slotIndex, int xPosition, int yPosition, boolean canTakeItems, boolean canPutItems) {
        this.setSelfPosition(xPosition, yPosition);
        this.setSize(18, 18);
        this.recomputePosition();
        this.setVisible(true);
        this.setActive(true);
        this.drawHoverOverlay = true;
        this.drawHoverTips = true;
        this.ingredientIO = IngredientIO.RENDER_ONLY;
        this.XEIChance = 1.0f;
        this.setBackgroundTexture((IGuiTexture)ITEM_SLOT_TEXTURE);
        this.canTakeItems = canTakeItems;
        this.canPutItems = canPutItems;
        this.setHandlerSlot(itemHandler, slotIndex);
    }

    public SlotWidget(IItemHandlerModifiable itemHandler, int slotIndex, int xPosition, int yPosition) {
        this(itemHandler, slotIndex, xPosition, yPosition, true, true);
    }

    public SlotWidget(Container container, int slotIndex, int xPosition, int yPosition) {
        this(container, slotIndex, xPosition, yPosition, true, true);
    }

    protected Slot createSlot(IItemHandlerModifiable itemHandler, int index) {
        return new WidgetSlotItemHandler(itemHandler, index, 0, 0);
    }

    public SlotWidget setContainerSlot(Container inventory, int slotIndex) {
        super.setContainerSlot(inventory, slotIndex);
        return this;
    }

    public SlotWidget setHandlerSlot(IItemTransfer itemHandler, int slotIndex) {
        super.setHandlerSlot(itemHandler, slotIndex);
        return this;
    }

    public SlotWidget setHandlerSlot(IItemHandlerModifiable itemHandler, int slotIndex) {
        this.updateSlot(this.createSlot(itemHandler, slotIndex));
        return this;
    }

    public SlotWidget setBackgroundTexture(IGuiTexture backgroundTexture) {
        super.setBackgroundTexture(backgroundTexture);
        return this;
    }

    public SlotWidget setLocationInfo(boolean isPlayerContainer, boolean isPlayerHotBar) {
        super.setLocationInfo(isPlayerContainer, isPlayerHotBar);
        return this;
    }

    public SlotWidget setCanTakeItems(boolean canTakeItems) {
        super.setCanTakeItems(canTakeItems);
        return this;
    }

    public SlotWidget setCanPutItems(boolean canPutItems) {
        super.setCanPutItems(canPutItems);
        return this;
    }

    public SlotWidget setDrawHoverOverlay(boolean drawHoverOverlay) {
        super.setDrawHoverOverlay(drawHoverOverlay);
        return this;
    }

    public SlotWidget setDrawHoverTips(boolean drawHoverTips) {
        super.setDrawHoverTips(drawHoverTips);
        return this;
    }

    public SlotWidget setIngredientIO(IngredientIO ingredientIO) {
        super.setIngredientIO(ingredientIO);
        return this;
    }

    public SlotWidget setChangeListener(Runnable changeListener) {
        super.setChangeListener(changeListener);
        return this;
    }

    public SlotWidget setXEIChance(float XEIChance) {
        super.setXEIChance(XEIChance);
        return this;
    }

    public SlotWidget setItemHook(Function<ItemStack, ItemStack> itemHook) {
        super.setItemHook(itemHook);
        return this;
    }

    public SlotWidget setOnAddedTooltips(BiConsumer<com.lowdragmc.lowdraglib.gui.widget.SlotWidget, List<Component>> onAddedTooltips) {
        super.setOnAddedTooltips(onAddedTooltips);
        return this;
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        ItemStackHandler handler = new ItemStackHandler();
        handler.setStackInSlot(0, Blocks.f_50069_.m_5456_().m_7968_());
        father.addConfigurators(new Configurator[]{new WrapperConfigurator("ldlib.gui.editor.group.preview", (Widget)new SlotWidget(){

            public void updateScreen() {
                super.updateScreen();
                this.setHoverTooltips(SlotWidget.this.tooltipTexts);
                this.backgroundTexture = SlotWidget.this.backgroundTexture;
                this.hoverTexture = SlotWidget.this.hoverTexture;
                this.drawHoverOverlay = SlotWidget.this.drawHoverOverlay;
                this.drawHoverTips = SlotWidget.this.drawHoverTips;
                this.overlay = SlotWidget.this.overlay;
            }
        }.setCanPutItems(false).setCanTakeItems(false).setHandlerSlot((IItemHandlerModifiable)handler, 0))});
        ConfiguratorParser.createConfigurators((ConfiguratorGroup)father, new HashMap(), ((Object)((Object)this)).getClass(), (Object)((Object)this));
    }

    @Nullable
    public Object getXEIIngredientOverMouse(double mouseX, double mouseY) {
        if (this.self().isMouseOverElement(mouseX, mouseY)) {
            Slot handler = this.getHandler();
            if (handler == null) {
                return null;
            }
            ItemStack realStack = this.getRealStack(handler.m_7993_());
            if (handler instanceof WidgetSlotItemHandler) {
                WidgetSlotItemHandler slotHandler = (WidgetSlotItemHandler)handler;
                IItemHandlerModifiable iItemHandlerModifiable = slotHandler.itemHandler;
                if (iItemHandlerModifiable instanceof CycleItemStackHandler) {
                    CycleItemStackHandler cycleHandler = (CycleItemStackHandler)iItemHandlerModifiable;
                    return this.getXEIIngredientsFromCycleHandlerClickable(cycleHandler, slotHandler.index);
                }
                iItemHandlerModifiable = slotHandler.itemHandler;
                if (iItemHandlerModifiable instanceof TagOrCycleItemStackHandler) {
                    TagOrCycleItemStackHandler tagHandler = (TagOrCycleItemStackHandler)iItemHandlerModifiable;
                    return this.getXEIIngredientsFromTagOrCycleHandlerClickable(tagHandler, slotHandler.index);
                }
            }
            if (LDLib.isJeiLoaded() && !realStack.m_41619_()) {
                return JEIPlugin.getItemIngredient((ItemStack)realStack, (int)this.getPositionX(), (int)this.getPositionY(), (int)this.getSizeWidth(), (int)this.getSizeHeight());
            }
            if (LDLib.isReiLoaded()) {
                return SlotWidget.REICallWrapper.getReiIngredients((ItemStack)realStack);
            }
            if (LDLib.isEmiLoaded()) {
                return SlotWidget.EMICallWrapper.getEmiIngredients((ItemStack)realStack, (float)this.getXEIChance());
            }
            return realStack;
        }
        return null;
    }

    public List<Object> getXEIIngredients() {
        if (this.slotReference == null || this.slotReference.m_7993_().m_41619_()) {
            return Collections.emptyList();
        }
        Slot handler = this.getHandler();
        if (handler == null) {
            return Collections.emptyList();
        }
        ItemStack realStack = this.getRealStack(handler.m_7993_());
        if (handler instanceof WidgetSlotItemHandler) {
            WidgetSlotItemHandler slotHandler = (WidgetSlotItemHandler)handler;
            IItemHandlerModifiable iItemHandlerModifiable = slotHandler.itemHandler;
            if (iItemHandlerModifiable instanceof CycleItemStackHandler) {
                CycleItemStackHandler cycleHandler = (CycleItemStackHandler)iItemHandlerModifiable;
                return this.getXEIIngredientsFromCycleHandlerClickable(cycleHandler, slotHandler.index);
            }
            iItemHandlerModifiable = slotHandler.itemHandler;
            if (iItemHandlerModifiable instanceof TagOrCycleItemStackHandler) {
                TagOrCycleItemStackHandler tagHandler = (TagOrCycleItemStackHandler)iItemHandlerModifiable;
                return this.getXEIIngredientsFromTagOrCycleHandlerClickable(tagHandler, slotHandler.index);
            }
        }
        if (LDLib.isJeiLoaded()) {
            Object ingredient = JEIPlugin.getItemIngredient((ItemStack)realStack, (int)this.getPosition().x, (int)this.getPosition().y, (int)this.getSize().width, (int)this.getSize().height);
            return ingredient == null ? Collections.emptyList() : List.of(ingredient);
        }
        if (LDLib.isReiLoaded()) {
            return SlotWidget.REICallWrapper.getReiIngredients((ItemStack)realStack);
        }
        if (LDLib.isEmiLoaded()) {
            return SlotWidget.EMICallWrapper.getEmiIngredients((ItemStack)realStack, (float)this.getXEIChance());
        }
        return List.of(realStack);
    }

    private List<Object> getXEIIngredientsFromCycleHandler(CycleItemStackHandler handler, int index) {
        Stream<ItemStack> stream = handler.getStackList(index).stream().map(arg_0 -> ((SlotWidget)this).getRealStack(arg_0));
        if (LDLib.isJeiLoaded()) {
            return stream.filter(stack -> !stack.m_41619_()).collect(Collectors.toList());
        }
        if (LDLib.isReiLoaded()) {
            return SlotWidget.REICallWrapper.getReiIngredients(stream);
        }
        if (LDLib.isEmiLoaded()) {
            return SlotWidget.EMICallWrapper.getEmiIngredients(stream, (float)this.getXEIChance());
        }
        return Collections.emptyList();
    }

    private List<Object> getXEIIngredientsFromCycleHandlerClickable(CycleItemStackHandler handler, int index) {
        Stream<ItemStack> stream = handler.getStackList(index).stream().map(arg_0 -> ((SlotWidget)this).getRealStack(arg_0));
        if (LDLib.isJeiLoaded()) {
            return stream.filter(stack -> !stack.m_41619_()).map(item -> JEIPlugin.getItemIngredient((ItemStack)item, (int)this.getPositionX(), (int)this.getPositionY(), (int)this.getSizeWidth(), (int)this.getSizeHeight())).toList();
        }
        if (LDLib.isReiLoaded()) {
            return SlotWidget.REICallWrapper.getReiIngredients(stream);
        }
        if (LDLib.isEmiLoaded()) {
            return SlotWidget.EMICallWrapper.getEmiIngredients(stream, (float)this.getXEIChance());
        }
        return Collections.emptyList();
    }

    private List<Object> getXEIIngredientsFromTagOrCycleHandler(TagOrCycleItemStackHandler handler, int index) {
        Either<List<Pair<TagKey<Item>, Integer>>, List<ItemStack>> either = handler.getStacks().get(index);
        var ref = new Object(){
            List<Object> returnValue = Collections.emptyList();
        };
        either.ifLeft(list -> {
            if (LDLib.isJeiLoaded()) {
                ref.returnValue = list.stream().flatMap(pair -> BuiltInRegistries.f_257033_.m_203431_((TagKey)pair.getFirst()).stream().flatMap(HolderSet.ListBacked::m_203614_).map(item -> this.getRealStack(new ItemStack((ItemLike)item.m_203334_(), ((Integer)pair.getSecond()).intValue())))).collect(Collectors.toList());
            } else if (LDLib.isReiLoaded()) {
                ref.returnValue = SlotWidget.REICallWrapper.getReiIngredients(arg_0 -> ((SlotWidget)this).getRealStack(arg_0), (List)list);
            } else if (LDLib.isEmiLoaded()) {
                ref.returnValue = SlotWidget.EMICallWrapper.getEmiIngredients((List)list, (float)this.getXEIChance());
            }
        }).ifRight(items -> {
            Stream<ItemStack> stream = items.stream().map(arg_0 -> ((SlotWidget)this).getRealStack(arg_0));
            if (LDLib.isJeiLoaded()) {
                ref.returnValue = stream.filter(stack -> !stack.m_41619_()).collect(Collectors.toList());
            } else if (LDLib.isReiLoaded()) {
                ref.returnValue = SlotWidget.REICallWrapper.getReiIngredients(stream);
            } else if (LDLib.isEmiLoaded()) {
                ref.returnValue = SlotWidget.EMICallWrapper.getEmiIngredients(stream, (float)this.getXEIChance());
            }
        });
        return ref.returnValue;
    }

    private List<Object> getXEIIngredientsFromTagOrCycleHandlerClickable(TagOrCycleItemStackHandler handler, int index) {
        Either<List<Pair<TagKey<Item>, Integer>>, List<ItemStack>> either = handler.getStacks().get(index);
        var ref = new Object(){
            List<Object> returnValue = Collections.emptyList();
        };
        either.ifLeft(list -> {
            if (LDLib.isJeiLoaded()) {
                ref.returnValue = list.stream().flatMap(pair -> BuiltInRegistries.f_257033_.m_203431_((TagKey)pair.getFirst()).stream().flatMap(HolderSet.ListBacked::m_203614_).map(item -> JEIPlugin.getItemIngredient((ItemStack)this.getRealStack(new ItemStack((ItemLike)item.m_203334_(), ((Integer)pair.getSecond()).intValue())), (int)this.getPosition().x, (int)this.getPosition().y, (int)this.getSize().width, (int)this.getSize().height))).collect(Collectors.toList());
            } else if (LDLib.isReiLoaded()) {
                ref.returnValue = SlotWidget.REICallWrapper.getReiIngredients(arg_0 -> ((SlotWidget)this).getRealStack(arg_0), (List)list);
            } else if (LDLib.isEmiLoaded()) {
                ref.returnValue = SlotWidget.EMICallWrapper.getEmiIngredients((List)list, (float)this.getXEIChance());
            }
        }).ifRight(items -> {
            Stream<ItemStack> stream = items.stream().map(arg_0 -> ((SlotWidget)this).getRealStack(arg_0));
            if (LDLib.isJeiLoaded()) {
                ref.returnValue = stream.filter(stack -> !stack.m_41619_()).map(item -> JEIPlugin.getItemIngredient((ItemStack)item, (int)this.getPosition().x, (int)this.getPosition().y, (int)this.getSize().width, (int)this.getSize().height)).toList();
            } else if (LDLib.isReiLoaded()) {
                ref.returnValue = SlotWidget.REICallWrapper.getReiIngredients(stream);
            } else if (LDLib.isEmiLoaded()) {
                ref.returnValue = SlotWidget.EMICallWrapper.getEmiIngredients(stream, (float)this.getXEIChance());
            }
        });
        return ref.returnValue;
    }

    public class WidgetSlotItemHandler
    extends Slot {
        private static final Container emptyInventory = new SimpleContainer(0);
        private final IItemHandlerModifiable itemHandler;
        private final int index;

        public WidgetSlotItemHandler(IItemHandlerModifiable itemHandler, int index, int xPosition, int yPosition) {
            super(emptyInventory, index, xPosition, yPosition);
            this.itemHandler = itemHandler;
            this.index = index;
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return SlotWidget.this.canPutStack(stack) && !stack.m_41619_() && this.itemHandler.isItemValid(this.index, stack);
        }

        public boolean m_8010_(@Nullable Player playerIn) {
            return SlotWidget.this.canTakeStack(playerIn) && !this.itemHandler.extractItem(this.index, 1, true).m_41619_();
        }

        @Nonnull
        public ItemStack m_7993_() {
            return this.itemHandler.getStackInSlot(this.index);
        }

        public void m_269060_(ItemStack stack) {
            this.itemHandler.setStackInSlot(this.index, stack);
        }

        public void m_5852_(@Nonnull ItemStack stack) {
            this.itemHandler.setStackInSlot(this.index, stack);
            this.m_6654_();
        }

        public void m_40234_(@Nonnull ItemStack oldStackIn, @Nonnull ItemStack newStackIn) {
        }

        public int m_6641_() {
            return this.itemHandler.getSlotLimit(this.index);
        }

        public int m_5866_(@Nonnull ItemStack stack) {
            ItemStack maxAdd = stack.m_41777_();
            int maxInput = stack.m_41741_();
            maxAdd.m_41764_(maxInput);
            ItemStack currentStack = this.itemHandler.getStackInSlot(this.index);
            this.itemHandler.setStackInSlot(this.index, ItemStack.f_41583_);
            ItemStack remainder = this.itemHandler.insertItem(this.index, maxAdd, true);
            this.itemHandler.setStackInSlot(this.index, currentStack);
            return maxInput - remainder.m_41613_();
        }

        @NotNull
        public ItemStack m_6201_(int amount) {
            ItemStack result = this.itemHandler.extractItem(this.index, amount, false);
            if (SlotWidget.this.changeListener != null && !this.m_7993_().m_41619_()) {
                SlotWidget.this.changeListener.run();
            }
            return result;
        }

        public void m_6654_() {
            if (SlotWidget.this.changeListener != null) {
                SlotWidget.this.changeListener.run();
            }
            SlotWidget.this.onSlotChanged();
        }

        public boolean m_6659_() {
            return SlotWidget.this.isEnabled() && (HOVER_SLOT == null || HOVER_SLOT == this);
        }

        public IItemHandlerModifiable getItemHandler() {
            return this.itemHandler;
        }
    }
}

