/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item;

import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidPipeProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.misc.forge.ThermalFluidHandlerItemStack;
import com.gregtechceu.gtceu.common.data.GTMachines;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class DrumMachineItem
extends MetaMachineItem {
    private Material mat;

    protected DrumMachineItem(IMachineBlock block, Item.Properties properties, Material mat) {
        super(block, properties);
        this.mat = mat;
    }

    public static DrumMachineItem create(IMachineBlock block, Item.Properties properties, Material mat) {
        return new DrumMachineItem(block, properties, mat);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(ItemStack itemStack, @NotNull Capability<T> cap) {
        FluidPipeProperties property = this.mat.hasProperty(PropertyKey.FLUID_PIPE) ? this.mat.getProperty(PropertyKey.FLUID_PIPE) : null;
        if (cap == ForgeCapabilities.FLUID_HANDLER_ITEM && property != null) {
            return ForgeCapabilities.FLUID_HANDLER_ITEM.orEmpty(cap, LazyOptional.of(() -> new ThermalFluidHandlerItemStack(itemStack, Math.toIntExact(GTMachines.DRUM_CAPACITY.get((Object)this.getDefinition()).intValue()), property.getMaxFluidTemperature(), property.isGasProof(), property.isAcidProof(), property.isCryoProof(), property.isPlasmaProof())));
        }
        return LazyOptional.empty();
    }
}

