/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.capability;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class ElectricItem
implements IElectricItem {
    protected final ItemStack itemStack;
    protected final long maxCharge;
    protected final int tier;
    protected final boolean chargeable;
    protected final boolean canProvideEnergyExternally;

    public ElectricItem(ItemStack itemStack, long maxCharge, int tier, boolean chargeable, boolean canProvideEnergyExternally) {
        this.itemStack = itemStack;
        this.maxCharge = maxCharge;
        this.tier = tier;
        this.chargeable = chargeable;
        this.canProvideEnergyExternally = canProvideEnergyExternally;
    }

    public void setCharge(long change) {
        this.itemStack.m_41784_().m_128356_("Charge", change);
    }

    public void setMaxChargeOverride(long maxCharge) {
        this.itemStack.m_41784_().m_128356_("MaxCharge", maxCharge);
    }

    @Override
    public long getTransferLimit() {
        return GTValues.V[this.getTier()];
    }

    @Override
    public long getMaxCharge() {
        CompoundTag tagCompound = this.itemStack.m_41783_();
        if (tagCompound == null) {
            return this.maxCharge;
        }
        if (tagCompound.m_128425_("MaxCharge", 4)) {
            return tagCompound.m_128454_("MaxCharge");
        }
        return this.maxCharge;
    }

    @Override
    public long getCharge() {
        CompoundTag tagCompound = this.itemStack.m_41783_();
        if (tagCompound == null) {
            return 0L;
        }
        if (tagCompound.m_128471_("Infinite")) {
            return this.getMaxCharge();
        }
        return Math.min(tagCompound.m_128454_("Charge"), this.getMaxCharge());
    }

    public void setInfiniteCharge(boolean infiniteCharge) {
        this.itemStack.m_41784_().m_128379_("Infinite", infiniteCharge);
    }

    @Override
    public boolean canProvideChargeExternally() {
        return this.canProvideEnergyExternally;
    }

    @Override
    public boolean chargeable() {
        return this.chargeable;
    }

    @Override
    public long charge(long amount, int chargerTier, boolean ignoreTransferLimit, boolean simulate) {
        if (this.itemStack.m_41613_() != 1) {
            return 0L;
        }
        if ((this.chargeable || amount == Long.MAX_VALUE) && chargerTier >= this.tier && amount > 0L) {
            long canReceive = this.getMaxCharge() - this.getCharge();
            if (!ignoreTransferLimit) {
                amount = Math.min(amount, this.getTransferLimit());
            }
            long charged = Math.min(amount, canReceive);
            if (!simulate) {
                this.setCharge(this.getCharge() + charged);
            }
            return charged;
        }
        return 0L;
    }

    @Override
    public long discharge(long amount, int chargerTier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        if (this.itemStack.m_41613_() != 1) {
            return 0L;
        }
        if ((this.canProvideEnergyExternally || !externally || amount == Long.MAX_VALUE) && chargerTier >= this.tier && amount > 0L) {
            if (!ignoreTransferLimit) {
                amount = Math.min(amount, this.getTransferLimit());
            }
            long charge = this.getCharge();
            long discharged = Math.min(amount, charge);
            if (!simulate) {
                this.setCharge(charge - discharged);
            }
            return discharged;
        }
        return 0L;
    }

    @Override
    public int getTier() {
        return this.tier;
    }
}

