/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.tool.aoe;

import com.google.common.base.Preconditions;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class AoESymmetrical {
    public final int column;
    public final int row;
    public final int layer;
    private static final AoESymmetrical NONE = new AoESymmetrical();

    private AoESymmetrical() {
        this.column = 0;
        this.row = 0;
        this.layer = 0;
    }

    private AoESymmetrical(int column, int row, int layer) {
        this.column = column;
        this.row = row;
        this.layer = layer;
    }

    public static AoESymmetrical none() {
        return NONE;
    }

    public static AoESymmetrical of(int column, int row, int layer) {
        Preconditions.checkArgument((column >= 0 ? 1 : 0) != 0, (Object)"Height cannot be negative.");
        Preconditions.checkArgument((row >= 0 ? 1 : 0) != 0, (Object)"Width cannot be negative.");
        Preconditions.checkArgument((layer >= 0 ? 1 : 0) != 0, (Object)"Depth cannot be negative.");
        return column == 0 && row == 0 && layer == 0 ? NONE : new AoESymmetrical(column, row, layer);
    }

    public static AoESymmetrical readMax(CompoundTag tag) {
        int column = 0;
        int row = 0;
        int layer = 0;
        if (tag.m_128425_("MaxAoEColumn", 3)) {
            column = tag.m_128451_("MaxAoEColumn");
        }
        if (tag.m_128425_("MaxAoERow", 3)) {
            row = tag.m_128451_("MaxAoERow");
        }
        if (tag.m_128425_("MaxAoELayer", 3)) {
            layer = tag.m_128451_("MaxAoELayer");
        }
        return column == 0 && row == 0 && layer == 0 ? NONE : AoESymmetrical.of(column, row, layer);
    }

    public static AoESymmetrical read(CompoundTag tag, @Nullable AoESymmetrical defaultDefinition) {
        int layer;
        int row;
        int column;
        if (tag.m_128425_("AoEColumn", 3)) {
            column = tag.m_128451_("AoEColumn");
        } else {
            int n = column = defaultDefinition == null ? 0 : defaultDefinition.column;
        }
        if (tag.m_128425_("AoERow", 3)) {
            row = tag.m_128451_("AoERow");
        } else {
            int n = row = defaultDefinition == null ? 0 : defaultDefinition.row;
        }
        if (tag.m_128425_("AoELayer", 3)) {
            layer = tag.m_128451_("AoELayer");
        } else {
            int n = layer = defaultDefinition == null ? 0 : defaultDefinition.layer;
        }
        if (column == 0 && row == 0 && layer == 0) {
            return NONE;
        }
        tag.m_128405_("AoEColumn", column);
        tag.m_128405_("AoERow", row);
        tag.m_128405_("AoELayer", layer);
        return AoESymmetrical.of(column, row, layer);
    }

    public static int getColumn(CompoundTag tag, AoESymmetrical defaultDefinition) {
        if (tag.m_128425_("AoEColumn", 3)) {
            return tag.m_128451_("AoEColumn");
        }
        return defaultDefinition.column;
    }

    public static int getRow(CompoundTag tag, AoESymmetrical defaultDefinition) {
        if (tag.m_128425_("AoERow", 3)) {
            return tag.m_128451_("AoERow");
        }
        return defaultDefinition.row;
    }

    public static int getLayer(CompoundTag tag, AoESymmetrical defaultDefinition) {
        if (tag.m_128425_("AoELayer", 3)) {
            return tag.m_128451_("AoELayer");
        }
        return defaultDefinition.layer;
    }

    public static void increaseColumn(CompoundTag tag, AoESymmetrical defaultDefinition) {
        if (!tag.m_128425_("AoEColumn", 3)) {
            tag.m_128405_("AoEColumn", defaultDefinition.column);
        } else {
            int currentColumn = tag.m_128451_("AoEColumn");
            if (currentColumn < defaultDefinition.column) {
                tag.m_128405_("AoEColumn", currentColumn + 1);
            }
        }
    }

    public static void increaseRow(CompoundTag tag, AoESymmetrical defaultDefinition) {
        if (!tag.m_128425_("AoERow", 3)) {
            tag.m_128405_("AoERow", defaultDefinition.row);
        } else {
            int currentRow = tag.m_128451_("AoERow");
            if (currentRow < defaultDefinition.row) {
                tag.m_128405_("AoERow", currentRow + 1);
            }
        }
    }

    public static void increaseLayer(CompoundTag tag, AoESymmetrical defaultDefinition) {
        if (!tag.m_128425_("AoELayer", 3)) {
            tag.m_128405_("AoELayer", defaultDefinition.layer);
        } else {
            int currentLayer = tag.m_128451_("AoELayer");
            if (currentLayer < defaultDefinition.layer) {
                tag.m_128405_("AoELayer", currentLayer + 1);
            }
        }
    }

    public static void decreaseColumn(CompoundTag tag, AoESymmetrical defaultDefinition) {
        if (!tag.m_128425_("AoEColumn", 3)) {
            tag.m_128405_("AoEColumn", defaultDefinition.column);
        } else {
            int currentColumn = tag.m_128451_("AoEColumn");
            if (currentColumn > 0) {
                tag.m_128405_("AoEColumn", currentColumn - 1);
            }
        }
    }

    public static void decreaseRow(CompoundTag tag, AoESymmetrical defaultDefinition) {
        if (!tag.m_128425_("AoERow", 3)) {
            tag.m_128405_("AoERow", defaultDefinition.row);
        } else {
            int currentRow = tag.m_128451_("AoERow");
            if (currentRow > 0) {
                tag.m_128405_("AoERow", currentRow - 1);
            }
        }
    }

    public static void decreaseLayer(CompoundTag tag, AoESymmetrical defaultDefinition) {
        if (!tag.m_128425_("AoELayer", 3)) {
            tag.m_128405_("AoELayer", defaultDefinition.layer);
        } else {
            int currentLayer = tag.m_128451_("AoELayer");
            if (currentLayer > 0) {
                tag.m_128405_("AoELayer", currentLayer - 1);
            }
        }
    }
}

