/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine;

import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.item.tool.IToolGridHighLight;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.common.machine.owner.IMachineOwner;
import com.lowdragmc.lowdraglib.syncdata.blockentity.IAsyncAutoSyncBlockEntity;
import com.lowdragmc.lowdraglib.syncdata.blockentity.IAutoPersistBlockEntity;
import com.lowdragmc.lowdraglib.syncdata.blockentity.IRPCBlockEntity;
import com.lowdragmc.lowdraglib.syncdata.managed.MultiManagedStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public interface IMachineBlockEntity
extends IToolGridHighLight,
IAsyncAutoSyncBlockEntity,
IRPCBlockEntity,
IAutoPersistBlockEntity {
    default public BlockEntity self() {
        return (BlockEntity)this;
    }

    default public Level level() {
        return this.self().m_58904_();
    }

    default public BlockPos pos() {
        return this.self().m_58899_();
    }

    default public void notifyBlockUpdate() {
        if (this.level() != null) {
            this.level().m_46672_(this.pos(), this.level().m_8055_(this.pos()).m_60734_());
        }
    }

    default public void scheduleRenderUpdate() {
        BlockPos pos = this.pos();
        if (this.level() != null) {
            BlockState state = this.level().m_8055_(pos);
            if (this.level().f_46443_) {
                this.level().m_7260_(pos, state, state, 8);
            } else {
                this.level().m_7696_(pos, state.m_60734_(), 1, 0);
            }
        }
    }

    default public long getOffsetTimer() {
        return this.level() == null ? this.getOffset() : this.level().m_46467_() + this.getOffset();
    }

    default public MachineDefinition getDefinition() {
        Block block = this.self().m_58900_().m_60734_();
        if (block instanceof IMachineBlock) {
            IMachineBlock machineBlock = (IMachineBlock)block;
            return machineBlock.getDefinition();
        }
        throw new IllegalStateException("MetaMachineBlockEntity is created for an un available block: " + this.self().m_58900_().m_60734_());
    }

    public MetaMachine getMetaMachine();

    public long getOffset();

    public MultiManagedStorage getRootStorage();

    default public void saveCustomPersistedData(CompoundTag tag, boolean forDrop) {
        super.saveCustomPersistedData(tag, forDrop);
        this.getMetaMachine().saveCustomPersistedData(tag, forDrop);
    }

    default public void loadCustomPersistedData(CompoundTag tag) {
        super.loadCustomPersistedData(tag);
        this.getMetaMachine().loadCustomPersistedData(tag);
    }

    default public void setOwner(IMachineOwner owner) {
    }

    default public IMachineOwner getOwner() {
        return null;
    }
}

