/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.steam;

import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.gui.widget.PredicatedImageWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IExhaustVentMachine;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.gregtechceu.gtceu.api.machine.steam.SteamEnergyRecipeHandler;
import com.gregtechceu.gtceu.api.machine.steam.SteamWorkableMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.logic.OCParams;
import com.gregtechceu.gtceu.api.recipe.logic.OCResult;
import com.gregtechceu.gtceu.common.recipe.condition.VentCondition;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.Position;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SimpleSteamMachine
extends SteamWorkableMachine
implements IExhaustVentMachine,
IUIMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(SimpleSteamMachine.class, SteamWorkableMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    public final NotifiableItemStackHandler importItems;
    @Persisted
    public final NotifiableItemStackHandler exportItems;
    @Persisted
    private boolean needsVenting;

    public SimpleSteamMachine(IMachineBlockEntity holder, boolean isHighPressure, Object ... args) {
        super(holder, isHighPressure, args);
        this.importItems = this.createImportItemHandler(args);
        this.exportItems = this.createExportItemHandler(args);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    protected NotifiableFluidTank createSteamTank(Object ... args) {
        return new NotifiableFluidTank((MetaMachine)this, 1, 16000, IO.IN);
    }

    protected NotifiableItemStackHandler createImportItemHandler(Object ... args) {
        return new NotifiableItemStackHandler(this, this.getRecipeType().getMaxInputs(ItemRecipeCapability.CAP), IO.IN);
    }

    protected NotifiableItemStackHandler createExportItemHandler(Object ... args) {
        return new NotifiableItemStackHandler(this, this.getRecipeType().getMaxOutputs(ItemRecipeCapability.CAP), IO.OUT);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.capabilitiesProxy.put((Object)IO.IN, (Object)EURecipeCapability.CAP, List.of(new SteamEnergyRecipeHandler(this.steamTank, 1.0)));
    }

    @Override
    public void onMachineRemoved() {
        this.clearInventory((IItemHandlerModifiable)this.importItems.storage);
        this.clearInventory((IItemHandlerModifiable)this.exportItems.storage);
    }

    @Override
    public float getVentingDamage() {
        return this.isHighPressure() ? 12.0f : 6.0f;
    }

    @Override
    @NotNull
    public Direction getVentingDirection() {
        return this.getOutputFacing();
    }

    @Override
    public boolean isNeedsVenting() {
        return this.needsVenting;
    }

    @Override
    public void markVentingComplete() {
        this.needsVenting = false;
    }

    @Nullable
    public static GTRecipe recipeModifier(MetaMachine machine, @NotNull GTRecipe recipe, @NotNull OCParams params, @NotNull OCResult result) {
        if (machine instanceof SimpleSteamMachine) {
            SimpleSteamMachine steamMachine = (SimpleSteamMachine)machine;
            if (RecipeHelper.getRecipeEUtTier(recipe) > 1 || !steamMachine.checkVenting()) {
                return null;
            }
            GTRecipe modified = recipe.copy();
            modified.conditions.add(VentCondition.INSTANCE);
            if (steamMachine.isHighPressure) {
                result.init(RecipeHelper.getInputEUt(recipe) * 2L, modified.duration, params.getOcAmount());
            } else {
                result.init(RecipeHelper.getInputEUt(recipe), modified.duration * 2, params.getOcAmount());
            }
            return modified;
        }
        return null;
    }

    @Override
    public void afterWorking() {
        super.afterWorking();
        this.needsVenting = true;
        this.checkVenting();
    }

    public ModularUI createUI(Player entityPlayer) {
        Table storages = Tables.newCustomTable(new EnumMap(IO.class), LinkedHashMap::new);
        storages.put((Object)IO.IN, (Object)ItemRecipeCapability.CAP, (Object)this.importItems.storage);
        storages.put((Object)IO.OUT, (Object)ItemRecipeCapability.CAP, (Object)this.exportItems.storage);
        WidgetGroup group = this.getRecipeType().getRecipeUI().createUITemplate(this.recipeLogic::getProgressPercent, storages, new CompoundTag(), Collections.emptyList(), true, this.isHighPressure);
        Position pos = new Position((Math.max(group.getSize().width + 4 + 8, 176) - 4 - group.getSize().width) / 2 + 4, 32);
        group.setSelfPosition(pos);
        return new ModularUI(176, 166, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND_STEAM.get(this.isHighPressure)}).widget((Widget)group).widget((Widget)new LabelWidget(5, 5, this.getBlockState().m_60734_().m_7705_())).widget((Widget)new PredicatedImageWidget(pos.x + group.getSize().width / 2 - 9, pos.y + group.getSize().height / 2 - 9, 18, 18, (IGuiTexture)GuiTextures.INDICATOR_NO_STEAM.get(this.isHighPressure)).setPredicate(this.recipeLogic::isWaiting)).widget((Widget)UITemplate.bindPlayerInventory(entityPlayer.m_150109_(), (IGuiTexture)GuiTextures.SLOT_STEAM.get(this.isHighPressure), 7, 84, true));
    }

    @Override
    public void setNeedsVenting(boolean needsVenting) {
        this.needsVenting = needsVenting;
    }
}

