/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.misc;

import com.gregtechceu.gtceu.api.capability.ILaserContainer;
import java.util.List;
import net.minecraft.core.Direction;

public class LaserContainerList
implements ILaserContainer {
    private final List<? extends ILaserContainer> energyContainerList;

    public LaserContainerList(List<? extends ILaserContainer> energyContainerList) {
        this.energyContainerList = energyContainerList;
    }

    @Override
    public long acceptEnergyFromNetwork(Direction side, long voltage, long amperage) {
        long amperesUsed = 0L;
        List<? extends ILaserContainer> energyContainerList = this.energyContainerList;
        for (ILaserContainer iLaserContainer : energyContainerList) {
            if (amperage != (amperesUsed += iLaserContainer.acceptEnergyFromNetwork(null, voltage, amperage))) continue;
            return amperesUsed;
        }
        return amperesUsed;
    }

    @Override
    public long changeEnergy(long energyToAdd) {
        long energyAdded = 0L;
        List<? extends ILaserContainer> energyContainerList = this.energyContainerList;
        for (ILaserContainer iLaserContainer : energyContainerList) {
            if ((energyAdded += iLaserContainer.changeEnergy(energyToAdd - energyAdded)) != energyToAdd) continue;
            return energyAdded;
        }
        return energyAdded;
    }

    @Override
    public long getEnergyStored() {
        long energyStored = 0L;
        for (ILaserContainer iLaserContainer : this.energyContainerList) {
            energyStored += iLaserContainer.getEnergyStored();
        }
        return energyStored;
    }

    @Override
    public long getEnergyCapacity() {
        long energyCapacity = 0L;
        for (ILaserContainer iLaserContainer : this.energyContainerList) {
            energyCapacity += iLaserContainer.getEnergyCapacity();
        }
        return energyCapacity;
    }

    @Override
    public long getInputAmperage() {
        return 1L;
    }

    @Override
    public long getOutputAmperage() {
        return 1L;
    }

    @Override
    public long getInputVoltage() {
        long inputVoltage = 0L;
        for (ILaserContainer iLaserContainer : this.energyContainerList) {
            inputVoltage += iLaserContainer.getInputVoltage() * iLaserContainer.getInputAmperage();
        }
        return inputVoltage;
    }

    @Override
    public long getOutputVoltage() {
        long outputVoltage = 0L;
        for (ILaserContainer iLaserContainer : this.energyContainerList) {
            outputVoltage += iLaserContainer.getOutputVoltage() * iLaserContainer.getOutputAmperage();
        }
        return outputVoltage;
    }

    @Override
    public boolean inputsEnergy(Direction side) {
        return true;
    }

    @Override
    public boolean outputsEnergy(Direction side) {
        return true;
    }
}

