/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pattern;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.pattern.MultiblockState;
import com.lowdragmc.lowdraglib.Platform;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class MultiblockWorldSavedData
extends SavedData {
    private final ServerLevel serverLevel;
    public final Map<BlockPos, MultiblockState> mapping;
    public final Map<ChunkPos, Set<MultiblockState>> chunkPosMapping;
    private final CopyOnWriteArrayList<IMultiController> controllers = new CopyOnWriteArrayList();
    private ScheduledExecutorService executorService;
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("GTCEu Multiblock Async Thread-%d").setDaemon(true).build();
    private static final ThreadLocal<Boolean> IN_SERVICE = ThreadLocal.withInitial(() -> false);
    private long periodID = Long.MIN_VALUE;

    public static MultiblockWorldSavedData getOrCreate(ServerLevel serverLevel) {
        return (MultiblockWorldSavedData)serverLevel.m_8895_().m_164861_(tag -> new MultiblockWorldSavedData(serverLevel, (CompoundTag)tag), () -> new MultiblockWorldSavedData(serverLevel), "gtceu_multiblock");
    }

    private MultiblockWorldSavedData(ServerLevel serverLevel) {
        this.serverLevel = serverLevel;
        this.mapping = new Object2ObjectOpenHashMap();
        this.chunkPosMapping = new HashMap<ChunkPos, Set<MultiblockState>>();
    }

    private MultiblockWorldSavedData(ServerLevel serverLevel, CompoundTag tag) {
        this(serverLevel);
    }

    public MultiblockState[] getControllerInChunk(ChunkPos chunkPos) {
        return (MultiblockState[])this.chunkPosMapping.getOrDefault(chunkPos, Collections.emptySet()).toArray(MultiblockState[]::new);
    }

    public void addMapping(MultiblockState state) {
        this.mapping.put(state.controllerPos, state);
        for (BlockPos blockPos : state.getCache()) {
            this.chunkPosMapping.computeIfAbsent(new ChunkPos(blockPos), c -> new HashSet()).add(state);
        }
        this.m_77760_(true);
    }

    public void removeMapping(MultiblockState state) {
        this.mapping.remove(state.controllerPos);
        for (Set<MultiblockState> set : this.chunkPosMapping.values()) {
            set.remove(state);
        }
        this.m_77760_(true);
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag compound) {
        return compound;
    }

    public void createExecutorService() {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            return;
        }
        this.executorService = Executors.newSingleThreadScheduledExecutor(THREAD_FACTORY);
        this.executorService.scheduleAtFixedRate(this::searchingTask, 0L, 250L, TimeUnit.MILLISECONDS);
    }

    public void addAsyncLogic(IMultiController controller) {
        this.controllers.add(controller);
        this.createExecutorService();
    }

    public void removeAsyncLogic(IMultiController controller) {
        if (this.controllers.contains(controller)) {
            this.controllers.remove(controller);
            if (this.controllers.isEmpty()) {
                this.releaseExecutorService();
            }
        }
    }

    private void searchingTask() {
        try {
            if (Platform.isServerNotSafe()) {
                return;
            }
            IN_SERVICE.set(true);
            for (IMultiController controller : this.controllers) {
                controller.asyncCheckPattern(this.periodID);
            }
        }
        catch (Throwable e) {
            GTCEu.LOGGER.error("asyncThreadLogic error: {}", (Object)e.getMessage());
        }
        finally {
            IN_SERVICE.set(false);
        }
        ++this.periodID;
    }

    public static boolean isThreadService() {
        return IN_SERVICE.get() != false && !Platform.isServerNotSafe();
    }

    public void releaseExecutorService() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        this.executorService = null;
    }

    public long getPeriodID() {
        return this.periodID;
    }
}

