/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pipenet.longdistance;

import com.gregtechceu.gtceu.api.pipenet.longdistance.ILDEndpoint;
import com.gregtechceu.gtceu.api.pipenet.longdistance.LongDistancePipeType;
import com.gregtechceu.gtceu.api.pipenet.longdistance.NetworkBuilder;
import com.gregtechceu.gtceu.utils.GTUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LongDistanceNetwork {
    private final ObjectOpenHashSet<BlockPos> longDistancePipeBlocks = new ObjectOpenHashSet();
    private final LongDistancePipeType pipeType;
    private final WorldData world;
    private final List<ILDEndpoint> endpoints = new ArrayList<ILDEndpoint>();
    private final List<BlockPos> endpointPoss = new ArrayList<BlockPos>();
    private int activeInputIndex = -1;
    private int activeOutputIndex = -1;

    protected LongDistanceNetwork(LongDistancePipeType pipeType, WorldData world) {
        this.pipeType = pipeType;
        this.world = world;
    }

    @Nullable
    public static LongDistanceNetwork get(LevelAccessor world, BlockPos pos) {
        return WorldData.get(world).getNetwork(pos);
    }

    protected void recalculateNetwork(Collection<BlockPos> starts) {
        this.invalidateNetwork(true);
        new NetworkBuilder(this.world, this, starts).start();
    }

    protected void setData(Collection<BlockPos> pipes, List<ILDEndpoint> endpoints) {
        this.invalidateEndpoints();
        this.longDistancePipeBlocks.clear();
        this.longDistancePipeBlocks.addAll(pipes);
        this.endpoints.clear();
        this.endpoints.addAll(endpoints);
        if (this.longDistancePipeBlocks.isEmpty()) {
            this.invalidateNetwork(false);
            return;
        }
        for (BlockPos pos : this.longDistancePipeBlocks) {
            this.world.putNetwork(pos, this);
        }
    }

    public void onRemovePipe(BlockPos pos) {
        this.longDistancePipeBlocks.remove((Object)pos);
        this.world.removeNetwork(pos);
        if (this.longDistancePipeBlocks.isEmpty()) {
            this.invalidateNetwork(false);
            return;
        }
        ArrayList<BlockPos> neighbours = new ArrayList<BlockPos>();
        BlockPos.MutableBlockPos offsetPos = new BlockPos.MutableBlockPos();
        for (Direction facing : GTUtil.DIRECTIONS) {
            offsetPos.m_122190_((Vec3i)pos).m_122173_(facing);
            LongDistanceNetwork network = this.world.getNetwork((BlockPos)offsetPos);
            if (network != this) continue;
            neighbours.add(offsetPos.m_7949_());
        }
        if (neighbours.size() > 1) {
            this.recalculateNetwork(neighbours);
        }
    }

    protected void addEndpoint(ILDEndpoint endpoint) {
        if (!this.endpoints.contains(endpoint)) {
            this.endpoints.add(endpoint);
        }
    }

    protected void addEndpoint(Collection<ILDEndpoint> endpoints) {
        for (ILDEndpoint endpoint : endpoints) {
            if (this.endpoints.contains(endpoint)) continue;
            this.endpoints.add(endpoint);
        }
    }

    public void onRemoveEndpoint(ILDEndpoint endpoint) {
        endpoint.invalidateLink();
        if (this.endpoints.remove(endpoint)) {
            this.invalidateEndpoints();
        }
        this.onRemovePipe(endpoint.getPos());
    }

    public void onPlacePipe(BlockPos pos) {
        this.longDistancePipeBlocks.add((Object)pos);
        this.world.putNetwork(pos, this);
    }

    public void onPlaceEndpoint(ILDEndpoint endpoint) {
        this.addEndpoint(endpoint);
        this.longDistancePipeBlocks.add((Object)endpoint.getPos());
        this.world.putNetwork(endpoint.getPos(), this);
    }

    protected void mergePipeNet(LongDistanceNetwork network) {
        if (this.getPipeType() != network.getPipeType()) {
            throw new IllegalStateException("Can't merge unequal pipe types, " + this.getPipeType().getName() + " and " + network.getPipeType().getName() + " !");
        }
        for (BlockPos pos : network.longDistancePipeBlocks) {
            this.world.putNetwork(pos, this);
            this.longDistancePipeBlocks.add((Object)pos);
        }
        this.addEndpoint(network.endpoints);
        for (ILDEndpoint endpoint1 : this.endpoints) {
            endpoint1.invalidateLink();
        }
        network.invalidateNetwork(false);
    }

    protected void invalidateNetwork(boolean removeFromWorld) {
        if (removeFromWorld) {
            for (BlockPos pos : this.longDistancePipeBlocks) {
                this.world.removeNetwork(pos);
            }
        }
        this.longDistancePipeBlocks.clear();
        this.world.networkList.remove((Object)this);
        this.invalidateEndpoints();
        this.endpoints.clear();
    }

    public void invalidateEndpoints() {
        this.activeInputIndex = -1;
        this.activeOutputIndex = -1;
        for (ILDEndpoint endpoint : this.endpoints) {
            endpoint.invalidateLink();
        }
    }

    @Nullable
    public ILDEndpoint getOtherEndpoint(ILDEndpoint endpoint) {
        if (!this.isValid() || !endpoint.isInput() && !endpoint.isOutput()) {
            return null;
        }
        int thisIndex = this.endpoints.indexOf(endpoint);
        if (thisIndex < 0) {
            this.recalculateNetwork(Collections.singleton(endpoint.getPos()));
            return null;
        }
        if (this.isIOIndexInvalid()) {
            this.invalidateEndpoints();
        } else if (this.activeInputIndex >= 0) {
            ILDEndpoint out;
            ILDEndpoint in = this.endpoints.get(this.activeInputIndex);
            if (!this.pipeType.satisfiesMinLength(in, out = this.endpoints.get(this.activeOutputIndex))) {
                this.invalidateEndpoints();
                return this.getOtherEndpoint(endpoint);
            }
            if (in == endpoint) {
                if (!endpoint.isInput()) {
                    throw new IllegalStateException("Other endpoint from input was itself");
                }
                return out;
            }
            if (out == endpoint) {
                if (!endpoint.isOutput()) {
                    throw new IllegalStateException("Other endpoint from output was itself");
                }
                return in;
            }
            return null;
        }
        int otherIndex = this.find(endpoint);
        if (otherIndex >= 0) {
            ILDEndpoint other = this.endpoints.get(otherIndex);
            this.activeOutputIndex = endpoint.isOutput() ? thisIndex : otherIndex;
            this.activeInputIndex = endpoint.isInput() ? thisIndex : otherIndex;
            return other;
        }
        return null;
    }

    private int find(ILDEndpoint endpoint) {
        for (int i = 0; i < this.endpoints.size(); ++i) {
            ILDEndpoint other = this.endpoints.get(i);
            if (other.isInValid()) {
                other.invalidateLink();
                this.endpoints.remove(i--);
                continue;
            }
            if (endpoint == other || !other.isOutput() && !other.isInput() || other.isInput() == endpoint.isInput() || !this.pipeType.satisfiesMinLength(endpoint, other)) continue;
            return i;
        }
        return -1;
    }

    public boolean isIOIndexInvalid() {
        return this.activeInputIndex >= 0 && this.activeInputIndex >= this.endpoints.size() || this.activeOutputIndex >= 0 && this.activeOutputIndex >= this.endpoints.size() || this.activeInputIndex < 0 != this.activeOutputIndex < 0;
    }

    public ILDEndpoint getActiveInputIndex() {
        return this.activeInputIndex >= 0 ? this.endpoints.get(this.activeInputIndex) : null;
    }

    public ILDEndpoint getActiveOutputIndex() {
        return this.activeOutputIndex >= 0 ? this.endpoints.get(this.activeOutputIndex) : null;
    }

    public int getTotalSize() {
        return this.longDistancePipeBlocks.size();
    }

    public int getEndpointAmount() {
        return this.endpoints.size();
    }

    public int getPipeAmount() {
        return this.getTotalSize() - this.getEndpointAmount();
    }

    public boolean isValid() {
        return this.getEndpointAmount() > 1;
    }

    public LongDistancePipeType getPipeType() {
        return this.pipeType;
    }

    public static class WorldData
    extends SavedData {
        private final Long2ObjectMap<Object2ObjectMap<BlockPos, LongDistanceNetwork>> networks = new Long2ObjectOpenHashMap();
        private final ObjectOpenHashSet<LongDistanceNetwork> networkList = new ObjectOpenHashSet();
        private WeakReference<LevelAccessor> worldRef = new WeakReference<Object>(null);

        public static WorldData create(ServerLevel level) {
            WorldData data = new WorldData();
            data.setWorldAndInit((LevelAccessor)level);
            return data;
        }

        public static WorldData get(LevelAccessor level) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                return (WorldData)serverLevel.m_8895_().m_164861_(tag -> WorldData.load(tag, serverLevel), () -> WorldData.create(serverLevel), "gtceu_long_dist_pipe");
            }
            return null;
        }

        private static long getChunkPos(BlockPos pos) {
            return ChunkPos.m_45589_((int)(pos.m_123341_() >> 4), (int)(pos.m_123343_() >> 4));
        }

        protected void setWorldAndInit(LevelAccessor world) {
            if (this.worldRef.get() != world) {
                for (LongDistanceNetwork ld : this.networkList) {
                    if (ld.endpointPoss.isEmpty()) continue;
                    ld.endpoints.clear();
                    for (BlockPos pos : ld.endpointPoss) {
                        ILDEndpoint endpoint = ILDEndpoint.tryGet(world, pos);
                        if (endpoint == null) continue;
                        ld.addEndpoint(endpoint);
                    }
                }
            }
            this.worldRef = new WeakReference<LevelAccessor>(world);
            this.m_77762_();
        }

        public LongDistanceNetwork getNetwork(BlockPos pos) {
            return (LongDistanceNetwork)((Object2ObjectMap)this.networks.getOrDefault(WorldData.getChunkPos(pos), (Object)Object2ObjectMaps.emptyMap())).get((Object)pos);
        }

        private void putNetwork(BlockPos pos, LongDistanceNetwork network) {
            long chunkPos = WorldData.getChunkPos(pos);
            Object2ObjectMap chunkNetworks = (Object2ObjectMap)this.networks.get(chunkPos);
            if (chunkNetworks == null) {
                chunkNetworks = new Object2ObjectOpenHashMap();
                this.networks.put(chunkPos, (Object)chunkNetworks);
            }
            chunkNetworks.put((Object)pos, (Object)network);
            this.networkList.add((Object)network);
            this.m_77762_();
        }

        private void removeNetwork(BlockPos pos) {
            long chunkPos = WorldData.getChunkPos(pos);
            Object2ObjectMap chunkNetworks = (Object2ObjectMap)this.networks.get(chunkPos);
            if (chunkNetworks != null) {
                chunkNetworks.remove((Object)pos);
                if (chunkNetworks.isEmpty()) {
                    this.networks.remove(chunkPos);
                }
            }
            this.m_77762_();
        }

        public static WorldData load(@NotNull CompoundTag nbtTagCompound, ServerLevel level) {
            WorldData data = new WorldData();
            data.networks.clear();
            data.networkList.clear();
            ListTag list = nbtTagCompound.m_128437_("nets", 10);
            for (Tag nbt : list) {
                CompoundTag tag = (CompoundTag)nbt;
                LongDistancePipeType pipeType = LongDistancePipeType.getPipeType(tag.m_128461_("class"));
                LongDistanceNetwork ld = pipeType.createNetwork(data);
                ld.activeInputIndex = tag.m_128451_("in");
                ld.activeOutputIndex = tag.m_128451_("out");
                data.networkList.add((Object)ld);
                ListTag posList = tag.m_128437_("pipes", 4);
                for (Tag nbtPos : posList) {
                    BlockPos pos = BlockPos.m_122022_((long)((LongTag)nbtPos).m_7046_());
                    data.putNetwork(pos, ld);
                    ld.longDistancePipeBlocks.add((Object)pos);
                }
                ListTag endpoints = tag.m_128437_("endpoints", 4);
                for (Tag nbtPos : endpoints) {
                    BlockPos pos = BlockPos.m_122022_((long)((LongTag)nbtPos).m_7046_());
                    if (ld.endpointPoss.contains(pos)) continue;
                    ld.endpointPoss.add(pos);
                }
            }
            data.setWorldAndInit((LevelAccessor)level);
            return data;
        }

        @NotNull
        public CompoundTag m_7176_(@NotNull CompoundTag nbtTagCompound) {
            ListTag list = new ListTag();
            for (LongDistanceNetwork network : this.networkList) {
                CompoundTag tag = new CompoundTag();
                list.add((Object)tag);
                String name = network.getPipeType().getName();
                tag.m_128359_("class", name);
                tag.m_128405_("in", network.activeInputIndex);
                tag.m_128405_("out", network.activeOutputIndex);
                ListTag posList = new ListTag();
                tag.m_128365_("pipes", (Tag)posList);
                for (BlockPos pos : network.longDistancePipeBlocks) {
                    posList.add((Object)LongTag.m_128882_((long)pos.m_121878_()));
                }
                ListTag endpoints = new ListTag();
                tag.m_128365_("endpoints", (Tag)endpoints);
                for (ILDEndpoint endpoint : network.endpoints) {
                    endpoints.add((Object)LongTag.m_128882_((long)endpoint.getPos().m_121878_()));
                }
            }
            nbtTagCompound.m_128365_("nets", (Tag)list);
            return nbtTagCompound;
        }

        public LevelAccessor getWorld() {
            return (LevelAccessor)this.worldRef.get();
        }
    }
}

