/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.gregtechceu.gtceu.api.recipe.logic.OCParams;
import com.gregtechceu.gtceu.api.recipe.logic.OCResult;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTUtil;
import org.jetbrains.annotations.NotNull;

public class OverclockingLogic {
    public static final double STD_VOLTAGE_FACTOR = 4.0;
    public static final double PERFECT_HALF_VOLTAGE_FACTOR = 2.0;
    public static final double STD_DURATION_FACTOR = 1.0 / ConfigHolder.INSTANCE.machines.overclockDivisor;
    public static final double STD_DURATION_FACTOR_INV = ConfigHolder.INSTANCE.machines.overclockDivisor;
    public static final double PERFECT_DURATION_FACTOR = 0.25;
    public static final double PERFECT_DURATION_FACTOR_INV = 4.0;
    public static final double PERFECT_HALF_DURATION_FACTOR = 0.5;
    public static final double PERFECT_HALF_DURATION_FACTOR_INV = 2.0;
    public static final int COIL_EUT_DISCOUNT_TEMPERATURE = 900;
    public static final OverclockingLogic PERFECT_OVERCLOCK = new OverclockingLogic(0.25, 4.0, false);
    public static final OverclockingLogic NON_PERFECT_OVERCLOCK = new OverclockingLogic(STD_DURATION_FACTOR, 4.0, false);
    public static final OverclockingLogic PERFECT_OVERCLOCK_SUBTICK = new OverclockingLogic(0.25, 4.0, true);
    public static final OverclockingLogic NON_PERFECT_OVERCLOCK_SUBTICK = new OverclockingLogic(STD_DURATION_FACTOR, 4.0, true);
    protected Logic logic;

    public OverclockingLogic(Logic logic) {
        this.logic = logic;
    }

    public OverclockingLogic(double durationFactor, double voltageFactor, boolean subtick) {
        this.logic = subtick ? (ocParams, ocResult, maxVoltage) -> OverclockingLogic.subTickParallelOC(ocParams, ocResult, maxVoltage, durationFactor, voltageFactor) : (ocParams, ocResult, maxVoltage) -> OverclockingLogic.standardOverclockingLogic(ocParams, ocResult, maxVoltage, durationFactor, voltageFactor);
    }

    public static void standardOverclockingLogic(@NotNull OCParams params, @NotNull OCResult result, long maxVoltage, double durationFactor, double voltageFactor) {
        double potentialDuration;
        double potentialVoltage;
        double duration = params.getDuration();
        double eut = params.getEut();
        int ocAmount = params.getOcAmount();
        int ocLevel = 0;
        while (ocAmount-- > 0 && !((potentialVoltage = eut * voltageFactor) > (double)maxVoltage) && !((potentialDuration = duration * durationFactor) < 1.0)) {
            duration = potentialDuration;
            eut = potentialVoltage;
            ++ocLevel;
        }
        result.init((long)eut, (int)duration, ocLevel);
    }

    public static void subTickNonParallelOC(@NotNull OCParams params, @NotNull OCResult result, long maxVoltage, double durationFactor, double voltageFactor) {
        double potentialEUt;
        double duration = params.getDuration();
        double eut = params.getEut();
        int ocAmount = params.getOcAmount();
        int ocLevel = 0;
        while (ocAmount-- > 0 && !((potentialEUt = eut * voltageFactor) > (double)maxVoltage) && !(potentialEUt < 1.0)) {
            double potentialDuration = duration * durationFactor;
            if (potentialDuration < 1.0) {
                potentialEUt = eut * durationFactor;
                if (potentialEUt > (double)maxVoltage || potentialEUt < 1.0) {
                    break;
                }
            } else {
                duration = potentialDuration;
            }
            eut = potentialEUt;
            ++ocLevel;
        }
        result.init((long)eut, (int)duration, ocLevel);
    }

    public static void subTickParallelOC(@NotNull OCParams params, @NotNull OCResult result, long maxVoltage, double durationFactor, double voltageFactor) {
        double potentialVoltage;
        double duration = params.getDuration();
        double eut = params.getEut();
        int ocAmount = params.getOcAmount();
        double parallel = 1.0;
        int parallelIterAmount = 0;
        boolean shouldParallel = false;
        int ocLevel = 0;
        while (ocAmount-- > 0 && !((potentialVoltage = eut * voltageFactor) > (double)maxVoltage)) {
            eut = potentialVoltage;
            if (shouldParallel) {
                parallel /= durationFactor;
                ++parallelIterAmount;
            } else {
                double potentialDuration = duration * durationFactor;
                if (potentialDuration < 1.0) {
                    parallel /= durationFactor;
                    ++parallelIterAmount;
                    shouldParallel = true;
                } else {
                    duration = potentialDuration;
                }
            }
            ++ocLevel;
        }
        result.init((long)(eut / Math.pow(voltageFactor, parallelIterAmount)), (int)duration, (int)parallel, (long)eut, ocLevel);
    }

    public static void heatingCoilOC(@NotNull OCParams params, @NotNull OCResult result, long maxVoltage, int providedTemp, int requiredTemp) {
        int perfectOCAmount = OverclockingLogic.calculateAmountCoilEUtDiscount(providedTemp, requiredTemp) / 2;
        double duration = params.getDuration();
        double eut = params.getEut();
        int ocAmount = params.getOcAmount();
        double parallel = 1.0;
        int parallelIterAmount = 0;
        boolean shouldParallel = false;
        int ocLevel = 0;
        while (ocAmount-- > 0) {
            boolean perfect = perfectOCAmount-- > 0;
            double potentialEUt = eut * 4.0;
            if (potentialEUt > (double)maxVoltage) break;
            eut = potentialEUt;
            if (shouldParallel) {
                parallel = perfect ? (parallel *= 4.0) : (parallel *= STD_DURATION_FACTOR_INV);
                ++parallelIterAmount;
            } else {
                double potentialDuration = perfect ? duration * 0.25 : duration * STD_DURATION_FACTOR;
                if (potentialDuration < 1.0) {
                    parallel = perfect ? (parallel *= 4.0) : (parallel *= STD_DURATION_FACTOR_INV);
                    ++parallelIterAmount;
                    shouldParallel = true;
                } else {
                    duration = potentialDuration;
                }
            }
            ++ocLevel;
        }
        result.init((long)(eut / Math.pow(4.0, parallelIterAmount)), (int)duration, (int)parallel, (long)eut, ocLevel);
    }

    public static void heatingCoilNonSubTickOC(@NotNull OCParams params, @NotNull OCResult result, long maxVoltage, int providedTemp, int requiredTemp) {
        int amountPerfectOC = OverclockingLogic.calculateAmountCoilEUtDiscount(providedTemp, requiredTemp) / 2;
        double duration = params.getDuration();
        double eut = params.getEut();
        double ocAmount = params.getOcAmount();
        int ocLevel = 0;
        while (true) {
            double d = ocAmount;
            ocAmount = d - 1.0;
            if (!(d > 0.0)) break;
            boolean perfect = amountPerfectOC-- > 0;
            double potentialEUt = eut * 4.0;
            if (potentialEUt > (double)maxVoltage) break;
            eut = potentialEUt;
            double potentialDuration = perfect ? duration * 0.25 : duration * STD_DURATION_FACTOR;
            if (potentialDuration < 1.0) break;
            duration = potentialDuration;
            ++ocLevel;
        }
        result.init((long)eut, (int)duration, ocLevel);
    }

    private static int calculateAmountCoilEUtDiscount(int providedTemp, int requiredTemp) {
        return Math.max(0, (providedTemp - requiredTemp) / 900);
    }

    public static long applyCoilEUtDiscount(long recipeEUt, int providedTemp, int requiredTemp) {
        if (requiredTemp < 900) {
            return recipeEUt;
        }
        int amountEUtDiscount = OverclockingLogic.calculateAmountCoilEUtDiscount(providedTemp, requiredTemp);
        if (amountEUtDiscount < 1) {
            return recipeEUt;
        }
        return (long)((double)recipeEUt * Math.min(1.0, Math.pow(0.95, amountEUtDiscount)));
    }

    protected int getOverclockForTier(long voltage) {
        return GTUtil.getTierByVoltage(voltage);
    }

    public Logic getLogic() {
        return this.logic;
    }

    @FunctionalInterface
    public static interface Logic {
        public void runOverclockingLogic(@NotNull OCParams var1, @NotNull OCResult var2, long var3);
    }
}

