/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.category;

import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class GTRecipeCategory {
    private static final Map<String, GTRecipeCategory> categories = new Object2ObjectOpenHashMap();
    public static final GTRecipeCategory EMPTY = new GTRecipeCategory();
    private final String modID;
    private final String name;
    private final String uniqueID;
    private final String translation;
    private final GTRecipeType recipeType;
    @Nullable
    private Object icon = null;
    private ResourceLocation resourceLocation;

    public static GTRecipeCategory of(@NotNull String modID, @NotNull String categoryName, @NotNull GTRecipeType recipeType, @NotNull String translationKey) {
        return categories.computeIfAbsent(categoryName, k -> new GTRecipeCategory(modID, categoryName, recipeType, translationKey));
    }

    public static GTRecipeCategory of(@NotNull String modID, @NotNull String categoryName, @NotNull GTRecipeType recipeType) {
        return GTRecipeCategory.of(modID, categoryName, recipeType, "%s.recipe.category.%s".formatted(modID, categoryName));
    }

    public static GTRecipeCategory of(@NotNull GTRecipeType recipeType) {
        return GTRecipeCategory.of("gtceu", recipeType.registryName.m_135815_(), recipeType, recipeType.registryName.m_214298_());
    }

    private GTRecipeCategory() {
        this.modID = "";
        this.name = "";
        this.uniqueID = "";
        this.translation = "";
        this.recipeType = GTRecipeTypes.DUMMY_RECIPES;
    }

    private GTRecipeCategory(@NotNull String modID, @NotNull String categoryName, @NotNull GTRecipeType recipeType, @NotNull String translationKey) {
        this.modID = modID;
        this.name = categoryName;
        this.uniqueID = modID + ":" + this.name;
        this.translation = translationKey;
        this.recipeType = recipeType;
        this.resourceLocation = new ResourceLocation(modID, categoryName);
        GTRegistries.RECIPE_CATEGORIES.register(this.resourceLocation, this);
    }

    public GTRecipeCategory setIcon(@Nullable Object icon) {
        this.icon = icon;
        return this;
    }

    public boolean isXEIVisible() {
        return this.recipeType.getRecipeUI().isXEIVisible();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GTRecipeCategory that = (GTRecipeCategory)obj;
        return this.getUniqueID().equals(that.getUniqueID());
    }

    public int hashCode() {
        return this.getUniqueID().hashCode();
    }

    public String toString() {
        return "GTRecipeCategory{" + this.uniqueID + "}";
    }

    public String getModID() {
        return this.modID;
    }

    public String getName() {
        return this.name;
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    public String getTranslation() {
        return this.translation;
    }

    public GTRecipeType getRecipeType() {
        return this.recipeType;
    }

    @Nullable
    public Object getIcon() {
        return this.icon;
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }
}

