/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.chance.logic;

import com.google.common.collect.ImmutableList;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.recipe.chance.boost.ChanceBoostFunction;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fml.ModLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class ChanceLogic {
    public static final ChanceLogic OR;
    public static final ChanceLogic AND;
    public static final ChanceLogic XOR;
    public static final ChanceLogic NONE;

    public ChanceLogic(String id) {
        GTRegistries.CHANCE_LOGICS.register(id, this);
    }

    static int getChance(@NotNull Content entry, @NotNull ChanceBoostFunction boostFunction, int baseTier, int machineTier) {
        return boostFunction.getBoostedChance(entry, baseTier, machineTier);
    }

    static boolean passesChance(int chance, int maxChance) {
        return chance >= maxChance;
    }

    public static int getMaxChancedValue() {
        return 10000;
    }

    static int getCachedChance(Content entry, @Nullable Object2IntMap<?> cache) {
        if (cache == null || !cache.containsKey(entry.content)) {
            return GTValues.RNG.m_188503_(entry.maxChance);
        }
        return cache.getInt(entry.content);
    }

    static void updateCachedChance(Object ingredient, @Nullable Object2IntMap<?> cache, int chance) {
        if (cache == null) {
            return;
        }
        cache.put(ingredient, chance);
    }

    public abstract @Nullable @Unmodifiable List<@NotNull Content> roll(@NotNull @NotNull @Unmodifiable List<@NotNull Content> var1, @NotNull ChanceBoostFunction var2, int var3, int var4, @Nullable Object2IntMap<?> var5, int var6, RecipeCapability<?> var7);

    public @Nullable @Unmodifiable List<@NotNull Content> roll(@NotNull @NotNull @Unmodifiable List<@NotNull Content> chancedEntries, @NotNull ChanceBoostFunction boostFunction, int baseTier, int machineTier, int times, RecipeCapability<?> cap) {
        return this.roll(chancedEntries, boostFunction, baseTier, machineTier, null, times, cap);
    }

    @NotNull
    public abstract Component getTranslation();

    @ApiStatus.Internal
    public static void init() {
        ModLoader.get().postEvent(new GTCEuAPI.RegisterEvent(GTRegistries.CHANCE_LOGICS, ChanceLogic.class));
        GTRegistries.CHANCE_LOGICS.freeze();
    }

    static {
        GTRegistries.CHANCE_LOGICS.unfreeze();
        OR = new ChanceLogic("or"){

            @Override
            public @Nullable @Unmodifiable List<@NotNull Content> roll(@NotNull @NotNull @Unmodifiable List<@NotNull Content> chancedEntries, @NotNull ChanceBoostFunction boostFunction, int baseTier, int machineTier, @Nullable Object2IntMap<?> cache, int times, RecipeCapability<?> cap) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Content entry : chancedEntries) {
                    int cached;
                    int chance;
                    int maxChance;
                    int newChance = 1.getChance(entry, boostFunction, baseTier, machineTier);
                    int totalChance = times * newChance;
                    int guaranteed = totalChance / (maxChance = entry.maxChance);
                    if (guaranteed > 0) {
                        builder.add((Object)entry.copyExplicit(cap, ContentModifier.multiplier(guaranteed)));
                    }
                    if (1.passesChance(chance = (newChance = totalChance - guaranteed * maxChance) + (cached = 1.getCachedChance(entry, cache)), maxChance)) {
                        do {
                            builder.add((Object)entry);
                            newChance -= maxChance;
                        } while (1.passesChance(chance -= maxChance, maxChance));
                    }
                    1.updateCachedChance(entry.content, cache, newChance / 2 + cached);
                }
                ImmutableList list = builder.build();
                return list.isEmpty() ? null : list;
            }

            @Override
            @NotNull
            public Component getTranslation() {
                return Component.m_237115_((String)"gtceu.chance_logic.or");
            }

            public String toString() {
                return "ChanceLogic{OR}";
            }
        };
        AND = new ChanceLogic("and"){

            @Override
            public @Nullable @Unmodifiable List<@NotNull Content> roll(@NotNull @NotNull @Unmodifiable List<@NotNull Content> chancedEntries, @NotNull ChanceBoostFunction boostFunction, int baseTier, int machineTier, @Nullable Object2IntMap<?> cache, int times, RecipeCapability<?> cap) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int i = 0; i < times; ++i) {
                    boolean failed = false;
                    for (Content entry : chancedEntries) {
                        int cached = 2.getCachedChance(entry, cache);
                        int newChance = 2.getChance(entry, boostFunction, baseTier, machineTier);
                        int chance = newChance + cached;
                        if (!2.passesChance(chance, entry.maxChance)) {
                            failed = true;
                        }
                        2.updateCachedChance(entry.content, cache, newChance / 2 + cached);
                        if (!failed) continue;
                        break;
                    }
                    if (failed) continue;
                    builder.addAll(chancedEntries);
                }
                ImmutableList list = builder.build();
                return list.isEmpty() ? null : list;
            }

            @Override
            @NotNull
            public Component getTranslation() {
                return Component.m_237115_((String)"gtceu.chance_logic.and");
            }

            public String toString() {
                return "ChanceLogic{AND}";
            }
        };
        XOR = new ChanceLogic("xor"){

            @Override
            public @Nullable @Unmodifiable List<@NotNull Content> roll(@NotNull @NotNull @Unmodifiable List<@NotNull Content> chancedEntries, @NotNull ChanceBoostFunction boostFunction, int baseTier, int machineTier, @Nullable Object2IntMap<?> cache, int times, RecipeCapability<?> cap) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int i = 0; i < times; ++i) {
                    Content selected = null;
                    for (Content entry : chancedEntries) {
                        int cached = 3.getCachedChance(entry, cache);
                        int newChance = 3.getChance(entry, boostFunction, baseTier, machineTier);
                        int chance = newChance + cached;
                        if (3.passesChance(chance, entry.maxChance)) {
                            selected = entry;
                        }
                        3.updateCachedChance(entry.content, cache, newChance / 2 + cached);
                        if (selected == null) continue;
                        break;
                    }
                    if (selected == null) continue;
                    builder.add(selected);
                }
                ImmutableList list = builder.build();
                return list.isEmpty() ? null : list;
            }

            @Override
            @NotNull
            public Component getTranslation() {
                return Component.m_237115_((String)"gtceu.chance_logic.xor");
            }

            public String toString() {
                return "ChanceLogic{XOR}";
            }
        };
        NONE = new ChanceLogic("none"){

            @Override
            public @Nullable @Unmodifiable List<@NotNull Content> roll(@NotNull @NotNull @Unmodifiable List<@NotNull Content> chancedEntries, @NotNull ChanceBoostFunction boostFunction, int baseTier, int machineTier, @Nullable Object2IntMap<?> cache, int times, RecipeCapability<?> cap) {
                return null;
            }

            @Override
            @NotNull
            public Component getTranslation() {
                return Component.m_237115_((String)"gtceu.chance_logic.none");
            }

            public String toString() {
                return "ChanceLogic{NONE}";
            }
        };
    }
}

