/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.content;

import java.math.BigDecimal;
import java.math.BigInteger;

public class ContentModifier {
    private final double multiplier;
    private final double addition;

    public static ContentModifier of(double multiplier, double addition) {
        return new ContentModifier(multiplier, addition);
    }

    public static ContentModifier multiplier(double multiplier) {
        return new ContentModifier(multiplier, 0.0);
    }

    public static ContentModifier addition(double addition) {
        return new ContentModifier(1.0, addition);
    }

    public ContentModifier(double multiplier, double addition) {
        this.multiplier = multiplier;
        this.addition = addition;
    }

    public Number apply(Number number) {
        if (number instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)number;
            return decimal.multiply(BigDecimal.valueOf(this.multiplier)).add(BigDecimal.valueOf(this.addition));
        }
        if (number instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)number;
            return bigInteger.multiply(BigInteger.valueOf((long)this.multiplier)).add(BigInteger.valueOf((long)this.addition));
        }
        return number.doubleValue() * this.multiplier + this.addition;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public double getAddition() {
        return this.addition;
    }
}

