/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.modifier;

import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ParallelLogic {
    @NotNull
    public static Pair<GTRecipe, Integer> applyParallel(MetaMachine machine, @NotNull GTRecipe recipe, int parallelLimit, boolean modifyDuration) {
        if (machine instanceof IRecipeLogicMachine) {
            IRecipeLogicMachine rlm = (IRecipeLogicMachine)((Object)machine);
            return ParallelLogic.doParallelRecipes(recipe, rlm, parallelLimit, modifyDuration);
        }
        return Pair.of((Object)recipe, (Object)1);
    }

    public static int getMaxRecipeMultiplier(@NotNull GTRecipe recipe, @NotNull IRecipeCapabilityHolder holder, int parallelAmount) {
        IntOpenHashSet multipliers = new IntOpenHashSet();
        for (RecipeCapability<?> cap : recipe.inputs.keySet()) {
            if (!cap.doMatchInRecipe()) continue;
            multipliers.add(cap.getMaxParallelRatio(holder, recipe, parallelAmount));
        }
        for (RecipeCapability<?> cap : recipe.tickInputs.keySet()) {
            if (!cap.doMatchInRecipe()) continue;
            multipliers.add(cap.getMaxParallelRatio(holder, recipe, parallelAmount));
        }
        if (multipliers.intStream().allMatch(value -> value == Integer.MAX_VALUE)) {
            return 0;
        }
        return multipliers.intStream().min().orElse(0);
    }

    public static int limitByOutputMerging(@NotNull GTRecipe recipe, @NotNull IRecipeCapabilityHolder holder, int parallelAmount, Predicate<RecipeCapability<?>> canVoid) {
        boolean voiding;
        Object2IntOpenHashMap modifiedParallelAmounts = new Object2IntOpenHashMap();
        boolean canVoidAll = true;
        for (RecipeCapability<?> cap : recipe.outputs.keySet()) {
            modifiedParallelAmounts.put(cap, Integer.MAX_VALUE);
            if (canVoid.test(cap)) continue;
            canVoidAll = false;
        }
        for (RecipeCapability<?> cap : recipe.tickOutputs.keySet()) {
            modifiedParallelAmounts.put(cap, Integer.MAX_VALUE);
            if (canVoid.test(cap)) continue;
            canVoidAll = false;
        }
        if (canVoidAll) {
            return parallelAmount;
        }
        for (RecipeCapability<?> cap : recipe.outputs.keySet()) {
            if (!cap.doMatchInRecipe() || recipe.getOutputContents(cap).isEmpty()) continue;
            voiding = canVoid.test(cap);
            if (voiding) {
                modifiedParallelAmounts.put(cap, parallelAmount);
            } else {
                modifiedParallelAmounts.put(cap, cap.limitParallel(recipe, holder, parallelAmount));
            }
            if (modifiedParallelAmounts.getInt(cap) != 0 || voiding) continue;
            return 0;
        }
        for (RecipeCapability<?> cap : recipe.tickOutputs.keySet()) {
            if (!cap.doMatchInRecipe() || recipe.getTickOutputContents(cap).isEmpty()) continue;
            voiding = canVoid.test(cap);
            if (voiding) {
                if (modifiedParallelAmounts.containsKey(cap)) {
                    modifiedParallelAmounts.put(cap, Math.min(modifiedParallelAmounts.getInt(cap), parallelAmount));
                } else {
                    modifiedParallelAmounts.put(cap, parallelAmount);
                }
            } else if (modifiedParallelAmounts.containsKey(cap)) {
                modifiedParallelAmounts.put(cap, Math.min(modifiedParallelAmounts.getInt(cap), cap.limitParallel(recipe, holder, parallelAmount)));
            } else {
                modifiedParallelAmounts.put(cap, cap.limitParallel(recipe, holder, parallelAmount));
            }
            if (modifiedParallelAmounts.getInt(cap) != 0 || voiding) continue;
            return 0;
        }
        return modifiedParallelAmounts.values().intStream().min().orElse(0);
    }

    public static int @NotNull [] adjustMultiplier(boolean mergedAll, int minMultiplier, int multiplier, int maxMultiplier) {
        if (mergedAll) {
            minMultiplier = multiplier;
            int remainder = (maxMultiplier - multiplier) % 2;
            multiplier = multiplier + remainder + (maxMultiplier - multiplier) / 2;
        } else {
            maxMultiplier = multiplier;
            multiplier = (multiplier + minMultiplier) / 2;
        }
        if (maxMultiplier - minMultiplier <= 1) {
            multiplier = maxMultiplier = minMultiplier;
        }
        return new int[]{minMultiplier, multiplier, maxMultiplier};
    }

    @NotNull
    public static Pair<GTRecipe, Integer> doParallelRecipes(@NotNull GTRecipe currentRecipe, @NotNull IRecipeLogicMachine machine, int parallelAmount, boolean modifyDuration) {
        int multiplierByInputs = ParallelLogic.getMaxRecipeMultiplier(currentRecipe, machine, parallelAmount);
        if (multiplierByInputs == 0) {
            return Pair.of((Object)currentRecipe, (Object)1);
        }
        int limitByOutput = ParallelLogic.limitByOutputMerging(currentRecipe, machine, multiplierByInputs, machine::canVoidRecipeOutputs);
        if (limitByOutput > 0) {
            GTRecipe multiRecipe = currentRecipe.copy(ContentModifier.multiplier(limitByOutput), modifyDuration);
            multiRecipe.parallels *= limitByOutput;
            return Pair.of((Object)multiRecipe, (Object)limitByOutput);
        }
        return Pair.of((Object)currentRecipe, (Object)limitByOutput);
    }
}

