/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.transfer.fluid;

import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class ModifiableFluidHandlerWrapper
implements IFluidHandlerModifiable {
    private IFluidHandler handler;

    @Override
    public void setFluidInTank(int tank, FluidStack fluidStack) {
        FluidStack fluid = this.handler.getFluidInTank(tank);
        FluidStack canDrain = this.handler.drain(fluid, IFluidHandler.FluidAction.SIMULATE);
        if (!canDrain.isEmpty()) {
            this.drain(canDrain, IFluidHandler.FluidAction.EXECUTE);
            this.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public int getTanks() {
        return this.handler.getTanks();
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.handler.getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        return this.handler.getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.handler.isFluidValid(tank, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.handler.fill(resource, action);
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.handler.drain(resource, action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.handler.drain(maxDrain, action);
    }

    public ModifiableFluidHandlerWrapper(IFluidHandler handler) {
        this.handler = handler;
    }
}

