/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.transfer.fluid;

import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class TagOrCycleFluidHandler
implements IFluidHandlerModifiable {
    private List<Either<List<Pair<TagKey<Fluid>, Integer>>, List<FluidStack>>> stacks;
    private List<List<FluidStack>> unwrapped = null;

    public TagOrCycleFluidHandler(List<Either<List<Pair<TagKey<Fluid>, Integer>>, List<FluidStack>>> stacks) {
        this.updateStacks(stacks);
    }

    public void updateStacks(List<Either<List<Pair<TagKey<Fluid>, Integer>>, List<FluidStack>>> stacks) {
        this.stacks = new ArrayList<Either<List<Pair<TagKey<Fluid>, Integer>>, List<FluidStack>>>(stacks);
        this.unwrapped = null;
    }

    public List<List<FluidStack>> getUnwrapped() {
        if (this.unwrapped == null) {
            this.unwrapped = this.stacks.stream().map(tagOrFluid -> {
                if (tagOrFluid == null) {
                    return null;
                }
                return (List)tagOrFluid.map(tagList -> tagList.stream().flatMap(pair -> BuiltInRegistries.f_257020_.m_203431_((TagKey)pair.getFirst()).map(holderSet -> holderSet.m_203614_().map(holder -> new FluidStack((Fluid)holder.m_203334_(), ((Integer)pair.getSecond()).intValue()))).orElseGet(Stream::empty)).toList(), Function.identity());
            }).collect(Collectors.toList());
        }
        return this.unwrapped;
    }

    public int getTanks() {
        return this.stacks.size();
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        List<FluidStack> stackList = this.getUnwrapped().get(tank);
        return stackList == null || stackList.isEmpty() ? FluidStack.EMPTY : stackList.get(Math.abs((int)(System.currentTimeMillis() / 1000L) % stackList.size()));
    }

    @Override
    public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
        if (tank >= 0 && tank < this.stacks.size()) {
            this.stacks.set(tank, (Either<List<Pair<TagKey<Fluid>, Integer>>, List<FluidStack>>)Either.right(List.of(fluidStack)));
            this.unwrapped = null;
        }
    }

    public int getTankCapacity(int tank) {
        return this.getFluidInTank(tank).getAmount();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    @Override
    public boolean supportsFill(int tank) {
        return false;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    @Override
    public boolean supportsDrain(int tank) {
        return false;
    }

    public List<Either<List<Pair<TagKey<Fluid>, Integer>>, List<FluidStack>>> getStacks() {
        return this.stacks;
    }
}

