/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.transfer.item;

import com.lowdragmc.lowdraglib.syncdata.IContentChangeAware;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class CustomItemStackHandler
extends ItemStackHandler
implements IContentChangeAware,
ITagSerializable<CompoundTag> {
    protected Runnable onContentsChanged;
    protected Predicate<ItemStack> filter;

    public CustomItemStackHandler() {
        this.onContentsChanged = () -> {};
        this.filter = stack -> true;
    }

    public CustomItemStackHandler(int size) {
        super(size);
        this.onContentsChanged = () -> {};
        this.filter = stack -> true;
    }

    public CustomItemStackHandler(ItemStack itemStack) {
        this((NonNullList<ItemStack>)NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{itemStack}));
    }

    public CustomItemStackHandler(NonNullList<ItemStack> stacks) {
        super(stacks);
        this.onContentsChanged = () -> {};
        this.filter = stack -> true;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.filter.test(stack);
    }

    public void onContentsChanged(int slot) {
        this.onContentsChanged.run();
    }

    public void clear() {
        this.stacks.clear();
        this.onContentsChanged.run();
    }

    public Runnable getOnContentsChanged() {
        return this.onContentsChanged;
    }

    public void setOnContentsChanged(Runnable onContentsChanged) {
        this.onContentsChanged = onContentsChanged;
    }

    public Predicate<ItemStack> getFilter() {
        return this.filter;
    }

    public void setFilter(Predicate<ItemStack> filter) {
        this.filter = filter;
    }
}

