/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.transfer.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class CycleItemStackHandler
implements IItemHandlerModifiable {
    private List<List<ItemStack>> stacks;

    public CycleItemStackHandler(List<List<ItemStack>> stacks) {
        this.updateStacks(stacks);
    }

    public void updateStacks(List<List<ItemStack>> stacks) {
        this.stacks = stacks;
    }

    public int getSlots() {
        return this.stacks.size();
    }

    @Nonnull
    public ItemStack getStackInSlot(int i) {
        List<ItemStack> stackList = this.stacks.get(i);
        return stackList == null || stackList.isEmpty() ? ItemStack.f_41583_ : stackList.get(Math.abs((int)(System.currentTimeMillis() / 1000L) % stackList.size()));
    }

    public void setStackInSlot(int index, ItemStack stack) {
        if (index >= 0 && index < this.stacks.size()) {
            this.stacks.set(index, List.of(stack));
        }
    }

    public List<ItemStack> getStackList(int i) {
        return this.stacks.get(i);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int i) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }
}

