/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.transfer.item;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class TagOrCycleItemStackHandler
implements IItemHandlerModifiable {
    private List<Either<List<Pair<TagKey<Item>, Integer>>, List<ItemStack>>> stacks;
    private List<List<ItemStack>> unwrapped = null;

    public TagOrCycleItemStackHandler(List<Either<List<Pair<TagKey<Item>, Integer>>, List<ItemStack>>> stacks) {
        this.updateStacks(stacks);
    }

    public void updateStacks(List<Either<List<Pair<TagKey<Item>, Integer>>, List<ItemStack>>> stacks) {
        this.stacks = new ArrayList<Either<List<Pair<TagKey<Item>, Integer>>, List<ItemStack>>>(stacks);
        this.unwrapped = null;
    }

    public List<List<ItemStack>> getUnwrapped() {
        if (this.unwrapped == null) {
            this.unwrapped = this.stacks.stream().map(tagOrItem -> {
                if (tagOrItem == null) {
                    return null;
                }
                return (List)tagOrItem.map(tagList -> tagList.stream().flatMap(pair -> BuiltInRegistries.f_257033_.m_203431_((TagKey)pair.getFirst()).map(holderSet -> holderSet.m_203614_().map(holder -> new ItemStack((ItemLike)holder.m_203334_(), ((Integer)pair.getSecond()).intValue()))).orElseGet(Stream::empty)).toList(), Function.identity());
            }).collect(Collectors.toCollection(ArrayList::new));
        }
        return this.unwrapped;
    }

    public int getSlots() {
        return this.stacks.size();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        List<ItemStack> stackList = this.getUnwrapped().get(slot);
        return stackList == null || stackList.isEmpty() ? ItemStack.f_41583_ : stackList.get(Math.abs((int)(System.currentTimeMillis() / 1000L) % stackList.size()));
    }

    public void setStackInSlot(int index, ItemStack stack) {
        if (index >= 0 && index < this.stacks.size()) {
            this.stacks.set(index, (Either<List<Pair<TagKey<Item>, Integer>>, List<ItemStack>>)Either.right(List.of(stack)));
            this.unwrapped = null;
        }
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return true;
    }

    public List<Either<List<Pair<TagKey<Item>, Integer>>, List<ItemStack>>> getStacks() {
        return this.stacks;
    }
}

