/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.client.renderer.machine.TieredHullMachineRenderer;
import com.gregtechceu.gtceu.client.util.StaticFaceBakery;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.research.HPCAMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.hpca.HPCAComponentPartMachine;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class HPCAPartRenderer
extends TieredHullMachineRenderer {
    private final boolean isAdvanced;
    private final ResourceLocation texture;
    private final ResourceLocation activeTexture;
    private final ResourceLocation activeEmissiveTexture;
    private final ResourceLocation damagedTexture;
    private final ResourceLocation damagedActiveTexture;
    private final ResourceLocation damagedActiveEmissiveTexture;

    public HPCAPartRenderer(boolean isAdvanced, ResourceLocation texture, ResourceLocation damagedTexture) {
        super(7, isAdvanced ? GTCEu.id("block/computer_casing") : GTCEu.id("block/advanced_computer_casing"));
        this.isAdvanced = isAdvanced;
        this.texture = texture;
        this.activeTexture = texture.m_266382_("_active");
        this.activeEmissiveTexture = this.activeTexture.m_266382_("_emissive");
        this.damagedTexture = damagedTexture;
        this.damagedActiveTexture = damagedTexture.m_266382_("_active");
        this.damagedActiveEmissiveTexture = this.damagedActiveTexture.m_266382_("_emissive");
    }

    public HPCAPartRenderer(boolean isAdvanced, ResourceLocation texture, @Nullable ResourceLocation activeTexture, @Nullable ResourceLocation activeEmissiveTexture, @Nullable ResourceLocation damagedTexture, @Nullable ResourceLocation damagedActiveTexture, @Nullable ResourceLocation damagedActiveEmissiveTexture) {
        super(7, isAdvanced ? GTCEu.id("block/computer_casing") : GTCEu.id("block/advanced_computer_casing"));
        this.isAdvanced = isAdvanced;
        this.texture = texture;
        this.activeTexture = activeTexture;
        this.activeEmissiveTexture = activeEmissiveTexture;
        this.damagedTexture = damagedTexture;
        this.damagedActiveTexture = damagedActiveTexture;
        this.damagedActiveEmissiveTexture = damagedActiveEmissiveTexture;
    }

    @Override
    public void renderMachine(List<BakedQuad> quads, MachineDefinition definition, @Nullable MetaMachine machine, Direction frontFacing, @Nullable Direction side, RandomSource rand, @Nullable Direction modelFacing, ModelState modelState) {
        super.renderMachine(quads, definition, machine, frontFacing, side, rand, modelFacing, modelState);
        if (machine instanceof HPCAComponentPartMachine) {
            ResourceLocation texture;
            IWorkable workable;
            IMultiController controller;
            HPCAComponentPartMachine hpcaComponent = (HPCAComponentPartMachine)machine;
            ResourceLocation emissiveTexture = null;
            IMultiController iMultiController = controller = hpcaComponent.getControllers().isEmpty() ? null : hpcaComponent.getControllers().get(0);
            if (controller != null && controller instanceof IWorkable && (workable = (IWorkable)((Object)controller)).isActive()) {
                if (hpcaComponent.isDamaged()) {
                    texture = this.damagedActiveTexture;
                    emissiveTexture = this.damagedActiveEmissiveTexture;
                } else {
                    texture = this.activeTexture;
                    emissiveTexture = this.activeEmissiveTexture;
                }
            } else {
                texture = hpcaComponent.isDamaged() ? this.damagedTexture : this.texture;
            }
            if (texture == null) {
                texture = this.texture;
            }
            if (texture != null) {
                Direction facing = frontFacing;
                if (controller instanceof HPCAMachine) {
                    HPCAMachine hpca = (HPCAMachine)controller;
                    facing = RelativeDirection.RIGHT.getRelativeFacing(hpca.getFrontFacing(), hpca.getUpwardsFacing(), hpca.isFlipped());
                }
                facing = ModelFactory.modelFacing((Direction)frontFacing, (Direction)facing);
                quads.add(StaticFaceBakery.bakeFace(StaticFaceBakery.SLIGHTLY_OVER_BLOCK, facing, ModelFactory.getBlockSprite((ResourceLocation)texture), modelState, -1, 0, true, true));
                if (emissiveTexture != null) {
                    quads.add(StaticFaceBakery.bakeFace(StaticFaceBakery.SLIGHTLY_OVER_BLOCK, facing, ModelFactory.getBlockSprite((ResourceLocation)emissiveTexture), modelState, -101, 15, true, false));
                }
            }
        } else {
            ResourceLocation texture = this.texture;
            if (texture != null) {
                quads.add(StaticFaceBakery.bakeFace(StaticFaceBakery.SLIGHTLY_OVER_BLOCK, Direction.NORTH, ModelFactory.getBlockSprite((ResourceLocation)texture), modelState, -1, 0, true, true));
            }
        }
    }
}

