/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.model.SpriteOverrider;
import com.gregtechceu.gtceu.client.renderer.machine.IPartRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.TieredHullMachineRenderer;
import com.lowdragmc.lowdraglib.client.bakedpipeline.Quad;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.lowdragmc.lowdraglib.client.renderer.impl.IModelRenderer;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class OverlayTieredMachineRenderer
extends TieredHullMachineRenderer
implements IPartRenderer {
    protected IModelRenderer overlayModel;

    public OverlayTieredMachineRenderer(int tier, ResourceLocation overlayModel) {
        super(tier, GTCEu.id("block/machine/hull_machine"));
        this.overlayModel = new IModelRenderer(overlayModel);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderMachine(List<BakedQuad> quads, MachineDefinition definition, @Nullable MetaMachine machine, Direction frontFacing, @Nullable Direction side, RandomSource rand, Direction modelFacing, ModelState modelState) {
        super.renderMachine(quads, definition, machine, frontFacing, side, rand, modelFacing, modelState);
        quads.addAll(this.overlayModel.getRotatedModel(frontFacing).m_213637_(definition.defaultBlockState(), side, rand).stream().map(quad -> Quad.from((BakedQuad)quad, (float)this.reBakeOverlayQuadsOffset()).rebake()).toList());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BakedModel getRotatedModel(Direction frontFacing) {
        return this.blockModels.computeIfAbsent(frontFacing, facing -> this.getModel().m_7611_(ModelFactory.getModeBaker(), (Function)new SpriteOverrider(this.override), ModelFactory.getRotation((Direction)facing), this.modelLocation));
    }

    public float reBakeOverlayQuadsOffset() {
        return 0.002f;
    }
}

