/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.renderer.machine.OverlayEnergyIORenderer;
import com.gregtechceu.gtceu.client.renderer.machine.TieredHullMachineRenderer;
import com.gregtechceu.gtceu.common.machine.electric.TransformerMachine;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class TransformerRenderer
extends TieredHullMachineRenderer {
    private final int baseAmp;

    public TransformerRenderer(int tier, int baseAmp) {
        super(tier, GTCEu.id("block/machine/hull_machine"));
        this.baseAmp = baseAmp;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderMachine(List<BakedQuad> quads, MachineDefinition definition, @Nullable MetaMachine machine, Direction frontFacing, @Nullable Direction side, RandomSource rand, Direction modelFacing, ModelState modelState) {
        super.renderMachine(quads, definition, machine, frontFacing, side, rand, modelFacing, modelState);
        OverlayEnergyIORenderer otherFaceTexture = OverlayEnergyIORenderer.ENERGY_OUT_4A;
        OverlayEnergyIORenderer frontFaceTexture = OverlayEnergyIORenderer.ENERGY_IN_1A;
        boolean isTransformUp = false;
        if (machine instanceof TransformerMachine) {
            TransformerMachine transformer = (TransformerMachine)machine;
            isTransformUp = transformer.isTransformUp();
        }
        switch (this.baseAmp) {
            case 1: {
                otherFaceTexture = isTransformUp ? OverlayEnergyIORenderer.ENERGY_IN_4A : otherFaceTexture;
                frontFaceTexture = isTransformUp ? OverlayEnergyIORenderer.ENERGY_OUT_1A : frontFaceTexture;
                break;
            }
            case 2: {
                otherFaceTexture = isTransformUp ? OverlayEnergyIORenderer.ENERGY_IN_8A : OverlayEnergyIORenderer.ENERGY_OUT_8A;
                frontFaceTexture = isTransformUp ? OverlayEnergyIORenderer.ENERGY_OUT_2A : OverlayEnergyIORenderer.ENERGY_IN_2A;
                break;
            }
            case 4: {
                otherFaceTexture = isTransformUp ? OverlayEnergyIORenderer.ENERGY_IN_16A : OverlayEnergyIORenderer.ENERGY_OUT_16A;
                frontFaceTexture = isTransformUp ? OverlayEnergyIORenderer.ENERGY_OUT_4A : OverlayEnergyIORenderer.ENERGY_IN_4A;
                break;
            }
            default: {
                otherFaceTexture = isTransformUp ? OverlayEnergyIORenderer.ENERGY_IN_64A : OverlayEnergyIORenderer.ENERGY_OUT_64A;
                OverlayEnergyIORenderer overlayEnergyIORenderer = frontFaceTexture = isTransformUp ? OverlayEnergyIORenderer.ENERGY_OUT_16A : OverlayEnergyIORenderer.ENERGY_IN_16A;
            }
        }
        if (side == frontFacing && modelFacing != null) {
            frontFaceTexture.renderOverlay(quads, modelFacing, modelState, 2);
        } else if (side != null && modelFacing != null) {
            otherFaceTexture.renderOverlay(quads, modelFacing, modelState, 3);
        }
    }
}

