/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.IUICover;
import com.gregtechceu.gtceu.api.cover.filter.ItemFilter;
import com.gregtechceu.gtceu.api.cover.filter.SmartItemFilter;
import com.gregtechceu.gtceu.api.gui.widget.EnumSelectorWidget;
import com.gregtechceu.gtceu.api.machine.MachineCoverContainer;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.transfer.item.ItemHandlerDelegate;
import com.gregtechceu.gtceu.common.cover.data.FilterMode;
import com.gregtechceu.gtceu.common.cover.data.ManualIOMode;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemFilterCover
extends CoverBehavior
implements IUICover {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ItemFilterCover.class, CoverBehavior.MANAGED_FIELD_HOLDER);
    protected ItemFilter itemFilter;
    @Persisted
    @DescSynced
    protected FilterMode filterMode = FilterMode.FILTER_INSERT;
    private FilteredItemHandlerWrapper itemFilterWrapper;
    protected ManualIOMode allowFlow = ManualIOMode.DISABLED;

    public ItemFilterCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide);
    }

    public ItemFilter getItemFilter() {
        if (this.itemFilter == null) {
            this.itemFilter = ItemFilter.loadFilter(this.attachItem);
            Object object = this.itemFilter;
            if (object instanceof SmartItemFilter) {
                MachineCoverContainer mcc;
                MetaMachine machine;
                SmartItemFilter smart = (SmartItemFilter)object;
                object = this.coverHolder;
                if (object instanceof MachineCoverContainer && (machine = MetaMachine.getMachine((BlockGetter)(mcc = (MachineCoverContainer)object).getLevel(), mcc.getPos())) != null) {
                    smart.setModeFromMachine(machine.getDefinition().getName());
                }
            }
        }
        return this.itemFilter;
    }

    public void setFilterMode(FilterMode filterMode) {
        this.filterMode = filterMode;
        this.coverHolder.markDirty();
    }

    @Override
    public boolean canAttach() {
        return GTTransferUtils.getItemHandler(this.coverHolder.getLevel(), this.coverHolder.getPos(), this.attachedSide).isPresent();
    }

    @Override
    @Nullable
    public IItemHandlerModifiable getItemHandlerCap(IItemHandlerModifiable defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        if (this.itemFilterWrapper == null || this.itemFilterWrapper.delegate != defaultValue) {
            this.itemFilterWrapper = new FilteredItemHandlerWrapper(defaultValue);
        }
        return this.itemFilterWrapper;
    }

    @Override
    public void onAttached(ItemStack itemStack, ServerPlayer player) {
        super.onAttached(itemStack, player);
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 178, 85);
        group.addWidget((Widget)new LabelWidget(60, 5, this.attachItem.m_41778_()));
        group.addWidget((Widget)new EnumSelectorWidget(35, 25, 18, 18, (Enum[])FilterMode.VALUES, (Enum)this.filterMode, this::setFilterMode));
        group.addWidget((Widget)new EnumSelectorWidget(35, 45, 18, 18, (Enum[])ManualIOMode.VALUES, (Enum)this.allowFlow, this::setAllowFlow));
        group.addWidget((Widget)this.getItemFilter().openConfigurator(62, 25));
        return group;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public FilterMode getFilterMode() {
        return this.filterMode;
    }

    public void setAllowFlow(ManualIOMode allowFlow) {
        this.allowFlow = allowFlow;
    }

    public ManualIOMode getAllowFlow() {
        return this.allowFlow;
    }

    private class FilteredItemHandlerWrapper
    extends ItemHandlerDelegate {
        public FilteredItemHandlerWrapper(IItemHandlerModifiable delegate) {
            super(delegate);
        }

        @Override
        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (ItemFilterCover.this.filterMode == FilterMode.FILTER_EXTRACT && ItemFilterCover.this.allowFlow == ManualIOMode.UNFILTERED) {
                return super.insertItem(slot, stack, simulate);
            }
            if (ItemFilterCover.this.filterMode != FilterMode.FILTER_EXTRACT && ItemFilterCover.this.getItemFilter().test(stack)) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack result = super.extractItem(slot, amount, true);
            if (result.m_41619_() && ItemFilterCover.this.filterMode == FilterMode.FILTER_INSERT && ItemFilterCover.this.allowFlow == ManualIOMode.UNFILTERED) {
                return super.extractItem(slot, amount, false);
            }
            if (ItemFilterCover.this.filterMode != FilterMode.FILTER_INSERT && ItemFilterCover.this.getItemFilter().test(result)) {
                return super.extractItem(slot, amount, false);
            }
            return ItemStack.f_41583_;
        }
    }
}

