/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import appeng.api.util.AEColor;
import appeng.blockentity.networking.CableBusBlockEntity;
import com.google.common.collect.ImmutableMap;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IDurabilityBar;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.common.data.GTSoundEntries;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.utils.GradientUtil;
import com.lowdragmc.lowdraglib.Platform;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.Tags;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class ColorSprayBehaviour
implements IDurabilityBar,
IInteractionItem,
IAddInformation {
    private static final ImmutableMap<DyeColor, Block> GLASS_MAP;
    private static final ImmutableMap<DyeColor, Block> GLASS_PANE_MAP;
    private static final ImmutableMap<DyeColor, Block> TERRACOTTA_MAP;
    private static final ImmutableMap<DyeColor, Block> WOOL_MAP;
    private static final ImmutableMap<DyeColor, Block> CARPET_MAP;
    private static final ImmutableMap<DyeColor, Block> CONCRETE_MAP;
    private static final ImmutableMap<DyeColor, Block> CONCRETE_POWDER_MAP;
    private static final ImmutableMap<DyeColor, Block> SHULKER_BOX_MAP;
    private static final ImmutableMap<DyeColor, Block> CANDLE_MAP;
    private static final ImmutableMap<DyeColor, Block> SEAT_MAP;
    private final Supplier<ItemStack> empty;
    private final DyeColor color;
    public final int totalUses;
    private final Pair<Integer, Integer> durabilityBarColors;

    private static ResourceLocation getId(String modid, DyeColor color, String postfix) {
        return new ResourceLocation(modid, "%s_%s".formatted(color.m_7912_(), postfix));
    }

    public ColorSprayBehaviour(Supplier<ItemStack> empty, int totalUses, int color) {
        this.empty = empty;
        DyeColor[] colors = DyeColor.values();
        this.color = color >= colors.length || color < 0 ? null : colors[color];
        int colorValue = this.color == null ? 0x969696 : this.color.m_41071_();
        this.totalUses = totalUses;
        this.durabilityBarColors = GradientUtil.getGradient(colorValue, 10);
    }

    @Override
    public float getDurabilityForDisplay(ItemStack stack) {
        return (float)this.getUsesLeft(stack) / (float)this.totalUses;
    }

    @Override
    public int getMaxDurability(ItemStack stack) {
        return this.totalUses;
    }

    @Override
    public int getBarColor(ItemStack stack) {
        float f = Math.max(0.0f, this.getDurabilityForDisplay(stack));
        return ColorSprayBehaviour.mixColors(f, (Integer)this.durabilityBarColors.getLeft(), (Integer)this.durabilityBarColors.getRight());
    }

    @Override
    @Nullable
    public Pair<Integer, Integer> getDurabilityColorsForDisplay(ItemStack itemStack) {
        return this.durabilityBarColors;
    }

    private static int mixColors(float ratio, int ... colors) {
        int r = 0;
        int g = 0;
        int b = 0;
        ratio *= 1.0f / (float)colors.length;
        for (int color : colors) {
            r = (int)((float)r + (float)FastColor.ARGB32.m_13665_((int)color) * ratio);
            g = (int)((float)g + (float)FastColor.ARGB32.m_13667_((int)color) * ratio);
            b = (int)((float)b + (float)FastColor.ARGB32.m_13669_((int)color) * ratio);
        }
        return FastColor.ARGB32.m_13660_((int)255, (int)r, (int)g, (int)b);
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        int remainingUses = this.getUsesLeft(stack);
        if (this.color != null) {
            tooltipComponents.add((Component)Component.m_237115_((String)("behaviour.paintspray." + this.color.m_7912_() + ".tooltip")));
        } else {
            tooltipComponents.add((Component)Component.m_237115_((String)"behaviour.paintspray.solvent.tooltip"));
        }
        tooltipComponents.add((Component)Component.m_237110_((String)"behaviour.paintspray.uses", (Object[])new Object[]{remainingUses}));
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        Direction facing = context.m_43719_();
        BlockPos.MutableBlockPos pos = context.m_8083_().m_122032_();
        ItemStack stack = context.m_43722_();
        Block block = level.m_8055_((BlockPos)pos).m_60734_();
        int maxBlocksToRecolor = Math.max(1, player != null && player.m_6144_() ? ConfigHolder.INSTANCE.tools.sprayCanChainLength : 1);
        if (player != null) {
            for (int i = 0; i < maxBlocksToRecolor && level.m_8055_((BlockPos)pos).m_60734_() == block; ++i) {
                if (!this.tryPaintBlock(player, level, (BlockPos)pos, facing)) {
                    return InteractionResult.PASS;
                }
                if (!this.useItemDurability(player, context.m_43724_(), stack, this.empty.get())) break;
                pos.m_122173_(this.getPaintDirection(player));
            }
            GTSoundEntries.SPRAY_CAN_TOOL.play(level, null, player.m_20182_(), 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private Direction getPaintDirection(Player player) {
        if (player.m_146909_() > 45.0f) {
            return Direction.DOWN;
        }
        if (player.m_146909_() < -45.0f) {
            return Direction.UP;
        }
        return player.m_6350_();
    }

    private boolean tryPaintBlock(Player player, Level world, BlockPos pos, Direction side) {
        BlockState blockState = world.m_8055_(pos);
        Block block = blockState.m_60734_();
        if (this.color == null) {
            return ColorSprayBehaviour.tryStripBlockColor(player, world, pos, block, side);
        }
        return ColorSprayBehaviour.recolorBlockState(world, pos, side, this.color) || this.tryPaintSpecialBlock(player, world, pos, block);
    }

    private static boolean recolorBlockState(Level level, BlockPos pos, Direction side, DyeColor color) {
        BlockState state = level.m_8055_(pos);
        for (Property property : state.m_61147_()) {
            if (property.m_61709_() != DyeColor.class) continue;
            state.m_61124_(property, (Comparable)color);
            return true;
        }
        return false;
    }

    private boolean tryPaintSpecialBlock(Player player, Level world, BlockPos pos, Block block) {
        CableBusBlockEntity cable;
        IMachineBlockEntity machineBe;
        MetaMachine mte;
        if (block.m_49966_().m_204336_(Tags.Blocks.GLASS) && ColorSprayBehaviour.recolorBlockNoState(GLASS_MAP, this.color, world, pos, Blocks.f_50058_)) {
            return true;
        }
        if (block.m_49966_().m_204336_(Tags.Blocks.GLASS_PANES) && ColorSprayBehaviour.recolorBlockNoState(GLASS_PANE_MAP, this.color, world, pos, Blocks.f_50185_)) {
            return true;
        }
        if (block.m_49966_().m_204336_(BlockTags.f_198156_) && ColorSprayBehaviour.recolorBlockNoState(TERRACOTTA_MAP, this.color, world, pos, Blocks.f_50352_)) {
            return true;
        }
        if (block.m_49966_().m_204336_(BlockTags.f_13089_) && ColorSprayBehaviour.recolorBlockNoState(WOOL_MAP, this.color, world, pos)) {
            return true;
        }
        if (block.m_49966_().m_204336_(BlockTags.f_215838_) && ColorSprayBehaviour.recolorBlockNoState(CARPET_MAP, this.color, world, pos)) {
            return true;
        }
        if (block.m_49966_().m_204336_(CustomTags.CONCRETE_BLOCK) && ColorSprayBehaviour.recolorBlockNoState(CONCRETE_MAP, this.color, world, pos)) {
            return true;
        }
        if (block.m_49966_().m_204336_(CustomTags.CONCRETE_POWDER_BLOCK) && ColorSprayBehaviour.recolorBlockNoState(CONCRETE_POWDER_MAP, this.color, world, pos)) {
            return true;
        }
        if (block.m_49966_().m_204336_(BlockTags.f_13083_) && ColorSprayBehaviour.recolorBlockNoState(SHULKER_BOX_MAP, this.color, world, pos, Blocks.f_50456_)) {
            return true;
        }
        if (block.m_49966_().m_204336_(BlockTags.f_144265_) && ColorSprayBehaviour.recolorBlockNoState(CANDLE_MAP, this.color, world, pos)) {
            return true;
        }
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof IMachineBlockEntity && (mte = (machineBe = (IMachineBlockEntity)be).getMetaMachine()) != null) {
            if (mte.getPaintingColor() != this.color.m_41071_()) {
                mte.setPaintingColor(this.color.m_41071_());
                return true;
            }
            return false;
        }
        if (be instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)be;
            if (pipe.getPaintingColor() != this.color.m_41071_()) {
                pipe.setPaintingColor(this.color.m_41071_());
                return true;
            }
            return false;
        }
        if (GTCEu.isAE2Loaded() && be instanceof CableBusBlockEntity && (cable = (CableBusBlockEntity)be).getColor().ordinal() != this.color.ordinal()) {
            cable.recolourBlock(null, AEColor.values()[this.color.ordinal()], player);
            return true;
        }
        return false;
    }

    private static boolean recolorBlockNoState(Map<DyeColor, Block> map, DyeColor color, Level world, BlockPos pos) {
        return ColorSprayBehaviour.recolorBlockNoState(map, color, world, pos, null);
    }

    private static boolean recolorBlockNoState(Map<DyeColor, Block> map, DyeColor color, Level world, BlockPos pos, Block _default) {
        Block newBlock = map.getOrDefault(color, _default);
        BlockState old = world.m_8055_(pos);
        if (newBlock == Blocks.f_50016_) {
            newBlock = _default;
        }
        if (newBlock != null && newBlock != old.m_60734_()) {
            BlockState state = newBlock.m_49966_();
            for (Property property : old.m_61147_()) {
                state.m_61124_(property, old.m_61143_(property));
            }
            world.m_7731_(pos, state, 3);
            world.m_7260_(pos, old, state, 3);
            return true;
        }
        return false;
    }

    private static boolean tryStripBlockColor(Player player, Level world, BlockPos pos, Block block, Direction side) {
        IMachineBlockEntity machineBe;
        MetaMachine mte;
        if (block instanceof StainedGlassBlock) {
            world.m_7731_(pos, Blocks.f_50058_.m_49966_(), 3);
            return true;
        }
        if (block instanceof StainedGlassPaneBlock) {
            world.m_7731_(pos, Blocks.f_50185_.m_49966_(), 3);
            return true;
        }
        if (block.m_49966_().m_204336_(BlockTags.f_198156_) && block != Blocks.f_50352_) {
            world.m_7731_(pos, Blocks.f_50352_.m_49966_(), 3);
            return true;
        }
        if (block.m_49966_().m_204336_(BlockTags.f_13089_) && block != Blocks.f_50041_) {
            world.m_7731_(pos, Blocks.f_50041_.m_49966_(), 3);
            return true;
        }
        if (block.m_49966_().m_204336_(BlockTags.f_215838_) && block != Blocks.f_50336_) {
            world.m_7731_(pos, Blocks.f_50336_.m_49966_(), 3);
            return true;
        }
        if (block.m_49966_().m_204336_(CustomTags.CONCRETE_BLOCK) && block != Blocks.f_50542_) {
            world.m_7731_(pos, Blocks.f_50542_.m_49966_(), 3);
            return true;
        }
        if (block.m_49966_().m_204336_(CustomTags.CONCRETE_POWDER_BLOCK) && block != Blocks.f_50506_) {
            world.m_7731_(pos, Blocks.f_50506_.m_49966_(), 3);
            return true;
        }
        if (block.m_49966_().m_204336_(BlockTags.f_13083_) && block != Blocks.f_50456_) {
            ColorSprayBehaviour.recolorBlockNoState(SHULKER_BOX_MAP, null, world, pos, Blocks.f_50456_);
            return true;
        }
        if (block.m_49966_().m_204336_(BlockTags.f_144265_) && block != Blocks.f_152483_) {
            ColorSprayBehaviour.recolorBlockNoState(CANDLE_MAP, DyeColor.WHITE, world, pos);
            return true;
        }
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof IMachineBlockEntity && (mte = (machineBe = (IMachineBlockEntity)be).getMetaMachine()) != null) {
            if (mte.isPainted()) {
                mte.setPaintingColor(mte.getDefaultPaintingColor());
                return true;
            }
            return false;
        }
        if (be instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)be;
            if (pipe.isPainted()) {
                pipe.setPaintingColor(pipe.getDefaultPaintingColor());
                return true;
            }
            return false;
        }
        if (GTCEu.isAE2Loaded() && be instanceof CableBusBlockEntity) {
            CableBusBlockEntity cable = (CableBusBlockEntity)be;
            if (cable.getColor() != AEColor.TRANSPARENT) {
                cable.recolourBlock(null, AEColor.TRANSPARENT, player);
                return true;
            }
            return false;
        }
        BlockState state = world.m_8055_(pos);
        for (Property prop : state.m_61147_()) {
            if (prop.m_61709_() != DyeColor.class) continue;
            BlockState defaultState = block.m_49966_();
            DyeColor defaultColor = DyeColor.WHITE;
            try {
                defaultColor = (DyeColor)defaultState.m_61143_(prop);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ColorSprayBehaviour.recolorBlockState(world, pos, side, defaultColor);
            return true;
        }
        return false;
    }

    public boolean useItemDurability(Player player, InteractionHand hand, ItemStack stack, ItemStack replacementStack) {
        int usesLeft = this.getUsesLeft(stack);
        if (!player.m_7500_()) {
            if (--usesLeft <= 0) {
                if (replacementStack.m_41619_()) {
                    stack.m_41774_(1);
                } else {
                    player.m_21008_(hand, replacementStack);
                }
                return false;
            }
            ColorSprayBehaviour.setUsesLeft(stack, usesLeft);
        }
        return true;
    }

    public final int getUsesLeft(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound == null || !tagCompound.m_128425_("UsesLeft", 3)) {
            return this.totalUses;
        }
        return tagCompound.m_128451_("UsesLeft");
    }

    public static void setUsesLeft(ItemStack itemStack, int usesLeft) {
        CompoundTag tagCompound = itemStack.m_41784_();
        tagCompound.m_128405_("UsesLeft", usesLeft);
    }

    static {
        ImmutableMap.Builder glassBuilder = ImmutableMap.builder();
        ImmutableMap.Builder glassPaneBuilder = ImmutableMap.builder();
        ImmutableMap.Builder terracottaBuilder = ImmutableMap.builder();
        ImmutableMap.Builder woolBuilder = ImmutableMap.builder();
        ImmutableMap.Builder carpetBuilder = ImmutableMap.builder();
        ImmutableMap.Builder concreteBuilder = ImmutableMap.builder();
        ImmutableMap.Builder concretePowderBuilder = ImmutableMap.builder();
        ImmutableMap.Builder shulkerBoxBuilder = ImmutableMap.builder();
        ImmutableMap.Builder candleBuilder = ImmutableMap.builder();
        ImmutableMap.Builder seatBuilder = ImmutableMap.builder();
        for (DyeColor color : DyeColor.values()) {
            if (color.ordinal() > 15 && Platform.isModLoaded((String)"tinted")) {
                glassBuilder.put((Object)color, (Object)((Block)BuiltInRegistries.f_256975_.m_7745_(ColorSprayBehaviour.getId("tinted", color, "stained_glass"))));
                glassPaneBuilder.put((Object)color, (Object)((Block)BuiltInRegistries.f_256975_.m_7745_(ColorSprayBehaviour.getId("tinted", color, "stained_glass_pane"))));
                terracottaBuilder.put((Object)color, (Object)((Block)BuiltInRegistries.f_256975_.m_7745_(ColorSprayBehaviour.getId("tinted", color, "terracotta"))));
                woolBuilder.put((Object)color, (Object)((Block)BuiltInRegistries.f_256975_.m_7745_(ColorSprayBehaviour.getId("tinted", color, "wool"))));
                carpetBuilder.put((Object)color, (Object)((Block)BuiltInRegistries.f_256975_.m_7745_(ColorSprayBehaviour.getId("tinted", color, "carpet"))));
                concreteBuilder.put((Object)color, (Object)((Block)BuiltInRegistries.f_256975_.m_7745_(ColorSprayBehaviour.getId("tinted", color, "concrete"))));
                concretePowderBuilder.put((Object)color, (Object)((Block)BuiltInRegistries.f_256975_.m_7745_(ColorSprayBehaviour.getId("tinted", color, "concrete_powder"))));
                shulkerBoxBuilder.put((Object)color, (Object)((Block)BuiltInRegistries.f_256975_.m_7745_(ColorSprayBehaviour.getId("tinted", color, "shulker_box"))));
                candleBuilder.put((Object)color, (Object)((Block)BuiltInRegistries.f_256975_.m_7745_(ColorSprayBehaviour.getId("tinted", color, "candle"))));
                continue;
            }
            glassBuilder.put((Object)color, (Object)((Block)BuiltInRegistries.f_256975_.m_7745_(ColorSprayBehaviour.getId("minecraft", color, "stained_glass"))));
            glassPaneBuilder.put((Object)color, (Object)((Block)BuiltInRegistries.f_256975_.m_7745_(ColorSprayBehaviour.getId("minecraft", color, "stained_glass_pane"))));
            terracottaBuilder.put((Object)color, (Object)((Block)BuiltInRegistries.f_256975_.m_7745_(ColorSprayBehaviour.getId("minecraft", color, "terracotta"))));
            woolBuilder.put((Object)color, (Object)((Block)BuiltInRegistries.f_256975_.m_7745_(ColorSprayBehaviour.getId("minecraft", color, "wool"))));
            carpetBuilder.put((Object)color, (Object)((Block)BuiltInRegistries.f_256975_.m_7745_(ColorSprayBehaviour.getId("minecraft", color, "carpet"))));
            concreteBuilder.put((Object)color, (Object)((Block)BuiltInRegistries.f_256975_.m_7745_(ColorSprayBehaviour.getId("minecraft", color, "concrete"))));
            concretePowderBuilder.put((Object)color, (Object)((Block)BuiltInRegistries.f_256975_.m_7745_(ColorSprayBehaviour.getId("minecraft", color, "concrete_powder"))));
            shulkerBoxBuilder.put((Object)color, (Object)((Block)BuiltInRegistries.f_256975_.m_7745_(ColorSprayBehaviour.getId("minecraft", color, "shulker_box"))));
            candleBuilder.put((Object)color, (Object)((Block)BuiltInRegistries.f_256975_.m_7745_(ColorSprayBehaviour.getId("minecraft", color, "candle"))));
        }
        GLASS_MAP = glassBuilder.build();
        GLASS_PANE_MAP = glassPaneBuilder.build();
        TERRACOTTA_MAP = terracottaBuilder.build();
        WOOL_MAP = woolBuilder.build();
        CARPET_MAP = carpetBuilder.build();
        CONCRETE_MAP = concreteBuilder.build();
        CONCRETE_POWDER_MAP = concretePowderBuilder.build();
        SHULKER_BOX_MAP = shulkerBoxBuilder.build();
        CANDLE_MAP = candleBuilder.build();
        SEAT_MAP = seatBuilder.build();
    }
}

