/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import com.google.common.collect.ImmutableList;
import com.gregtechceu.gtceu.api.item.component.ICustomDescriptionId;
import com.gregtechceu.gtceu.api.item.component.ICustomRenderer;
import com.gregtechceu.gtceu.api.item.component.ISubItemHandler;
import com.gregtechceu.gtceu.client.renderer.cover.FacadeCoverRenderer;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacadeItemBehaviour
implements ISubItemHandler,
ICustomDescriptionId,
ICustomRenderer {
    @Override
    @NotNull
    public IRenderer getRenderer() {
        return FacadeCoverRenderer.INSTANCE;
    }

    @Override
    @Nullable
    public Component getItemName(ItemStack stack) {
        ItemStack facadeStack = FacadeItemBehaviour.getFacadeStack(stack);
        return Component.m_237110_((String)stack.m_41778_(), (Object[])new Object[]{facadeStack.m_41786_()});
    }

    @Override
    public void fillItemCategory(Item item, CreativeModeTab category, NonNullList<ItemStack> items) {
        ImmutableList validFacades = ImmutableList.of((Object)new ItemStack((ItemLike)Blocks.f_50069_), (Object)GTBlocks.COIL_CUPRONICKEL.asStack(), (Object)new ItemStack((ItemLike)Blocks.f_50058_));
        for (ItemStack facadeStack : validFacades) {
            ItemStack resultStack = item.m_7968_();
            FacadeItemBehaviour.setFacadeStack(resultStack, facadeStack);
            items.add((Object)resultStack);
        }
    }

    public static void setFacadeStack(ItemStack itemStack, ItemStack facadeStack) {
        facadeStack = facadeStack.m_41777_();
        facadeStack.m_41764_(1);
        if (!FacadeItemBehaviour.isValidFacade(facadeStack)) {
            facadeStack = new ItemStack((ItemLike)Blocks.f_50069_);
        }
        if (!itemStack.m_41782_()) {
            itemStack.m_41751_(new CompoundTag());
        }
        CompoundTag tagCompound = Objects.requireNonNull(itemStack.m_41783_());
        tagCompound.m_128365_("Facade", (Tag)facadeStack.m_41739_(new CompoundTag()));
    }

    public static boolean isValidFacade(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        BlockState rawBlockState = blockItem.m_40614_().m_49966_();
        return !rawBlockState.m_155947_() && rawBlockState.m_60799_() == RenderShape.MODEL;
    }

    public static ItemStack getFacadeStack(ItemStack itemStack) {
        ItemStack unsafeStack = FacadeItemBehaviour.getFacadeStackUnsafe(itemStack);
        if (unsafeStack == null) {
            return new ItemStack((ItemLike)Blocks.f_50069_);
        }
        return unsafeStack;
    }

    @Nullable
    private static ItemStack getFacadeStackUnsafe(ItemStack itemStack) {
        CompoundTag tagCompound = itemStack.m_41783_();
        if (tagCompound == null || !tagCompound.m_128425_("Facade", 10)) {
            return null;
        }
        ItemStack facadeStack = ItemStack.m_41712_((CompoundTag)tagCompound.m_128469_("Facade"));
        if (facadeStack.m_41619_() || !FacadeItemBehaviour.isValidFacade(facadeStack)) {
            return null;
        }
        return facadeStack;
    }
}

