/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.armor;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.item.armor.ArmorComponentItem;
import com.gregtechceu.gtceu.api.item.armor.ArmorUtils;
import com.gregtechceu.gtceu.api.item.armor.IArmorLogic;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IDurabilityBar;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.api.item.component.IItemHUDProvider;
import com.gregtechceu.gtceu.api.item.component.ISubItemHandler;
import com.gregtechceu.gtceu.api.item.component.forge.IComponentCapability;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.item.armor.IJetpack;
import com.gregtechceu.gtceu.utils.GradientUtil;
import com.gregtechceu.gtceu.utils.input.KeyBind;
import com.lowdragmc.lowdraglib.Platform;
import it.unimi.dsi.fastutil.objects.AbstractObject2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PowerlessJetpack
implements IArmorLogic,
IJetpack,
IItemHUDProvider {
    public static final AbstractObject2IntMap<FluidIngredient> FUELS = new Object2IntOpenHashMap();
    public static final int tankCapacity = 16000;
    private FluidIngredient currentFuel = FluidIngredient.EMPTY;
    private FluidIngredient previousFuel = FluidIngredient.EMPTY;
    private int burnTimer = 0;
    @OnlyIn(value=Dist.CLIENT)
    private ArmorUtils.ModularHUD HUD;

    public PowerlessJetpack() {
        if (Platform.isClient()) {
            this.HUD = new ArmorUtils.ModularHUD();
        }
    }

    @Override
    public void onArmorTick(Level world, Player player, @NotNull ItemStack stack) {
        if (!FluidUtil.getFluidHandler((ItemStack)stack).isPresent()) {
            return;
        }
        CompoundTag data = stack.m_41784_();
        if (data.m_128441_("burnTimer")) {
            this.burnTimer = data.m_128448_("burnTimer");
        }
        if (!data.m_128441_("enabled")) {
            data.m_128379_("enabled", true);
            data.m_128379_("hover", false);
            data.m_128344_("toggleTimer", (byte)0);
        }
        boolean jetpackEnabled = data.m_128471_("enabled");
        boolean hoverMode = data.m_128471_("hover");
        int toggleTimer = data.m_128445_("toggleTimer");
        String messageKey = null;
        if (toggleTimer == 0) {
            if (KeyBind.JETPACK_ENABLE.isKeyDown(player)) {
                jetpackEnabled = !jetpackEnabled;
                messageKey = "metaarmor.jetpack.flight." + (jetpackEnabled ? "enable" : "disable");
                data.m_128379_("enabled", jetpackEnabled);
            } else if (KeyBind.ARMOR_HOVER.isKeyDown(player)) {
                hoverMode = !hoverMode;
                messageKey = "metaarmor.jetpack.hover." + (hoverMode ? "enable" : "disable");
                data.m_128379_("hover", hoverMode);
            }
            if (messageKey != null) {
                toggleTimer = 5;
                if (!world.f_46443_) {
                    player.m_5661_((Component)Component.m_237115_((String)messageKey), true);
                }
            }
        }
        if (toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
        }
        data.m_128344_("toggleTimer", (byte)toggleTimer);
        if (this.currentFuel.isEmpty()) {
            this.findNewRecipe(stack);
        }
        this.performFlying(player, jetpackEnabled, hoverMode, stack);
        data.m_128376_("burnTimer", (short)this.burnTimer);
    }

    @Override
    public ArmorItem.Type getArmorType() {
        return ArmorItem.Type.CHESTPLATE;
    }

    @Override
    public int getArmorDisplay(Player player, @NotNull ItemStack armor, EquipmentSlot slot) {
        return 0;
    }

    @Override
    public void addToolComponents(@NotNull ArmorComponentItem item) {
        item.attachComponents(new Behaviour(16000));
    }

    @Override
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return GTCEu.id("textures/armor/liquid_fuel_jetpack.png");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawHUD(@NotNull ItemStack item, GuiGraphics guiGraphics) {
        IFluidHandler tank = FluidUtil.getFluidHandler((ItemStack)item).resolve().orElse(null);
        if (tank != null) {
            if (tank.getFluidInTank(0).getAmount() == 0) {
                return;
            }
            String formated = String.format("%.1f", Float.valueOf((float)tank.getFluidInTank(0).getAmount() * 100.0f / (float)tank.getTankCapacity(0)));
            this.HUD.newString((Component)Component.m_237110_((String)"metaarmor.hud.fuel_lvl", (Object[])new Object[]{formated + "%"}));
            CompoundTag data = item.m_41783_();
            if (data != null) {
                MutableComponent result;
                MutableComponent status;
                if (data.m_128441_("enabled")) {
                    status = data.m_128471_("enabled") ? Component.m_237115_((String)"metaarmor.hud.status.enabled") : Component.m_237115_((String)"metaarmor.hud.status.disabled");
                    result = Component.m_237110_((String)"metaarmor.hud.engine_enabled", (Object[])new Object[]{status});
                    this.HUD.newString((Component)result);
                }
                if (data.m_128441_("hover")) {
                    status = data.m_128471_("hover") ? Component.m_237115_((String)"metaarmor.hud.status.enabled") : Component.m_237115_((String)"metaarmor.hud.status.disabled");
                    result = Component.m_237110_((String)"metaarmor.hud.hover_mode", (Object[])new Object[]{status});
                    this.HUD.newString((Component)result);
                }
            }
        }
        this.HUD.draw(guiGraphics);
        this.HUD.reset();
    }

    @Override
    public int getEnergyPerUse() {
        return 1;
    }

    @Override
    public boolean canUseEnergy(ItemStack stack, int amount) {
        if (this.currentFuel.isEmpty()) {
            return false;
        }
        if (this.burnTimer > 0) {
            return true;
        }
        Boolean ret = FluidUtil.getFluidHandler((ItemStack)stack).map(h -> h.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)).map(drained -> drained.getAmount() >= this.currentFuel.getAmount()).orElse(Boolean.FALSE);
        if (!ret.booleanValue()) {
            this.currentFuel = FluidIngredient.EMPTY;
        }
        return ret;
    }

    @Override
    public void drainEnergy(ItemStack stack, int amount) {
        if (this.burnTimer == 0) {
            FluidUtil.getFluidHandler((ItemStack)stack).ifPresent(h -> h.drain(this.currentFuel.getAmount(), IFluidHandler.FluidAction.EXECUTE));
            this.burnTimer = FUELS.getInt((Object)this.currentFuel);
        }
        this.burnTimer -= amount;
    }

    @Override
    public boolean hasEnergy(ItemStack stack) {
        return this.burnTimer > 0 || !this.currentFuel.isEmpty();
    }

    public void findNewRecipe(@NotNull ItemStack stack) {
        FluidUtil.getFluidContained((ItemStack)stack).ifPresentOrElse(fluid -> {
            if (!this.previousFuel.isEmpty() && this.previousFuel.test((FluidStack)fluid) && fluid.getAmount() >= this.previousFuel.getAmount()) {
                this.currentFuel = this.previousFuel;
                return;
            }
            for (FluidIngredient fuel : FUELS.keySet()) {
                if (!fuel.test((FluidStack)fluid) || fluid.getAmount() < fuel.getAmount()) continue;
                this.previousFuel = this.currentFuel = fuel;
            }
        }, () -> {
            this.currentFuel = FluidIngredient.EMPTY;
        });
    }

    public static class Behaviour
    implements IDurabilityBar,
    IItemComponent,
    ISubItemHandler,
    IAddInformation,
    IInteractionItem,
    IComponentCapability {
        public final int maxCapacity;
        private final Pair<Integer, Integer> durabilityBarColors;

        public Behaviour(int internalCapacity) {
            this.maxCapacity = internalCapacity;
            this.durabilityBarColors = GradientUtil.getGradient(12037896, 10);
        }

        @Override
        public float getDurabilityForDisplay(@NotNull ItemStack itemStack) {
            return FluidUtil.getFluidContained((ItemStack)itemStack).map(stack -> Float.valueOf((float)stack.getAmount() / (float)this.maxCapacity)).orElse(Float.valueOf(0.0f)).floatValue();
        }

        @Override
        @Nullable
        public Pair<Integer, Integer> getDurabilityColorsForDisplay(ItemStack itemStack) {
            return this.durabilityBarColors;
        }

        @Override
        @NotNull
        public <T> LazyOptional<T> getCapability(ItemStack itemStack, @NotNull Capability<T> cap) {
            return ForgeCapabilities.FLUID_HANDLER_ITEM.orEmpty(cap, LazyOptional.of(() -> new FluidHandlerItemStack(itemStack, this.maxCapacity){

                public boolean canFillFluidType(FluidStack fluid) {
                    for (FluidIngredient ingredient : FUELS.keySet()) {
                        if (!ingredient.test(fluid)) continue;
                        return true;
                    }
                    return false;
                }
            }));
        }

        @Override
        public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
            CompoundTag data = stack.m_41784_();
            boolean enabled = !data.m_128441_("enabled") || data.m_128471_("enabled");
            MutableComponent state = enabled ? Component.m_237115_((String)"metaarmor.hud.status.enabled") : Component.m_237115_((String)"metaarmor.hud.status.disabled");
            tooltipComponents.add((Component)Component.m_237110_((String)"metaarmor.hud.engine_enabled", (Object[])new Object[]{state}));
            boolean hover = data.m_128441_("hover") && data.m_128471_("hover");
            state = hover ? Component.m_237115_((String)"metaarmor.hud.status.enabled") : Component.m_237115_((String)"metaarmor.hud.status.disabled");
            tooltipComponents.add((Component)Component.m_237110_((String)"metaarmor.hud.hover_mode", (Object[])new Object[]{state}));
        }

        @Override
        public void fillItemCategory(Item item, CreativeModeTab category, NonNullList<ItemStack> items) {
            ItemStack copy = item.m_7968_();
            IFluidHandler fluidHandlerItem = FluidUtil.getFluidHandler((ItemStack)copy).resolve().orElse(null);
            if (fluidHandlerItem != null) {
                fluidHandlerItem.fill(GTMaterials.Diesel.getFluid(16000), IFluidHandler.FluidAction.SIMULATE);
                items.add((Object)copy);
            } else {
                items.add((Object)copy);
            }
        }
    }
}

