/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.google.common.collect.ImmutableSet;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.item.tool.aoe.AoESymmetrical;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrassPathBehavior
implements IToolBehavior {
    public static final GrassPathBehavior INSTANCE = GrassPathBehavior.create();

    protected GrassPathBehavior() {
    }

    protected static GrassPathBehavior create() {
        return new GrassPathBehavior();
    }

    @Override
    @NotNull
    public InteractionResult onItemUse(UseOnContext context) {
        Object blocks;
        if (context.m_43719_() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        InteractionHand hand = context.m_43724_();
        ItemStack stack = player.m_21120_(hand);
        AoESymmetrical aoeDefinition = ToolHelper.getAoEDefinition(stack);
        if (level.m_8055_(pos.m_7494_()).m_60795_() && this.isBlockPathConvertible(stack, level, player, pos, context)) {
            if (aoeDefinition == AoESymmetrical.none()) {
                blocks = ImmutableSet.of((Object)pos);
            } else {
                HitResult rayTraceResult = ToolHelper.getPlayerDefaultRaytrace(player);
                if (rayTraceResult == null) {
                    return InteractionResult.PASS;
                }
                if (rayTraceResult.m_6662_() != HitResult.Type.BLOCK) {
                    return InteractionResult.PASS;
                }
                if (!(rayTraceResult instanceof BlockHitResult)) {
                    return InteractionResult.PASS;
                }
                BlockHitResult blockHitResult = (BlockHitResult)rayTraceResult;
                if (blockHitResult.m_82434_() == null) {
                    return InteractionResult.PASS;
                }
                blocks = GrassPathBehavior.getPathConvertibleBlocks(stack, aoeDefinition, level, player, rayTraceResult);
                blocks.add(blockHitResult.m_82425_());
            }
        } else {
            return InteractionResult.PASS;
        }
        boolean pathed = false;
        Iterator iterator = blocks.iterator();
        while (iterator.hasNext()) {
            BlockPos blockPos = (BlockPos)iterator.next();
            BlockState newState = this.getFlattened(level.m_8055_(blockPos), new UseOnContext(player, hand, context.m_43718_().m_82430_(blockPos)));
            if (newState == null) continue;
            pathed |= level.m_7731_(blockPos, newState, 3);
            if (!player.m_7500_()) {
                ToolHelper.damageItem(context.m_43722_(), (LivingEntity)context.m_43723_());
            }
            if (!stack.m_41619_()) continue;
            break;
        }
        if (pathed) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12406_, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_6674_(hand);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static Set<BlockPos> getPathConvertibleBlocks(ItemStack stack, AoESymmetrical aoeDefinition, Level world, Player player, HitResult rayTraceResult) {
        return ToolHelper.iterateAoE(stack, aoeDefinition, world, player, rayTraceResult, INSTANCE::isBlockPathConvertible);
    }

    protected boolean isBlockPathConvertible(ItemStack stack, Level level, Player player, BlockPos pos, UseOnContext context) {
        if (level.m_8055_(pos.m_7494_()).m_60795_()) {
            BlockState state = level.m_8055_(pos);
            BlockState newState = state.getToolModifiedState(context, ToolActions.SHOVEL_FLATTEN, false);
            return newState != null && newState != state;
        }
        return false;
    }

    protected BlockState getFlattened(BlockState unFlattenedState, UseOnContext context) {
        return unFlattenedState.getToolModifiedState(context, ToolActions.SHOVEL_FLATTEN, false);
    }

    @Override
    public void addInformation(@NotNull ItemStack stack, @Nullable Level Level2, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.gtceu.tool.behavior.grass_path"));
    }
}

