/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.SimpleTieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.IEnvironmentalHazardCleaner;
import com.gregtechceu.gtceu.common.blockentity.DuctPipeBlockEntity;
import com.gregtechceu.gtceu.common.capability.EnvironmentalHazardSavedData;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.network.GTNetwork;
import com.gregtechceu.gtceu.common.network.packets.hazard.SPacketRemoveHazardZone;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.networking.IPacket;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;

public class AirScrubberMachine
extends SimpleTieredMachine
implements IEnvironmentalHazardCleaner {
    public static final float MIN_CLEANING_PER_OPERATION = 10.0f;
    private final float cleaningPerOperation;
    private float removedLastSecond;

    public AirScrubberMachine(IMachineBlockEntity holder, int tier, Object ... args) {
        super(holder, tier, GTMachines.largeTankSizeFunction, args);
        this.cleaningPerOperation = 10.0f * (float)tier;
    }

    @Override
    public boolean dampingWhenWaiting() {
        return false;
    }

    @Override
    public void cleanHazard(MedicalCondition condition, float amount) {
        if (this.recipeLogic.isActive()) {
            return;
        }
        GTRecipeBuilder builder = GTRecipeTypes.AIR_SCRUBBER_RECIPES.recipeBuilder(condition.name + "_autogen", new Object[0]).duration(200).EUt(GTValues.VHA[1]);
        condition.recipeModifier.accept(builder);
        this.recipeLogic.checkMatchedRecipeAvailable(builder.buildRawRecipe());
    }

    @Override
    public boolean onWorking() {
        if (!super.onWorking()) {
            return false;
        }
        if (!ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
            return true;
        }
        if (this.getOffsetTimer() % 20L == 0L) {
            this.removedLastSecond = 0.0f;
            for (Direction dir : GTUtil.DIRECTIONS) {
                DuctPipeBlockEntity duct;
                BlockEntity blockEntity;
                BlockPos offset = this.getPos().m_121945_(dir);
                if (GTCapabilityHelper.getHazardContainer(this.getLevel(), offset, dir.m_122424_()) == null || (blockEntity = this.getLevel().m_7702_(offset)) instanceof DuctPipeBlockEntity && !(duct = (DuctPipeBlockEntity)blockEntity).isConnected(dir.m_122424_())) continue;
                return true;
            }
            ServerLevel serverLevel = (ServerLevel)this.getLevel();
            EnvironmentalHazardSavedData savedData = EnvironmentalHazardSavedData.getOrCreate(serverLevel);
            ChunkPos pos = new ChunkPos(this.getPos());
            Object2FloatOpenHashMap relativePositions = new Object2FloatOpenHashMap();
            int radius = this.tier / 2;
            if (radius <= 0) {
                relativePositions.put((Object)pos, 1.0f);
            } else {
                for (int x = -radius; x <= radius; ++x) {
                    for (int z = -radius; z <= radius; ++z) {
                        relativePositions.put((Object)new ChunkPos(pos.f_45578_ + x, pos.f_45579_ + z), Mth.m_14116_((float)Mth.m_14040_((int)(x * z))) + 1.0f);
                    }
                }
            }
            for (ChunkPos rel : relativePositions.keySet()) {
                float distance = relativePositions.getFloat((Object)rel);
                savedData.getHazardZones().compute(rel, (chunkPos, zone) -> {
                    if (zone == null || zone.strength() <= 0.0f) {
                        return null;
                    }
                    float toClean = this.cleaningPerOperation / distance;
                    this.removedLastSecond += toClean;
                    zone.removeStrength(toClean);
                    if (zone.strength() <= 0.0f) {
                        if (serverLevel.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_)) {
                            LevelChunk chunk = serverLevel.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
                            GTNetwork.NETWORK.sendToTrackingChunk((IPacket)new SPacketRemoveHazardZone((ChunkPos)chunkPos), chunk);
                        }
                        return null;
                    }
                    return zone;
                });
            }
        }
        return true;
    }

    @Override
    public float getRemovedLastSecond() {
        return this.removedLastSecond;
    }
}

