/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.electric;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.TieredEnergyMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.objects.Object2BooleanFunction;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class WorldAcceleratorMachine
extends TieredEnergyMachine
implements IControllable {
    private static final Map<String, Class<?>> blacklistedClasses = new Object2ObjectOpenHashMap();
    private static final Object2BooleanFunction<Class<? extends BlockEntity>> blacklistCache = new Object2BooleanOpenHashMap();
    private static boolean gatheredClasses = false;
    private static final List<String> blockEntityClassNamesBlackList = new ArrayList<String>();
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(WorldAcceleratorMachine.class, TieredEnergyMachine.MANAGED_FIELD_HOLDER);
    private static final long blockEntityAmperage = 6L;
    private static final long randomTickAmperage = 3L;
    private static final int[] SUCCESS_LIMITS = new int[]{1, 8, 27, 64, 125, 216, 343, 512};
    private final int speed;
    private final int successLimit;
    private final int randRange;
    @Persisted
    @DescSynced
    private boolean isWorkingEnabled = true;
    @Persisted
    @DescSynced
    private boolean isRandomTickMode = true;
    @Persisted
    @DescSynced
    @RequireRerender
    private boolean active = false;
    private TickableSubscription tickSubs;

    public WorldAcceleratorMachine(IMachineBlockEntity holder, int tier, Object ... args) {
        super(holder, tier, GTMachines.defaultTankSizeFunction, args);
        this.speed = (int)Math.pow(2.0, tier);
        this.successLimit = SUCCESS_LIMITS[tier - 1];
        this.randRange = (this.getTier() << 1) + 1;
    }

    @Override
    @NotNull
    protected NotifiableEnergyContainer createEnergyContainer(Object ... args) {
        long tierVoltage = GTValues.V[this.getTier()];
        return new NotifiableEnergyContainer(this, tierVoltage * 256L, tierVoltage, 8L, 0L, 0L);
    }

    @Override
    @NotNull
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void updateSubscription() {
        if (this.isWorkingEnabled && this.drainEnergy(true)) {
            this.tickSubs = this.subscribeServerTick(this.tickSubs, this::update);
            this.active = true;
        } else if (this.tickSubs != null) {
            this.tickSubs.unsubscribe();
            this.tickSubs = null;
            this.active = false;
        }
    }

    public void update() {
        this.drainEnergy(false);
        if (this.isRandomTickMode) {
            BlockPos cornerPos = new BlockPos(this.getPos().m_123341_() - this.getTier(), this.getPos().m_123342_() - this.getTier(), this.getPos().m_123343_() - this.getTier());
            int attempts = this.successLimit * 3;
            int i = 0;
            for (int j = 0; i < this.successLimit && j < attempts; ++j) {
                BlockPos randomPos = cornerPos.m_7918_(GTValues.RNG.m_188503_(this.randRange), GTValues.RNG.m_188503_(this.randRange), GTValues.RNG.m_188503_(this.randRange));
                if (randomPos.m_123342_() > this.getLevel().m_151558_() || randomPos.m_123342_() < this.getLevel().m_141937_() || !this.getLevel().m_46749_(randomPos) || randomPos.equals((Object)this.getPos())) continue;
                if (this.getLevel().m_8055_(randomPos).m_60823_()) {
                    this.getLevel().m_8055_(randomPos).m_222972_((ServerLevel)this.getLevel(), randomPos, GTValues.RNG);
                }
                ++i;
            }
        } else {
            for (Direction dir : GTUtil.DIRECTIONS) {
                BlockEntity blockEntity = this.getLevel().m_7702_(this.getPos().m_121945_(dir));
                if (blockEntity == null || !this.canAccelerate(blockEntity)) continue;
                this.tickBlockEntity(blockEntity);
            }
        }
        this.updateSubscription();
    }

    public boolean drainEnergy(boolean simulate) {
        long toDrain = (this.isRandomTickMode ? 3L : 6L) * GTValues.V[this.tier];
        long resultEnergy = this.energyContainer.getEnergyStored() - toDrain;
        if (resultEnergy >= 0L && resultEnergy <= this.energyContainer.getEnergyCapacity()) {
            if (!simulate) {
                this.energyContainer.removeEnergy(toDrain);
            }
            return true;
        }
        return false;
    }

    private <T extends BlockEntity> void tickBlockEntity(@NotNull T blockEntity) {
        BlockPos pos = blockEntity.m_58899_();
        BlockEntityTicker blockEntityTicker = this.getLevel().m_8055_(pos).m_155944_(this.getLevel(), blockEntity.m_58903_());
        if (blockEntityTicker == null) {
            return;
        }
        for (int i = 0; i < this.speed - 1; ++i) {
            blockEntityTicker.m_155252_(blockEntity.m_58904_(), blockEntity.m_58899_(), blockEntity.m_58900_(), blockEntity);
        }
    }

    private boolean canAccelerate(BlockEntity blockEntity) {
        if (blockEntity instanceof PipeBlockEntity || blockEntity instanceof IMachineBlockEntity) {
            return false;
        }
        WorldAcceleratorMachine.generateWorldAcceleratorBlacklist();
        Class<?> blockEntityClass = blockEntity.getClass();
        if (blacklistCache.containsKey(blockEntityClass)) {
            return blacklistCache.getBoolean(blockEntityClass);
        }
        for (Class<?> clazz : blacklistedClasses.values()) {
            if (!clazz.isAssignableFrom(blockEntityClass)) continue;
            blacklistCache.put(blockEntityClass, false);
            return false;
        }
        blacklistCache.put(blockEntityClass, true);
        return true;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            this.energyContainer.addChangedListener(this::updateSubscription);
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.tickSubs != null) {
            this.tickSubs.unsubscribe();
            this.tickSubs = null;
        }
    }

    @Override
    public void setWorkingEnabled(boolean workingEnabled) {
        this.isWorkingEnabled = workingEnabled;
        this.updateSubscription();
    }

    @Override
    public ResourceTexture sideTips(Player player, BlockPos pos, BlockState state, Set<GTToolType> toolTypes, Direction side) {
        if (toolTypes.contains(GTToolType.SOFT_MALLET)) {
            return this.isWorkingEnabled ? GuiTextures.TOOL_PAUSE : GuiTextures.TOOL_START;
        }
        return super.sideTips(player, pos, state, toolTypes, side);
    }

    @Override
    protected InteractionResult onSoftMalletClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        IControllable controllable = GTCapabilityHelper.getControllable(this.getLevel(), this.getPos(), gridSide);
        if (controllable != null) {
            if (!this.isRemote()) {
                controllable.setWorkingEnabled(!controllable.isWorkingEnabled());
                playerIn.m_213846_((Component)Component.m_237115_((String)(controllable.isWorkingEnabled() ? "behaviour.soft_hammer.enabled" : "behaviour.soft_hammer.disabled")));
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    @NotNull
    protected InteractionResult onScrewdriverClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (!this.isRemote()) {
            this.isRandomTickMode = !this.isRandomTickMode;
            playerIn.m_213846_((Component)Component.m_237115_((String)(this.isRandomTickMode ? "gtceu.machine.world_accelerator.mode_entity" : "gtceu.machine.world_accelerator.mode_tile")));
            this.scheduleRenderUpdate();
        }
        return InteractionResult.CONSUME;
    }

    private static void generateWorldAcceleratorBlacklist() {
        if (!gatheredClasses) {
            for (String name : ConfigHolder.INSTANCE.machines.worldAcceleratorBlacklist) {
                if (blacklistedClasses.containsKey(name)) continue;
                try {
                    blacklistedClasses.put(name, Class.forName(name));
                }
                catch (ClassNotFoundException ignored) {
                    GTCEu.LOGGER.warn("Could not find class {} for World Accelerator Blacklist!", (Object)name);
                }
            }
            for (String className : blockEntityClassNamesBlackList) {
                try {
                    blacklistedClasses.put(className, Class.forName(className));
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            gatheredClasses = true;
        }
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    public boolean isRandomTickMode() {
        return this.isRandomTickMode;
    }

    public boolean isActive() {
        return this.active;
    }
}

