/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.fancyconfigurator.CircuitFancyConfigurator;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IDistinctPart;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredIOPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.ItemHandlerProxyRecipeTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemBusPartMachine
extends TieredIOPartMachine
implements IDistinctPart,
IMachineLife {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ItemBusPartMachine.class, TieredIOPartMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    private final NotifiableItemStackHandler inventory;
    @Nullable
    protected TickableSubscription autoIOSubs;
    @Nullable
    protected ISubscription inventorySubs;
    @Persisted
    protected final NotifiableItemStackHandler circuitInventory;
    protected final ItemHandlerProxyRecipeTrait combinedInventory;

    public ItemBusPartMachine(IMachineBlockEntity holder, int tier, IO io, Object ... args) {
        super(holder, tier, io);
        this.inventory = this.createInventory(args);
        this.circuitInventory = this.createCircuitItemHandler(io);
        this.combinedInventory = this.createCombinedItemHandler(io);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected int getInventorySize() {
        int sizeRoot = 1 + Math.min(9, this.getTier());
        return sizeRoot * sizeRoot;
    }

    protected NotifiableItemStackHandler createInventory(Object ... args) {
        return new NotifiableItemStackHandler(this, this.getInventorySize(), this.io);
    }

    protected NotifiableItemStackHandler createCircuitItemHandler(Object ... args) {
        IO io;
        Object object;
        if (args.length > 0 && (object = args[0]) instanceof IO && (io = (IO)object) == IO.IN) {
            return new NotifiableItemStackHandler(this, 1, IO.IN, IO.NONE).setFilter(IntCircuitBehaviour::isIntegratedCircuit);
        }
        return new NotifiableItemStackHandler(this, 0, IO.NONE);
    }

    protected ItemHandlerProxyRecipeTrait createCombinedItemHandler(Object ... args) {
        IO io;
        Object object;
        if (args.length > 0 && (object = args[0]) instanceof IO && (io = (IO)object) == IO.IN) {
            return new ItemHandlerProxyRecipeTrait(this, Set.of(this.getInventory(), this.circuitInventory), IO.IN, IO.NONE);
        }
        return new ItemHandlerProxyRecipeTrait(this, Set.of(this.getInventory(), this.circuitInventory), IO.NONE, IO.NONE);
    }

    @Override
    public void onMachineRemoved() {
        this.clearInventory((IItemHandlerModifiable)this.getInventory().storage);
        if (!ConfigHolder.INSTANCE.machines.ghostCircuit) {
            this.clearInventory((IItemHandlerModifiable)this.circuitInventory.storage);
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::updateInventorySubscription));
        }
        this.inventorySubs = this.getInventory().addChangedListener(this::updateInventorySubscription);
        this.combinedInventory.recomputeEnabledState();
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.inventorySubs != null) {
            this.inventorySubs.unsubscribe();
            this.inventorySubs = null;
        }
    }

    @Override
    public boolean isDistinct() {
        return this.io != IO.OUT && this.getInventory().isDistinct() && this.circuitInventory.isDistinct();
    }

    @Override
    public void setDistinct(boolean isDistinct) {
        this.getInventory().setDistinct(isDistinct);
        this.circuitInventory.setDistinct(isDistinct);
        this.combinedInventory.setDistinct(isDistinct);
    }

    @Override
    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateInventorySubscription();
    }

    @Override
    public void onRotated(Direction oldFacing, Direction newFacing) {
        super.onRotated(oldFacing, newFacing);
        this.updateInventorySubscription();
    }

    protected void updateInventorySubscription() {
        if (this.isWorkingEnabled() && (this.io == IO.OUT && !this.getInventory().isEmpty() || this.io == IO.IN) && GTTransferUtils.hasAdjacentItemHandler(this.getLevel(), this.getPos(), this.getFrontFacing())) {
            this.autoIOSubs = this.subscribeServerTick(this.autoIOSubs, this::autoIO);
        } else if (this.autoIOSubs != null) {
            this.autoIOSubs.unsubscribe();
            this.autoIOSubs = null;
        }
    }

    protected void autoIO() {
        if (this.getOffsetTimer() % 5L == 0L) {
            if (this.isWorkingEnabled()) {
                if (this.io == IO.OUT) {
                    this.getInventory().exportToNearby(this.getFrontFacing());
                } else if (this.io == IO.IN) {
                    this.getInventory().importFromNearby(this.getFrontFacing());
                }
            }
            this.updateInventorySubscription();
        }
    }

    @Override
    public void setWorkingEnabled(boolean workingEnabled) {
        super.setWorkingEnabled(workingEnabled);
        this.updateInventorySubscription();
    }

    @Override
    public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        if (this.io == IO.OUT) {
            IDistinctPart.super.superAttachConfigurators(configuratorPanel);
        } else if (this.io == IO.IN) {
            IDistinctPart.super.attachConfigurators(configuratorPanel);
            configuratorPanel.attachConfigurators(new CircuitFancyConfigurator(this.circuitInventory.storage));
        }
    }

    @Override
    public Widget createUIWidget() {
        int rowSize;
        int colSize = rowSize = (int)Math.sqrt(this.getInventorySize());
        if (this.getInventorySize() == 8) {
            rowSize = 4;
            colSize = 2;
        }
        WidgetGroup group = new WidgetGroup(0, 0, 18 * rowSize + 16, 18 * colSize + 16);
        WidgetGroup container = new WidgetGroup(4, 4, 18 * rowSize + 8, 18 * colSize + 8);
        int index = 0;
        for (int y = 0; y < colSize; ++y) {
            for (int x = 0; x < rowSize; ++x) {
                container.addWidget((Widget)new SlotWidget((IItemHandlerModifiable)this.getInventory().storage, index++, 4 + x * 18, 4 + y * 18, true, this.io.support(IO.IN)).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT).setIngredientIO(this.io == IO.IN ? IngredientIO.INPUT : IngredientIO.OUTPUT));
            }
        }
        container.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        group.addWidget((Widget)container);
        return group;
    }

    public NotifiableItemStackHandler getInventory() {
        return this.inventory;
    }

    public NotifiableItemStackHandler getCircuitInventory() {
        return this.circuitInventory;
    }

    public ItemHandlerProxyRecipeTrait getCombinedInventory() {
        return this.combinedInventory;
    }
}

