/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.part.MultiblockPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.FluidTankProxyTrait;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.MultiblockTankMachine;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TankValvePartMachine
extends MultiblockPartMachine {
    private FluidTankProxyTrait tankProxy;
    private ConditionalSubscriptionHandler autoIOSubscription;
    private ISubscription tankChangeListener;

    public TankValvePartMachine(IMachineBlockEntity holder, boolean isMetal, Object ... args) {
        super(holder);
        this.tankProxy = this.createTank(args);
        this.autoIOSubscription = new ConditionalSubscriptionHandler(this, this::autoIO, this::shouldAutoIO);
    }

    protected FluidTankProxyTrait createTank(Object ... args) {
        return new FluidTankProxyTrait(this, IO.BOTH);
    }

    @Override
    public boolean canShared() {
        return false;
    }

    @Override
    public void onUnload() {
        super.onUnload();
        this.autoIOSubscription.updateSubscription();
    }

    @Override
    public void addedToController(IMultiController controller) {
        super.addedToController(controller);
        if (controller instanceof MultiblockTankMachine) {
            MultiblockTankMachine multiblockTank = (MultiblockTankMachine)controller;
            this.tankProxy.setProxy(multiblockTank.getTank());
            this.unsubscribeChanges();
            this.tankChangeListener = multiblockTank.getTank().addChangedListener(this.autoIOSubscription::updateSubscription);
        }
        this.autoIOSubscription.updateSubscription();
    }

    @Override
    public void removedFromController(IMultiController controller) {
        super.removedFromController(controller);
        this.tankProxy.setProxy(null);
        this.autoIOSubscription.updateSubscription();
        this.unsubscribeChanges();
    }

    private void unsubscribeChanges() {
        if (this.tankChangeListener != null) {
            this.tankChangeListener.unsubscribe();
        }
    }

    @Override
    public void onRotated(Direction oldFacing, Direction newFacing) {
        super.onRotated(oldFacing, newFacing);
        this.autoIOSubscription.updateSubscription();
    }

    @Override
    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.autoIOSubscription.updateSubscription();
    }

    @Nullable
    private IFluidHandler getTargetTank() {
        return GTTransferUtils.getAdjacentFluidHandler(this.getLevel(), this.getPos(), this.getFrontFacing()).resolve().orElse(null);
    }

    private void autoIO() {
        if (this.getOffsetTimer() % 5L == 0L) {
            this.tankProxy.exportToNearby(this.getFrontFacing());
        }
        this.autoIOSubscription.updateSubscription();
    }

    private Boolean shouldAutoIO() {
        if (this.getControllers().isEmpty()) {
            return false;
        }
        if (this.getFrontFacing() != Direction.DOWN) {
            return false;
        }
        if (this.tankProxy.isEmpty()) {
            return false;
        }
        if (this.getTargetTank() == null) {
            return false;
        }
        return true;
    }
}

