/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.storage;

import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.PhantomFluidWidget;
import com.gregtechceu.gtceu.api.gui.widget.TankWidget;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.TieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputFluid;
import com.gregtechceu.gtceu.api.machine.feature.IDropSaveMachine;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IInteractedMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.DropSaved;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.mojang.blaze3d.MethodsReturnNonnullByDefault;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class QuantumTankMachine
extends TieredMachine
implements IAutoOutputFluid,
IInteractedMachine,
IControllable,
IDropSaveMachine,
IFancyUIMachine {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(QuantumTankMachine.class, MetaMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    @DescSynced
    @RequireRerender
    protected Direction outputFacingFluids;
    @Persisted
    @DescSynced
    @RequireRerender
    protected boolean autoOutputFluids;
    @Persisted
    protected boolean allowInputFromOutputSideFluids;
    private final int maxStoredFluids;
    @Persisted
    @DropSaved
    protected final NotifiableFluidTank cache;
    @Nullable
    protected TickableSubscription autoOutputSubs;
    @Nullable
    protected ISubscription exportFluidSubs;
    @Persisted
    @DescSynced
    @DropSaved
    protected FluidStack stored = FluidStack.EMPTY;
    @Persisted
    private boolean isVoiding;

    public QuantumTankMachine(IMachineBlockEntity holder, int tier, int maxStoredFluids, Object ... args) {
        super(holder, tier);
        this.outputFacingFluids = this.getFrontFacing().m_122424_();
        this.maxStoredFluids = maxStoredFluids;
        this.cache = this.createCacheFluidHandler(args);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected NotifiableFluidTank createCacheFluidHandler(Object ... args) {
        return new NotifiableFluidTank(this, 1, this.maxStoredFluids, IO.BOTH){

            @Override
            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                return this.handleVoiding(super.fill(resource, action), resource);
            }

            private int handleVoiding(int filled, FluidStack resource) {
                if (filled < resource.getAmount() && QuantumTankMachine.this.isVoiding && this.isFluidValid(0, resource) && (QuantumTankMachine.this.stored.isEmpty() || QuantumTankMachine.this.stored.isFluidEqual(resource))) {
                    return resource.getAmount();
                }
                return filled;
            }
        };
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.stored = this.cache.getFluidInTank(0);
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::updateAutoOutputSubscription));
        }
        this.exportFluidSubs = this.cache.addChangedListener(this::onFluidChanged);
    }

    private void onFluidChanged() {
        if (!this.isRemote()) {
            this.stored = this.cache.getFluidInTank(0);
            this.updateAutoOutputSubscription();
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.exportFluidSubs != null) {
            this.exportFluidSubs.unsubscribe();
            this.exportFluidSubs = null;
        }
    }

    @Override
    public boolean savePickClone() {
        return false;
    }

    @Override
    public void setAutoOutputFluids(boolean allow) {
        this.autoOutputFluids = allow;
        this.updateAutoOutputSubscription();
    }

    @Override
    public void setOutputFacingFluids(@Nullable Direction outputFacing) {
        this.outputFacingFluids = outputFacing;
        this.updateAutoOutputSubscription();
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isAutoOutputFluids();
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingAllowed) {
        this.setAutoOutputFluids(isWorkingAllowed);
    }

    @Override
    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateAutoOutputSubscription();
    }

    protected void updateAutoOutputSubscription() {
        Direction outputFacing = this.getOutputFacingFluids();
        if (this.isAutoOutputFluids() && !this.cache.isEmpty() && outputFacing != null && GTTransferUtils.hasAdjacentFluidHandler(this.getLevel(), this.getPos(), outputFacing)) {
            this.autoOutputSubs = this.subscribeServerTick(this.autoOutputSubs, this::checkAutoOutput);
        } else if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
            this.autoOutputSubs = null;
        }
    }

    protected void checkAutoOutput() {
        if (this.getOffsetTimer() % 5L == 0L) {
            if (this.isAutoOutputFluids() && this.getOutputFacingFluids() != null) {
                this.cache.exportToNearby(this.getOutputFacingFluids());
            }
            this.updateAutoOutputSubscription();
        }
    }

    @Override
    public boolean isFacingValid(Direction facing) {
        if (facing == this.outputFacingFluids) {
            return false;
        }
        return super.isFacingValid(facing);
    }

    @Override
    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hit.m_82434_() == this.getFrontFacing() && !this.isRemote() && FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.cache)) {
            return InteractionResult.SUCCESS;
        }
        return IInteractedMachine.super.onUse(state, world, pos, player, hand, hit);
    }

    @Override
    protected InteractionResult onWrenchClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (!playerIn.m_6144_() && !this.isRemote()) {
            ItemStack tool = playerIn.m_21120_(hand);
            if (tool.m_41773_() >= tool.m_41776_()) {
                return InteractionResult.PASS;
            }
            if (this.hasFrontFacing() && gridSide == this.getFrontFacing()) {
                return InteractionResult.PASS;
            }
            if (gridSide != this.getOutputFacingFluids()) {
                this.setOutputFacingFluids(gridSide);
            } else {
                this.setOutputFacingFluids(null);
            }
            return InteractionResult.CONSUME;
        }
        return super.onWrenchClick(playerIn, hand, gridSide, hitResult);
    }

    @Override
    protected InteractionResult onScrewdriverClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (!this.isRemote()) {
            if (gridSide == this.getOutputFacingFluids()) {
                if (this.isAllowInputFromOutputSideFluids()) {
                    this.setAllowInputFromOutputSideFluids(false);
                    playerIn.m_213846_((Component)Component.m_237115_((String)"gtceu.machine.basic.input_from_output_side.disallow").m_7220_((Component)Component.m_237115_((String)"gtceu.creative.tank.fluid")));
                } else {
                    this.setAllowInputFromOutputSideFluids(true);
                    playerIn.m_213846_((Component)Component.m_237115_((String)"gtceu.machine.basic.input_from_output_side.allow").m_7220_((Component)Component.m_237115_((String)"gtceu.creative.tank.fluid")));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.onScrewdriverClick(playerIn, hand, gridSide, hitResult);
    }

    public boolean isLocked() {
        return this.cache.isLocked();
    }

    protected void setLocked(boolean locked) {
        if (!this.stored.isEmpty() && locked) {
            FluidStack copied = this.stored.copy();
            copied.setAmount(this.cache.getLockedFluid().getCapacity());
            this.cache.setLocked(true, copied);
        } else if (!locked) {
            this.cache.setLocked(false);
        }
    }

    protected void setLocked(FluidStack fluid) {
        if (fluid.isEmpty()) {
            this.setLocked(false);
        } else if (this.stored.isEmpty()) {
            this.cache.setLocked(false);
            this.cache.setLocked(true, fluid);
        } else if (this.stored.isFluidEqual(fluid)) {
            this.setLocked(true);
        }
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 90, 63);
        group.addWidget((Widget)new ImageWidget(4, 4, 82, 55, (IGuiTexture)GuiTextures.DISPLAY)).addWidget((Widget)new LabelWidget(8, 8, "gtceu.gui.fluid_amount")).addWidget((Widget)new LabelWidget(8, 18, () -> String.valueOf(this.cache.getFluidInTank(0).getAmount())).setTextColor(-1).setDropShadow(false)).addWidget((Widget)new TankWidget(this.cache.getStorages()[0], 68, 23, true, true).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT)).addWidget((Widget)new PhantomFluidWidget((IFluidHandler)this.cache.getLockedFluid(), 0, 68, 41, 18, 18, () -> this.cache.getLockedFluid().getFluid(), this::setLocked).setShowAmount(false).setBackground((IGuiTexture)ColorPattern.T_GRAY.rectTexture())).addWidget((Widget)new ToggleButtonWidget(4, 41, 18, 18, (IGuiTexture)GuiTextures.BUTTON_FLUID_OUTPUT, this::isAutoOutputFluids, this::setAutoOutputFluids).setShouldUseBaseBackground().setTooltipText("gtceu.gui.fluid_auto_output.tooltip")).addWidget((Widget)new ToggleButtonWidget(22, 41, 18, 18, (IGuiTexture)GuiTextures.BUTTON_LOCK, this::isLocked, this::setLocked).setShouldUseBaseBackground().setTooltipText("gtceu.gui.fluid_lock.tooltip")).addWidget((Widget)new ToggleButtonWidget(40, 41, 18, 18, (IGuiTexture)GuiTextures.BUTTON_VOID, this::isVoiding, this::setVoiding).setShouldUseBaseBackground().setTooltipText("gtceu.gui.fluid_voiding_partial.tooltip"));
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    @Override
    public ResourceTexture sideTips(Player player, BlockPos pos, BlockState state, Set<GTToolType> toolTypes, Direction side) {
        if (toolTypes.contains(GTToolType.WRENCH)) {
            if (!(player.m_6144_() || this.hasFrontFacing() && side == this.getFrontFacing())) {
                return GuiTextures.TOOL_IO_FACING_ROTATION;
            }
        } else if (toolTypes.contains(GTToolType.SCREWDRIVER)) {
            if (side == this.getOutputFacingFluids()) {
                return GuiTextures.TOOL_ALLOW_INPUT;
            }
        } else if (toolTypes.contains(GTToolType.SOFT_MALLET) && side == this.getFrontFacing()) {
            return null;
        }
        return super.sideTips(player, pos, state, toolTypes, side);
    }

    @Override
    public Direction getOutputFacingFluids() {
        return this.outputFacingFluids;
    }

    @Override
    public boolean isAutoOutputFluids() {
        return this.autoOutputFluids;
    }

    @Override
    public boolean isAllowInputFromOutputSideFluids() {
        return this.allowInputFromOutputSideFluids;
    }

    @Override
    public void setAllowInputFromOutputSideFluids(boolean allowInputFromOutputSideFluids) {
        this.allowInputFromOutputSideFluids = allowInputFromOutputSideFluids;
    }

    public int getMaxStoredFluids() {
        return this.maxStoredFluids;
    }

    public NotifiableFluidTank getCache() {
        return this.cache;
    }

    public FluidStack getStored() {
        return this.stored;
    }

    public boolean isVoiding() {
        return this.isVoiding;
    }

    public void setVoiding(boolean isVoiding) {
        this.isVoiding = isVoiding;
    }
}

