/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.trait.miner;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.common.machine.trait.miner.MinerLogic;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;

public class LargeMinerLogic
extends MinerLogic {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(LargeMinerLogic.class, MinerLogic.MANAGED_FIELD_HOLDER);
    private static final int CHUNK_LENGTH = 16;
    private int voltageTier;
    private int overclockAmount = 0;
    @Persisted
    private boolean isChunkMode;
    @Persisted
    private boolean isSilkTouchMode;

    public LargeMinerLogic(IRecipeLogicMachine machine, int fortune, int speed, int maximumRadius) {
        super(machine, fortune, speed, maximumRadius);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void initPos(@NotNull BlockPos pos, int currentRadius) {
        if (!this.isChunkMode) {
            super.initPos(pos, currentRadius);
        } else {
            Direction dir = super.getDir();
            ServerLevel world = (ServerLevel)this.getMachine().getLevel();
            ChunkAccess origin = world.m_46865_(pos);
            ChunkPos startPos = world.m_6325_(origin.m_7697_().f_45578_ - currentRadius / 16, origin.m_7697_().f_45579_ - currentRadius / 16).m_7697_();
            this.x = startPos.m_45604_();
            this.y = dir == Direction.UP ? pos.m_123342_() + 1 : pos.m_123342_() - 1;
            this.z = startPos.m_45605_();
            this.startX = startPos.m_45604_();
            this.startY = pos.m_123342_();
            this.startZ = startPos.m_45605_();
            this.mineX = startPos.m_45604_();
            this.mineY = dir == Direction.UP ? pos.m_123342_() + 1 : pos.m_123342_() - 1;
            this.mineZ = startPos.m_45605_();
            this.pipeY = dir == Direction.UP ? pos.m_123342_() + 1 : pos.m_123342_() - 1;
        }
    }

    private int getDropCountMultiplier() {
        return 5;
    }

    public void setChunkMode(boolean isChunkMode) {
        if (!this.isWorking()) {
            this.isChunkMode = isChunkMode;
            if (!this.getMachine().isRemote()) {
                this.resetArea(true);
            }
        }
    }

    public void setSilkTouchMode(boolean isSilkTouchMode) {
        if (!this.isWorking()) {
            this.isSilkTouchMode = isSilkTouchMode;
        }
    }

    @Override
    public BlockPos getMiningPos() {
        return this.getMachine().getPos().m_121945_(this.getMachine().getFrontFacing().m_122424_());
    }

    @Override
    protected boolean hasPostProcessing() {
        return !this.isSilkTouchMode;
    }

    @Override
    protected void dropPostProcessing(NonNullList<ItemStack> blockDrops, List<ItemStack> outputs, BlockState blockState, LootParams.Builder builder) {
        for (ItemStack outputStack : outputs) {
            if (ChemicalHelper.getPrefix((ItemLike)outputStack.m_41720_()) == TagPrefix.crushed && this.getDropCountMultiplier() > 0) {
                ItemStack fortunePick = this.pickaxeTool.m_41777_();
                fortunePick.m_41663_(Enchantments.f_44987_, this.getDropCountMultiplier());
                outputStack = (ItemStack)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_).m_7453_().apply((Object)outputStack, (Object)new LootContext.Builder(builder.m_287286_(LootContextParams.f_81463_, (Object)fortunePick).m_287235_(LootContextParamSets.f_81421_)).m_287259_(null));
            }
            blockDrops.add((Object)outputStack);
        }
    }

    @Override
    protected boolean doPostProcessing(NonNullList<ItemStack> blockDrops, BlockState blockState, LootParams.Builder builder) {
        if (!super.doPostProcessing(blockDrops, blockState, builder) && this.getDropCountMultiplier() > 0) {
            for (ItemStack drop : blockDrops) {
                drop.m_41764_(drop.m_41613_() * this.getDropCountMultiplier());
            }
        }
        return true;
    }

    public void setVoltageTier(int voltageTier) {
        this.voltageTier = voltageTier;
    }

    @Override
    public int getVoltageTier() {
        return this.voltageTier;
    }

    public int getOverclockAmount() {
        return this.overclockAmount;
    }

    public void setOverclockAmount(int overclockAmount) {
        this.overclockAmount = overclockAmount;
    }

    public boolean isChunkMode() {
        return this.isChunkMode;
    }

    @Override
    public boolean isSilkTouchMode() {
        return this.isSilkTouchMode;
    }
}

