/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.forge;

import com.gregtechceu.gtceu.api.registry.registrate.CompassNode;
import com.gregtechceu.gtceu.api.registry.registrate.CompassSection;
import com.gregtechceu.gtceu.api.registry.registrate.SoundEntryBuilder;
import com.gregtechceu.gtceu.common.data.GTBiomeModifiers;
import com.gregtechceu.gtceu.common.data.GTConfiguredFeatures;
import com.gregtechceu.gtceu.common.data.GTDamageTypes;
import com.gregtechceu.gtceu.common.data.GTPlacements;
import com.gregtechceu.gtceu.common.data.GTWorldgen;
import com.gregtechceu.gtceu.data.tags.BiomeTagsLoader;
import com.gregtechceu.gtceu.data.tags.DamageTagsLoader;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture registries = event.getLookupProvider();
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new SoundEntryBuilder.SoundEntryProvider(packOutput, "gtceu"));
            generator.addProvider(true, (DataProvider)new CompassSection.CompassSectionProvider(packOutput, existingFileHelper));
            generator.addProvider(true, (DataProvider)new CompassNode.CompassNodeProvider(packOutput, existingFileHelper));
        }
        if (event.includeServer()) {
            Set<String> set = Set.of("gtceu");
            generator.addProvider(true, (DataProvider)new BiomeTagsLoader(packOutput, registries, existingFileHelper));
            DatapackBuiltinEntriesProvider provider = (DatapackBuiltinEntriesProvider)generator.addProvider(true, (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, registries, new RegistrySetBuilder().m_254916_(Registries.f_268580_, GTDamageTypes::bootstrap).m_254916_(Registries.f_256911_, GTConfiguredFeatures::bootstrap).m_254916_(Registries.f_256988_, GTPlacements::bootstrap).m_254916_(Registries.f_257040_, GTWorldgen::bootstrapDensityFunctions).m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, GTBiomeModifiers::bootstrap), set));
            generator.addProvider(true, (DataProvider)new DamageTagsLoader(packOutput, provider.getRegistryProvider(), existingFileHelper));
        }
    }
}

