/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.loader;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.addon.AddonFinder;
import com.gregtechceu.gtceu.api.addon.IGTAddon;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.BedrockOreDefinition;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.integration.kjs.GTCEuServerEvents;
import com.gregtechceu.gtceu.integration.kjs.events.GTBedrockOreVeinEventJS;
import com.lowdragmc.lowdraglib.Platform;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraftforge.fml.ModLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public class BedrockOreLoader
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON_INSTANCE = Deserializers.m_78799_().create();
    public static final String FOLDER = "gtceu/bedrock_ore_veins";
    protected static final Logger LOGGER = LogManager.getLogger();

    public BedrockOreLoader() {
        super(GSON_INSTANCE, FOLDER);
    }

    protected void apply(Map<ResourceLocation, JsonElement> resourceList, ResourceManager resourceManager, ProfilerFiller profiler) {
        if (GTRegistries.BEDROCK_ORE_DEFINITIONS.isFrozen()) {
            GTRegistries.BEDROCK_ORE_DEFINITIONS.unfreeze();
        }
        GTRegistries.BEDROCK_ORE_DEFINITIONS.registry().clear();
        AddonFinder.getAddons().forEach(IGTAddon::registerBedrockOreVeins);
        ModLoader.get().postEvent(new GTCEuAPI.RegisterEvent(GTRegistries.BEDROCK_ORE_DEFINITIONS, BedrockOreDefinition.class));
        if (GTCEu.isKubeJSLoaded()) {
            KJSCallWrapper.fireKJSEvent();
        }
        RegistryOps ops = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)GTRegistries.builtinRegistry());
        for (Map.Entry<ResourceLocation, JsonElement> entry : resourceList.entrySet()) {
            ResourceLocation location = entry.getKey();
            try {
                BedrockOreDefinition bedrockOre = BedrockOreLoader.fromJson(location, GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)"top element"), (RegistryOps<JsonElement>)ops);
                if (bedrockOre == null) {
                    LOGGER.info("Skipping loading bedrock ore vein {} as it's serializer returned null", (Object)location);
                }
                GTRegistries.BEDROCK_ORE_DEFINITIONS.registerOrOverride(location, bedrockOre);
            }
            catch (JsonParseException | IllegalArgumentException jsonParseException) {
                LOGGER.error("Parsing error loading bedrock ore vein {}", (Object)location, (Object)jsonParseException);
            }
        }
        if (!GTRegistries.BEDROCK_ORE_DEFINITIONS.isFrozen()) {
            GTRegistries.BEDROCK_ORE_DEFINITIONS.freeze();
        }
        if (Platform.getMinecraftServer() != null) {
            // empty if block
        }
    }

    public static BedrockOreDefinition fromJson(ResourceLocation id, JsonObject json, RegistryOps<JsonElement> ops) {
        return (BedrockOreDefinition)BedrockOreDefinition.FULL_CODEC.parse(ops, (Object)json).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
    }

    public static final class KJSCallWrapper {
        public static void fireKJSEvent() {
            GTCEuServerEvents.BEDROCK_ORE_VEIN_MODIFICATION.post((ScriptTypeHolder)ScriptType.SERVER, (EventJS)new GTBedrockOreVeinEventJS());
        }
    }
}

